/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.bean;

import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.bean.RegistryBean;
import org.apache.camel.impl.ExpressionSupport;
import org.apache.camel.language.bean.RuntimeBeanExpressionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanExpression<E extends Exchange>
extends ExpressionSupport<E> {
    private String beanName;
    private String method;

    public BeanExpression(String beanName, String method) {
        this.beanName = beanName;
        this.method = method;
    }

    public String toString() {
        return "BeanExpression[bean: " + this.beanName + " method: " + this.method + "]";
    }

    @Override
    protected String assertionFailureMessage(E exchange) {
        return "bean: " + this.beanName + " method: " + this.method;
    }

    @Override
    public Object evaluate(E exchange) {
        BeanProcessor processor = new BeanProcessor(new RegistryBean(exchange.getContext(), this.beanName));
        if (this.method != null) {
            processor.setMethod(this.method);
        }
        try {
            Exchange newExchange = exchange.copy();
            if (!newExchange.getPattern().isOutCapable()) {
                newExchange.setPattern(ExchangePattern.InOut);
            }
            processor.process(newExchange);
            return newExchange.getOut(true).getBody();
        }
        catch (Exception e) {
            throw new RuntimeBeanExpressionException((Exchange)exchange, this.beanName, this.method, e);
        }
    }
}

