/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.management.CamelNamingStrategy;
import org.apache.camel.management.DefaultInstrumentationAgent;
import org.apache.camel.management.InstrumentationErrorHandlerWrappingStrategy;
import org.apache.camel.management.InstrumentationInterceptStrategy;
import org.apache.camel.management.InstrumentationProcessor;
import org.apache.camel.management.ManagedEndpoint;
import org.apache.camel.management.ManagedRoute;
import org.apache.camel.management.ManagedService;
import org.apache.camel.management.PerformanceCounter;
import org.apache.camel.model.ExceptionType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.RouteType;
import org.apache.camel.spi.InstrumentationAgent;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationLifecycleStrategy
implements LifecycleStrategy {
    private static final transient Log LOG = LogFactory.getLog(InstrumentationProcessor.class);
    private InstrumentationAgent agent;
    private CamelNamingStrategy namingStrategy;
    private boolean initialized;
    private Map<Endpoint, InstrumentationProcessor> interceptorMap = new HashMap<Endpoint, InstrumentationProcessor>();

    public InstrumentationLifecycleStrategy() {
        this(new DefaultInstrumentationAgent());
    }

    public InstrumentationLifecycleStrategy(InstrumentationAgent agent) {
        this.agent = agent;
    }

    public InstrumentationLifecycleStrategy(InstrumentationAgent agent, CamelContext context) {
        this.agent = agent;
        this.onContextStart(context);
    }

    @Override
    public void onContextStart(CamelContext context) {
        if (context instanceof DefaultCamelContext) {
            try {
                this.initialized = true;
                DefaultCamelContext dc = (DefaultCamelContext)context;
                dc.addService(this.agent);
                this.namingStrategy = new CamelNamingStrategy(this.agent.getMBeanObjectDomainName());
                ManagedService ms = new ManagedService(dc);
                this.agent.register(ms, this.getNamingStrategy().getObjectName(dc));
            }
            catch (Exception e) {
                LOG.warn((Object)"Could not register CamelContext MBean", (Throwable)e);
            }
        }
    }

    @Override
    public void onEndpointAdd(Endpoint<? extends Exchange> endpoint) {
        if (!this.initialized) {
            return;
        }
        try {
            ManagedEndpoint me = new ManagedEndpoint(endpoint);
            this.agent.register(me, this.getNamingStrategy().getObjectName(me));
        }
        catch (JMException e) {
            LOG.warn((Object)"Could not register Endpoint MBean", (Throwable)e);
        }
    }

    @Override
    public void onRoutesAdd(Collection<Route> routes) {
        if (!this.initialized) {
            return;
        }
        for (Route route : routes) {
            try {
                ManagedRoute mr = new ManagedRoute(route);
                InstrumentationProcessor interceptor = this.interceptorMap.get(route.getEndpoint());
                if (interceptor == null) {
                    LOG.warn((Object)("Instrumentation processor not found for route endpoint " + route.getEndpoint()));
                } else {
                    interceptor.setCounter(mr);
                }
                this.agent.register(mr, this.getNamingStrategy().getObjectName(mr));
            }
            catch (JMException e) {
                LOG.warn((Object)"Could not register Route MBean", (Throwable)e);
            }
        }
    }

    @Override
    public void onServiceAdd(CamelContext context, Service service) {
        if (!this.initialized) {
            return;
        }
        if (service instanceof ServiceSupport) {
            try {
                ManagedService ms = new ManagedService((ServiceSupport)service);
                this.agent.register(ms, this.getNamingStrategy().getObjectName(context, ms));
            }
            catch (JMException e) {
                LOG.warn((Object)"Could not register Service MBean", (Throwable)e);
            }
        }
    }

    @Override
    public void onRouteContextCreate(RouteContext routeContext) {
        if (!this.initialized) {
            return;
        }
        HashMap<ProcessorType, PerformanceCounter> counterMap = new HashMap<ProcessorType, PerformanceCounter>();
        RouteType route = routeContext.getRoute();
        for (ProcessorType<?> processor : route.getOutputs()) {
            ObjectName name = null;
            try {
                name = this.getNamingStrategy().getObjectName(routeContext, processor);
                PerformanceCounter pc = new PerformanceCounter();
                this.agent.register(pc, name);
                counterMap.put(processor, pc);
            }
            catch (MalformedObjectNameException e) {
                LOG.warn((Object)("Could not create MBean name: " + name), (Throwable)e);
            }
            catch (JMException e) {
                LOG.warn((Object)("Could not register PerformanceCounter MBean: " + name), (Throwable)e);
            }
        }
        routeContext.addInterceptStrategy(new InstrumentationInterceptStrategy(counterMap));
        routeContext.setErrorHandlerWrappingStrategy(new InstrumentationErrorHandlerWrappingStrategy(counterMap));
        RouteType routeType = routeContext.getRoute();
        if (routeType.getInputs() != null && !routeType.getInputs().isEmpty()) {
            if (routeType.getInputs().size() > 1) {
                LOG.warn((Object)"Add InstrumentationProcessor to first input only.");
            }
            Endpoint endpoint = routeType.getInputs().get(0).getEndpoint();
            ArrayList exceptionHandlers = new ArrayList();
            ArrayList outputs = new ArrayList();
            for (ProcessorType<?> output : routeType.getOutputs()) {
                if (output instanceof ExceptionType) {
                    exceptionHandlers.add(output);
                    continue;
                }
                outputs.add(output);
            }
            routeType.clearOutput();
            routeType.getOutputs().addAll(exceptionHandlers);
            InstrumentationProcessor processor = new InstrumentationProcessor();
            routeType.intercept(processor);
            for (ProcessorType processorType : outputs) {
                routeType.addOutput(processorType);
            }
            this.interceptorMap.put(endpoint, processor);
        }
    }

    public CamelNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(CamelNamingStrategy strategy) {
        this.namingStrategy = strategy;
    }

    public void setAgent(InstrumentationAgent agent) {
        this.agent = agent;
    }
}

