/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.bpel;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.rtrep.common.extension.AbstractExtensionBundle;
import org.apache.ode.utils.DOMUtils;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.ode.ODEConfigProperties;
import org.eclipse.smila.ode.ODEServer;
import org.eclipse.smila.ode.ODEServerContextFactory;
import org.eclipse.smila.ode.ODEServerException;
import org.eclipse.smila.ode.WebServiceContextFactory;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.WorkflowProcessor;
import org.eclipse.smila.processing.bpel.BPELConstants;
import org.eclipse.smila.processing.bpel.MessageHelper;
import org.eclipse.smila.processing.bpel.PipeletManager;
import org.eclipse.smila.processing.bpel.PipelinePerformanceCounter;
import org.eclipse.smila.processing.bpel.SMILAExtensionBundle;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.eclipse.smila.utils.workspace.WorkspaceHelper;
import org.osgi.service.component.ComponentContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ODEWorkflowProcessor
implements WorkflowProcessor {
    private final Log _log = LogFactory.getLog(ODEWorkflowProcessor.class);
    private ODEServer _bpelServer;
    private WebServiceContextFactory _processingContext;
    private final Map<String, Blackboard> _blackboards = new Hashtable<String, Blackboard>();
    private final AtomicLong _requestIdSequence = new AtomicLong(0L);
    private final Map<String, Exception> _pipeletExceptions = new HashMap<String, Exception>();
    private Properties _properties;
    private MessageHelper _messageHelper;
    private final Map<String, PipelinePerformanceCounter> _pipelinePerformanceCounter = new HashMap<String, PipelinePerformanceCounter>();
    private final ReadWriteLock _lock = new ReentrantReadWriteLock(true);

    public ODEWorkflowProcessor() {
        this._log.debug((Object)(String.valueOf(this.getClass().getName()) + " instance created."));
    }

    public String[] process(String workflowName, Blackboard blackboard, String[] recordIds) throws ProcessingException {
        long startTime = System.nanoTime();
        int outgoingIds = 0;
        int incomingIds = 0;
        if (recordIds != null) {
            incomingIds = recordIds.length;
        }
        String requestId = this.initRequest(blackboard);
        boolean success = false;
        PipelinePerformanceCounter counter = this._pipelinePerformanceCounter.get(workflowName);
        try {
            if (this._bpelServer == null) {
                throw new ProcessingException("Cannot process request, because BPEL engine is not yet initialised");
            }
            Element message = this._messageHelper.createMessage(blackboard, recordIds);
            this._messageHelper.addRequestId(message, requestId, BPELConstants.TYPE_PROCESSORMESSAGE);
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("Request: " + DOMUtils.domToString((Node)message)));
            }
            QName processQName = new QName("http://www.eclipse.org/smila/processor", workflowName);
            try {
                Element result = this._bpelServer.invoke(processQName, "process", message);
                if (result != null) {
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("Final Result: " + DOMUtils.domToString((Node)result)));
                    }
                    String[] resultIds = this._messageHelper.parseMessage(blackboard, result);
                    success = true;
                    if (resultIds != null) {
                        outgoingIds = resultIds.length;
                    }
                    String[] stringArray = resultIds;
                    return stringArray;
                }
                return null;
            }
            catch (ODEServerException ex) {
                try {
                    Exception pipeletEx = this._pipeletExceptions.get(requestId);
                    if (pipeletEx == null) {
                        throw new ProcessingException("Error processing BPEL workflow " + workflowName + ": " + ex.getMessage(), (Throwable)ex);
                    }
                    throw new ProcessingException("Error processing BPEL workflow " + workflowName + ": " + pipeletEx.getMessage(), (Throwable)pipeletEx);
                }
                catch (ProcessingException ex2) {
                    if (counter != null) {
                        counter.addError(ex2, false);
                    }
                    throw ex2;
                }
                catch (Throwable ex3) {
                    if (counter != null) {
                        counter.addError(ex3, true);
                    }
                    throw new ProcessingException(ex3);
                }
            }
        }
        finally {
            this.cleanupRequest(requestId);
            if (counter != null) {
                counter.countInvocationNanos(System.nanoTime() - startTime, success, incomingIds, outgoingIds);
            }
        }
    }

    public List<String> getWorkflowNames() {
        if (this._pipelinePerformanceCounter == null) {
            return null;
        }
        return new ArrayList<String>(this._pipelinePerformanceCounter.keySet());
    }

    public Blackboard getBlackboard(String id) throws ProcessingException {
        Blackboard blackboard = this._blackboards.get(id);
        if (blackboard == null) {
            throw new ProcessingException("Blackboard for request " + id + " is not registered anymore.");
        }
        return blackboard;
    }

    public void setPipeletException(String requestId, Exception ex) {
        this._pipeletExceptions.put(requestId, ex);
    }

    public MessageHelper getMessageHelper() {
        return this._messageHelper;
    }

    protected void activate(ComponentContext context) {
        this._lock.writeLock().lock();
        try {
            if (this._bpelServer == null) {
                try {
                    this.readConfiguration();
                    this._messageHelper = new MessageHelper(this._properties);
                    this.initializeBPEL();
                }
                catch (IOException ex) {
                    this._log.error((Object)"Start of BPEL workflow service aborted: Could not read configuration.Service is non-functional, please fix problem and restart bundle", (Throwable)ex);
                }
                catch (ODEServerException ex) {
                    this._log.error((Object)"Start of BPEL workflow service aborted: Initialization of ODE failed.Service is non-functional, please fix problem and restart bundle", (Throwable)ex);
                }
                catch (ProcessingException ex) {
                    this._log.error((Object)"Start of BPEL workflow service aborted: Deployment of pipelines failed.Service is non-functional, please fix problem and restart bundle", (Throwable)ex);
                }
                catch (RuntimeException ex) {
                    this._log.error((Object)"Start of BPEL workflow service aborted: Unknown error.Service is non-functional, please fix problem and restart bundle", (Throwable)ex);
                }
                catch (Throwable ex) {
                    this._log.error((Object)"Start of BPEL workflow service aborted: Unknown fatal error.Service is non-functional, please fix problem and restart bundle", ex);
                }
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    protected void deactivate(ComponentContext context) {
        this._lock.writeLock().lock();
        try {
            if (this._bpelServer != null) {
                this._bpelServer.shutdown();
                this._bpelServer = null;
                this._processingContext = null;
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    private void initializeBPEL() throws IOException, ODEServerException, ProcessingException {
        this._log.debug((Object)"Initialize BPEL engine");
        ODEConfigProperties odeConfig = new ODEConfigProperties(this._properties, "ode.");
        this._processingContext = new WebServiceContextFactory();
        this._bpelServer = new ODEServer(odeConfig, (ODEServerContextFactory)this._processingContext);
        this._bpelServer.registerExtensionBundle((AbstractExtensionBundle)new SMILAExtensionBundle());
        this.deployPipelines();
        this._log.debug((Object)"Initialization of BPEL engine successful");
    }

    private void deployPipelines() throws ProcessingException, IOException {
        String pipelineDirName = this._properties.getProperty("pipeline.dir", "pipelines");
        File pipelineDeployDir = WorkspaceHelper.createWorkingDir((String)"org.eclipse.smila.processing.bpel", (String)pipelineDirName);
        this.copyPipelineDirectory(pipelineDirName, pipelineDeployDir);
        Collection processes = this._bpelServer.deploy(pipelineDeployDir);
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        for (QName processName : processes) {
            this._log.info((Object)("Registering pipeline " + processName));
            PipeletManager.getInstance().registerPipeline(this, processName);
            String pipelineName = processName.getLocalPart();
            this._pipelinePerformanceCounter.put(pipelineName, new PipelinePerformanceCounter(pipelineName));
        }
        Thread.currentThread().setContextClassLoader(oldCL);
    }

    private void copyPipelineDirectory(String pipelineConfigDirName, File pipelineDeployDir) throws IOException {
        this._log.info((Object)("Pipeline deploy directory is " + pipelineDeployDir.getAbsolutePath()));
        FileUtils.cleanDirectory((File)pipelineDeployDir);
        File configDir = ConfigUtils.getConfigFolder((String)"org.eclipse.smila.processing.bpel", (String)pipelineConfigDirName);
        FileUtils.copyDirectory((File)configDir, (File)pipelineDeployDir, (FileFilter)new NotFileFilter((IOFileFilter)new WildcardFileFilter(".*")));
        this._log.info((Object)"Pipeline configuration directory has been copied to workspace successfully.");
    }

    private void readConfiguration() throws IOException {
        this._properties = new Properties();
        InputStream configurationFileStream = null;
        try {
            try {
                configurationFileStream = ConfigUtils.getConfigStream((String)"org.eclipse.smila.processing.bpel", (String)"processor.properties");
                this._properties.load(configurationFileStream);
            }
            catch (IOException ex) {
                throw new IOException("Could not read configuration property file processor.properties: " + ex.toString());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(configurationFileStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)configurationFileStream);
    }

    private String initRequest(Blackboard blackboard) {
        this._lock.readLock().lock();
        String requestId = Long.toString(this._requestIdSequence.getAndIncrement());
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Starting to process request ID = " + requestId));
        }
        this._blackboards.put(requestId, blackboard);
        return requestId;
    }

    private void cleanupRequest(String requestId) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Cleaning up request ID = " + requestId));
        }
        this._blackboards.remove(requestId);
        this._pipeletExceptions.remove(requestId);
        this._lock.readLock().unlock();
    }
}

