/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.server.util;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.HttpHandler;
import org.eclipse.smila.http.server.util.RequestHandler;
import org.osgi.service.component.ComponentContext;

public class RequestDispatcher
implements HttpHandler {
    private static final String TARGET_PREFIX = "(rootContextPath=";
    private final ArrayList<RequestHandler> _requestHandlers = new ArrayList();
    private final Log _log = LogFactory.getLog(this.getClass());
    private String _rootContextPath;

    protected void activate(ComponentContext context) {
        this._rootContextPath = this.getRootContextPath(context);
    }

    @Override
    public String getRootContextPath() {
        return this._rootContextPath;
    }

    public synchronized void addRequestHandler(RequestHandler handler) {
        this._requestHandlers.add(handler);
        String message = "RequestDispatcher has RequestHandler " + handler.getClass().getName() + " with uri pattern " + handler.getUriPattern() + " for root context " + handler.getRootContextPath() + ".";
        System.out.println(message);
    }

    public synchronized void removeRequestHandler(RequestHandler handler) {
        if (this._requestHandlers.contains(handler)) {
            this._requestHandlers.remove(handler);
        }
    }

    @Override
    public void handle(HttpExchange he) throws IOException {
        String requestUri = he.getRequestURI();
        RequestHandler matchingHandler = this.findHandler(requestUri);
        if (matchingHandler == null) {
            throw new HttpException(404, "No RequestHandler registered at rootContext '" + this._rootContextPath + "' to handle uri '" + requestUri + "'");
        }
        try {
            String requestedMethod;
            he.setResponseHeader("Access-Control-Allow-Origin", "*");
            if ("OPTIONS".equals(he.getRequestMethod()) && (requestedMethod = he.getRequestHeader("Access-Control-Request-Method")) != null) {
                he.setResponseHeader("Access-Control-Allow-Methods", requestedMethod);
                he.setResponseHeader("Access-Control-Max-Age", "1728000");
                String customHeaders = he.getRequestHeader("Access-Control-Request-Headers");
                if (customHeaders != null) {
                    he.setResponseHeader("Access-Control-Allow-Headers", customHeaders);
                }
                he.setResponseStatus(200);
                he.getResponseStream().flush();
                return;
            }
            matchingHandler.handle(he);
        }
        catch (RuntimeException ex) {
            throw new HttpException(500, "Error executing request", (Throwable)ex);
        }
    }

    private synchronized RequestHandler findHandler(String requestUri) {
        for (RequestHandler handler : this._requestHandlers) {
            if (!handler.matches(requestUri)) continue;
            return handler;
        }
        return null;
    }

    private String getRootContextPath(ComponentContext context) {
        String rootContextPath = context.getProperties().get("RequestHandlers.target").toString();
        rootContextPath = rootContextPath.substring(TARGET_PREFIX.length(), rootContextPath.length() - 1);
        return rootContextPath;
    }
}

