/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets.xmlprocessing;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.pipelets.xmlprocessing.AXmlTransformationPipelet;
import org.eclipse.smila.processing.pipelets.xmlprocessing.util.XMLUtils;
import org.eclipse.smila.processing.pipelets.xmlprocessing.util.XPathUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XPathExtractorPipelet
extends AXmlTransformationPipelet {
    public static final String PROP_XPATH = "xpath";
    public static final String PROP_SEPARATOR = "separator";
    public static final String PROP_NAMESPACE = "namespace";
    private String _xpath;
    private String _separator;
    private String _namespace;
    private Element _namespaceElement;

    public void configure(AnyMap configuration) throws ProcessingException {
        super.configure(configuration);
        this._xpath = configuration.getStringValue(PROP_XPATH);
        if (this._xpath == null || this._xpath.trim().length() == 0) {
            throw new ProcessingException("Property xpath must not be <null> or an empty String");
        }
        this._separator = configuration.getStringValue(PROP_SEPARATOR);
        if (this._separator == null) {
            this._separator = "";
        }
        this._namespace = configuration.getStringValue(PROP_NAMESPACE);
        if (this._namespace == null) {
            this._namespace = "";
        }
        Document doc = XMLUtils.getDocument();
        this._namespaceElement = doc.createElement("NamespaceDef");
        String[] namespaces = this._namespace.split(" ");
        int i = 0;
        while (i < namespaces.length) {
            if (!"".equals(namespaces[i].trim())) {
                String[] nsItems = namespaces[i].split("=");
                if (nsItems.length != 2) {
                    throw new ProcessingException("Property namespace in invalid format [Namespace;ns1=val ns2=val]");
                }
                this._namespaceElement.setAttribute("xmlns:" + nsItems[0], nsItems[1]);
            }
            ++i;
        }
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        if (recordIds != null) {
            String[] stringArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    String id = stringArray[n2];
                    try {
                        Object result;
                        Document inputDocument = this.createDocument(blackboard, id);
                        if (inputDocument != null && (result = XPathUtils.queryForIndexField(inputDocument, this._xpath, this._namespaceElement, this._separator)) != null) {
                            if (this.isStoreInAttribute()) {
                                Value value = null;
                                value = result instanceof Boolean ? blackboard.getDataFactory().createBooleanValue((Boolean)result) : (result instanceof Double ? blackboard.getDataFactory().createDoubleValue((Double)result) : blackboard.getDataFactory().createStringValue(result.toString()));
                                blackboard.getMetadata(id).put((Object)this._outputName, (Object)value);
                            } else {
                                this.storeResult(blackboard, id, result.toString());
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!this._log.isWarnEnabled()) break block7;
                        this._log.warn((Object)("unable to transform document " + id), (Throwable)e);
                    }
                }
                ++n2;
            }
        }
        return recordIds;
    }
}

