/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.httphandler;

import java.util.List;
import java.util.UUID;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.blackboard.BlackboardFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.WorkflowProcessor;

public class PipelineProcessHandler
extends JsonRequestHandler {
    private WorkflowProcessor _processor;
    private BlackboardFactory _blackboardFactory;

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        try {
            if (inputRecord == null || inputRecord.getMetadata().isEmpty()) {
                throw new EmptyQueryException("Cannot process an empty record.");
            }
            String pipelineName = this.getWorkflowName(requestUri);
            this.ensureQueryId(pipelineName, inputRecord);
            Blackboard blackboard = this._blackboardFactory.createTransientBlackboard();
            blackboard.setRecord(inputRecord);
            String[] resultIds = this._processor.process(pipelineName, blackboard, new String[]{inputRecord.getId()});
            Record result = null;
            if (resultIds != null && resultIds.length > 0) {
                result = blackboard.getRecord(resultIds[0]);
            }
            blackboard.unload();
            return result;
        }
        catch (BlackboardAccessException ex) {
            throw new ProcessingException("Blackboard error: ", ex);
        }
    }

    public void setProcessor(WorkflowProcessor processor) {
        this._processor = processor;
    }

    public void unsetProcessor(WorkflowProcessor processor) {
        if (this._processor == processor) {
            this._processor = null;
        }
    }

    public void setBlackboardFactory(BlackboardFactory factory) {
        this._blackboardFactory = factory;
    }

    public void unsetBlackboardFactory(BlackboardFactory factory) {
        if (this._blackboardFactory == factory) {
            this._blackboardFactory = null;
        }
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method) || "POST".equals(method);
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof EmptyQueryException) {
            return 400;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    private String getWorkflowName(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            return (String)uriParts.get(0);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern " + this.getUriPattern());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureQueryId(String pipelineName, Record query) {
        if (query.getId() == null) {
            UUID uuid = null;
            PipelineProcessHandler pipelineProcessHandler = this;
            synchronized (pipelineProcessHandler) {
                uuid = UUID.randomUUID();
            }
            query.setId(String.valueOf(pipelineName) + "-" + uuid.toString());
        }
    }

    private static class EmptyQueryException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public EmptyQueryException(String message) {
            super(message);
        }
    }
}

