/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.zookeeper;

import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.eclipse.smila.zookeeper.ZkConnection;
import org.eclipse.smila.zookeeper.ZooKeeperService;

public class ZkConcurrentMap {
    private static final String ENCODING = "utf-8";
    private static final int NO_OF_TRIES_WHEN_CONFLICT = 100;
    private static final long MIN_OPERATION_TIME_TO_LOG = 200L;
    private static final int MAX_WAIT_TIME_BETWEEN_TRIES = 10;
    private final Random _waitTimeBetweenTriesGenerator = new Random(System.nanoTime());
    private final Log _log = LogFactory.getLog(this.getClass());
    private final ZkConnection _zk;
    private final String _root;

    public ZkConcurrentMap(ZooKeeperService service, String rootNodePath) {
        this(new ZkConnection(service), rootNodePath);
    }

    public ZkConcurrentMap(ZkConnection zk, String rootNodePath) {
        if (rootNodePath == null) {
            throw new NullPointerException("parameter rootNodePath is <null>");
        }
        this._zk = zk;
        this._root = rootNodePath;
        Stat stat = null;
        try {
            stat = this._zk.exists(rootNodePath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (stat == null) {
            throw new IllegalArgumentException("root zookeeper node '" + rootNodePath + "' doesn't exist!");
        }
    }

    public boolean put(final String key, final String value) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("put(), key = " + key + ", value = " + value));
        }
        if (key == null) {
            throw new NullPointerException("parameter key is <null>");
        }
        final String nodePath = String.valueOf(this._root) + '/' + key;
        try {
            final byte[] data = value.getBytes(ENCODING);
            return (Boolean)this.retryZkMapOperation(new ZkMapCallable(){

                @Override
                public String getZkOperation() {
                    return "put(): key = " + key + ", value = " + value;
                }

                @Override
                public Object call() throws Exception {
                    try {
                        if (ZkConcurrentMap.this._zk.exists(nodePath) == null) {
                            ZkConcurrentMap.this._zk.createNode(nodePath, data);
                            return true;
                        }
                    }
                    catch (KeeperException.NodeExistsException nodeExistsException) {}
                    try {
                        ZkConcurrentMap.this._zk.setData(nodePath, data);
                        return true;
                    }
                    catch (KeeperException.NoNodeException noNodeException) {
                        return new RetryOperation();
                    }
                    catch (Exception e2) {
                        throw new RuntimeException(e2);
                    }
                }

                @Override
                public Object getExceededRetriesResult() {
                    return Boolean.FALSE;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String putIfAbsent(final String key, final String value) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("putIfAbsent(), key = " + key + ", value = " + value));
        }
        if (key == null) {
            throw new NullPointerException("parameter key is <null>");
        }
        if (value == null) {
            throw new NullPointerException("parameter value is <null>");
        }
        final String nodePath = String.valueOf(this._root) + '/' + key;
        try {
            final byte[] data = value.getBytes(ENCODING);
            return (String)this.retryZkMapOperation(new ZkMapCallable(){

                @Override
                public String getZkOperation() {
                    return "put(): key = " + key + ", value = " + value;
                }

                @Override
                public Object call() throws Exception {
                    try {
                        if (ZkConcurrentMap.this._zk.exists(nodePath) == null) {
                            ZkConcurrentMap.this._zk.createNode(nodePath, data);
                        }
                    }
                    catch (KeeperException.NodeExistsException nodeExistsException) {}
                    try {
                        return new String(ZkConcurrentMap.this._zk.getData(nodePath), ZkConcurrentMap.ENCODING);
                    }
                    catch (KeeperException.NoNodeException noNodeException) {
                        return new RetryOperation();
                    }
                    catch (Exception e2) {
                        throw new RuntimeException(e2);
                    }
                }

                @Override
                public Object getExceededRetriesResult() {
                    return "<UNKNOWN_VALUE>";
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean replace(String key, String oldValue, String newValue) {
        return this.replaceAndGetVersion(key, oldValue, newValue) != null;
    }

    public Integer replaceAndGetVersion(final String key, final String oldValue, final String newValue) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("replace(), key = " + key + ", oldValue = " + oldValue + ", newValue = " + newValue));
        }
        if (key == null) {
            throw new NullPointerException("parameter key is <null>");
        }
        final String nodePath = String.valueOf(this._root) + '/' + key;
        try {
            return (Integer)this.retryZkMapOperation(new ZkMapCallable(){

                @Override
                public String getZkOperation() {
                    return "replace(), key = " + key + ", oldValue = " + oldValue + ", newValue = " + newValue;
                }

                @Override
                public Object call() throws Exception {
                    Stat stat = ZkConcurrentMap.this._zk.exists(nodePath);
                    if (stat == null) {
                        return null;
                    }
                    int version = stat.getVersion();
                    String realOldValue = new String(ZkConcurrentMap.this._zk.getData(nodePath), ZkConcurrentMap.ENCODING);
                    if (!oldValue.equals(realOldValue)) {
                        return null;
                    }
                    try {
                        return ZkConcurrentMap.this._zk.setData(nodePath, newValue.getBytes(ZkConcurrentMap.ENCODING), version).getVersion();
                    }
                    catch (KeeperException.NoNodeException noNodeException) {
                        return null;
                    }
                    catch (KeeperException.BadVersionException badVersionException) {
                        return new RetryOperation();
                    }
                }

                @Override
                public Object getExceededRetriesResult() {
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getString(String key) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("getString(), key = " + key));
        }
        if (key == null) {
            throw new NullPointerException("parameter key is <null>");
        }
        String nodePath = String.valueOf(this._root) + '/' + key;
        try {
            return new String(this._zk.getData(nodePath), ENCODING);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Integer getInt(String key) {
        String s = this.getString(key);
        if (s == null) {
            return null;
        }
        return Integer.valueOf(s);
    }

    public Integer getVersion(String key) {
        Stat stat;
        block6: {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("getRevision(), key = " + key));
            }
            if (key == null) {
                throw new NullPointerException("parameter key is <null>");
            }
            String nodePath = String.valueOf(this._root) + '/' + key;
            stat = this._zk.exists(nodePath);
            if (stat != null) break block6;
            return null;
        }
        try {
            return stat.getVersion();
        }
        catch (KeeperException.NoNodeException noNodeException) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void remove(String key) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("remove(), key = " + key));
        }
        if (key == null) {
            throw new NullPointerException("parameter key is <null>");
        }
        String nodePath = String.valueOf(this._root) + '/' + key;
        try {
            this._zk.deleteNode(nodePath);
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Integer add(final String key, final int value) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("add(), key = " + key + ", value = " + value));
        }
        if (key == null) {
            throw new NullPointerException("parameter key is <null>");
        }
        final String nodePath = String.valueOf(this._root) + '/' + key;
        try {
            return (Integer)this.retryZkMapOperation(new ZkMapCallable(){

                @Override
                public String getZkOperation() {
                    return "add(), key = " + key + ", value = " + value;
                }

                @Override
                public Object call() throws Exception {
                    Stat stat = ZkConcurrentMap.this._zk.exists(nodePath);
                    if (stat == null) {
                        try {
                            ZkConcurrentMap.this._zk.createNode(nodePath, String.valueOf(value).getBytes(ZkConcurrentMap.ENCODING));
                            return value;
                        }
                        catch (KeeperException.NodeExistsException nodeExistsException) {
                            stat = ZkConcurrentMap.this._zk.exists(nodePath);
                        }
                    }
                    int version = stat.getVersion();
                    String oldString = new String(ZkConcurrentMap.this._zk.getData(nodePath), ZkConcurrentMap.ENCODING);
                    int oldInt = Integer.valueOf(oldString);
                    String newValue = String.valueOf(value + oldInt);
                    try {
                        ZkConcurrentMap.this._zk.setData(nodePath, newValue.getBytes(ZkConcurrentMap.ENCODING), version);
                        return Integer.valueOf(newValue);
                    }
                    catch (KeeperException.NoNodeException noNodeException) {
                        return new RetryOperation();
                    }
                    catch (KeeperException.BadVersionException badVersionException) {
                        return new RetryOperation();
                    }
                }

                @Override
                public Object getExceededRetriesResult() {
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Set<String> keySet() {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"keySet()");
        }
        try {
            return new TreeSet<String>(this._zk.getChildrenSorted(this._root));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean containsKey(String key) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"containsKey()");
        }
        try {
            return this._zk.getChildrenSorted(this._root).contains(key);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"clear()");
        }
        try {
            Set<String> keys = this.keySet();
            for (String key : keys) {
                try {
                    String keyPath = String.valueOf(this._root) + "/" + key;
                    this._zk.deleteNode(keyPath);
                }
                catch (KeeperException.NoNodeException noNodeException) {}
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Integer incIfLessThan(final String key, final long max) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("incIfLessThan(), key = " + key + ", max = " + max));
        }
        if (key == null) {
            throw new NullPointerException("parameter key is <null>");
        }
        if (max <= 0L) {
            return -1;
        }
        final String nodePath = String.valueOf(this._root) + '/' + key;
        try {
            return (Integer)this.retryZkMapOperation(new ZkMapCallable(){

                @Override
                public String getZkOperation() {
                    return "incIfLessThan(), key = " + key + ", max = " + max;
                }

                @Override
                public Object call() throws Exception {
                    Stat stat = ZkConcurrentMap.this._zk.exists(nodePath);
                    if (stat == null) {
                        try {
                            ZkConcurrentMap.this._zk.createNode(nodePath, "1".getBytes(ZkConcurrentMap.ENCODING));
                            return 1;
                        }
                        catch (KeeperException.NodeExistsException nodeExistsException) {
                            stat = ZkConcurrentMap.this._zk.exists(nodePath);
                        }
                    }
                    int version = stat.getVersion();
                    String oldString = new String(ZkConcurrentMap.this._zk.getData(nodePath), ZkConcurrentMap.ENCODING);
                    long oldInt = Long.valueOf(oldString);
                    if (oldInt >= 0L && oldInt + 1L <= max) {
                        String newValue = String.valueOf(oldInt + 1L);
                        try {
                            ZkConcurrentMap.this._zk.setData(nodePath, newValue.getBytes(ZkConcurrentMap.ENCODING), version);
                            return Integer.valueOf(newValue);
                        }
                        catch (KeeperException.NoNodeException noNodeException) {
                            return new RetryOperation();
                        }
                        catch (KeeperException.BadVersionException badVersionException) {
                            return new RetryOperation();
                        }
                    }
                    return -1;
                }

                @Override
                public Object getExceededRetriesResult() {
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Integer decIfGreaterThan(final String key, final long min) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("decIfGreaterThan(), key = " + key + ", min = " + min));
        }
        if (key == null) {
            throw new NullPointerException("parameter key is <null>");
        }
        if (min < 0L) {
            return -1;
        }
        final String nodePath = String.valueOf(this._root) + '/' + key;
        try {
            return (Integer)this.retryZkMapOperation(new ZkMapCallable(){

                @Override
                public String getZkOperation() {
                    return "decIfGreaterThan(), key = " + key + ", min = " + min;
                }

                @Override
                public Object call() throws Exception {
                    Stat stat = ZkConcurrentMap.this._zk.exists(nodePath);
                    if (stat == null) {
                        try {
                            ZkConcurrentMap.this._zk.createNode(nodePath, "0".getBytes(ZkConcurrentMap.ENCODING));
                            return 0;
                        }
                        catch (KeeperException.NodeExistsException nodeExistsException) {
                            stat = ZkConcurrentMap.this._zk.exists(nodePath);
                        }
                    }
                    int version = stat.getVersion();
                    String oldString = new String(ZkConcurrentMap.this._zk.getData(nodePath), ZkConcurrentMap.ENCODING);
                    int oldVal = Integer.valueOf(oldString);
                    if (oldVal > 0 && (long)oldVal > min) {
                        String newValue = String.valueOf(oldVal - 1);
                        try {
                            ZkConcurrentMap.this._zk.setData(nodePath, newValue.getBytes(ZkConcurrentMap.ENCODING), version);
                            return oldVal - 1;
                        }
                        catch (KeeperException.NoNodeException noNodeException) {
                            return new RetryOperation();
                        }
                        catch (KeeperException.BadVersionException badVersionException) {
                            return new RetryOperation();
                        }
                    }
                    return -1;
                }

                @Override
                public Object getExceededRetriesResult() {
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object retryZkMapOperation(ZkMapCallable callable) throws Exception {
        long start = System.currentTimeMillis();
        for (int tries = 0; tries < 100; ++tries) {
            long t;
            Object result = callable.call();
            if (result instanceof RetryOperation) {
                Thread.sleep(this._waitTimeBetweenTriesGenerator.nextInt(10));
                continue;
            }
            if (this._log.isInfoEnabled() && (t = System.currentTimeMillis() - start) > 200L) {
                this._log.info((Object)("ZkConnection operation time: " + t + " ms, tries: " + tries + ", operation: " + callable.getZkOperation()));
            }
            return result;
        }
        if (this._log.isWarnEnabled()) {
            this._log.warn((Object)("ZkConcurrentMap: Too much conflicts while doing operation: " + callable.getZkOperation()));
        }
        return callable.getExceededRetriesResult();
    }

    private final class RetryOperation {
        private RetryOperation() {
        }
    }

    private static interface ZkMapCallable
    extends Callable<Object> {
        public String getZkOperation();

        public Object getExceededRetriesResult();
    }
}

