/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskmanager.internal;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.clusterconfig.ClusterConfigService;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.taskmanager.BadParameterTaskmanagerException;
import org.eclipse.smila.taskmanager.ResultDescription;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskmanager.TaskCompletionStatus;
import org.eclipse.smila.taskmanager.TaskManager;
import org.eclipse.smila.taskmanager.TaskmanagerException;
import org.eclipse.smila.taskmanager.persistence.TaskCounter;
import org.eclipse.smila.taskmanager.persistence.TaskList;
import org.eclipse.smila.taskmanager.persistence.TaskStorage;
import org.osgi.service.component.ComponentContext;

public class TaskManagerImpl
implements TaskManager {
    private TaskStorage _taskStorage;
    private final Log _log = LogFactory.getLog(this.getClass());
    private ClusterConfigService _clusterService;

    protected void activate(ComponentContext context) {
        this._taskStorage.setMaxNoOfTasksPerHost(this._clusterService.getMaxScaleUp());
    }

    @Override
    public void addTask(Task task) throws TaskmanagerException {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Taskmanager add task '" + task.getTaskId() + "' for worker '" + task.getWorkerName() + "'"));
        }
        task.setTaskCreatedProperties();
        if (this.hasObsoleteQualifier(task)) {
            this.finishTaskAsObsolete(task);
        } else {
            this._taskStorage.storeTask(task.getWorkerName(), task);
        }
    }

    @Override
    public void addTasks(Collection<Task> taskList) throws TaskmanagerException {
        for (Task task : taskList) {
            this.addTask(task);
        }
    }

    @Override
    public void addInProgressTask(Task task) throws TaskmanagerException {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Taskmanager add inprogress task '" + task.getTaskId() + "' for worker '" + task.getWorkerName() + "'"));
        }
        task.setTaskCreatedProperties();
        this._taskStorage.storeInProgressTask(task);
    }

    @Override
    public Task getTask(String workerName, String host) throws TaskmanagerException {
        return this.getTask(workerName, host, null);
    }

    @Override
    public Task getTask(String workerName, String host, Collection<String> qualifiers) throws TaskmanagerException {
        if (this._log.isDebugEnabled()) {
            String debugMessage = "Taskmanager get task for worker '" + workerName + "', host '" + host + "'";
            if (qualifiers != null) {
                debugMessage = String.valueOf(debugMessage) + ", qualifiers = '" + qualifiers.toString() + "'.";
            }
            this._log.debug((Object)debugMessage);
        }
        this.checkWorkerName(workerName);
        Task newTask = this._taskStorage.getTask(workerName, host, qualifiers);
        if (newTask != null) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Taskmanager got task '" + newTask.getTaskId() + "' for worker '" + workerName + "'."));
            }
        } else if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("Taskmanager returned no task for worker '" + workerName + "'."));
        }
        return newTask;
    }

    @Override
    public void finishTask(String workerName, String taskId, ResultDescription resultDescription) throws TaskmanagerException {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Taskmanager finish task '" + taskId + "' for worker '" + workerName + "'."));
        }
        this.checkWorkerName(workerName);
        Task task = this._taskStorage.getInProgressTask(workerName, taskId);
        if (task == null) {
            throw new BadParameterTaskmanagerException("Task '" + taskId + "' for worker '" + workerName + "' is not in-progress anymore.", BadParameterTaskmanagerException.Cause.taskId);
        }
        if ("_finishingTasks".equals(workerName)) {
            this.finishTaskForFinishingWorker(task, resultDescription);
        } else {
            if (this.hasObsoleteQualifier(task)) {
                this.finishTaskAsObsolete(task);
            } else if (resultDescription.getStatus() == TaskCompletionStatus.POSTPONE) {
                this.postponeTask(task);
                this._taskStorage.storeTask(workerName, task);
            } else {
                Task finishTask = task.createFinishTask(resultDescription, "_finishingTasks");
                this._taskStorage.storeTask("_finishingTasks", finishTask);
            }
            this._taskStorage.deleteTask(workerName, taskId);
        }
    }

    private void finishTaskForFinishingWorker(Task task, ResultDescription finishResultDescription) throws TaskmanagerException {
        TaskCompletionStatus finishStatus = finishResultDescription.getStatus();
        try {
            this._taskStorage.deleteTask("_finishingTasks", task.getTaskId());
            if (finishStatus == TaskCompletionStatus.RECOVERABLE_ERROR || finishStatus == TaskCompletionStatus.FATAL_ERROR) {
                ResultDescription originalResultDescription = task.getResultDescription();
                TaskCompletionStatus originalStatus = originalResultDescription.getStatus();
                this._log.warn((Object)("finishing-task '" + task.getTaskId() + "' has completion status '" + (Object)((Object)finishStatus) + "', original task had completion status '" + (Object)((Object)originalStatus) + "'"));
                if (originalStatus == TaskCompletionStatus.OBSOLETE || originalStatus == TaskCompletionStatus.FATAL_ERROR || finishStatus == TaskCompletionStatus.FATAL_ERROR) {
                    this._log.warn((Object)"Finishing-task will not be retried");
                } else {
                    this._log.warn((Object)"Finishing-task will be retried");
                    try {
                        this._taskStorage.storeTask("_finishingTasks", task);
                    }
                    catch (TaskmanagerException e) {
                        this._log.warn((Object)("Error while storing finishing-task '" + task.getTaskId() + "' in finishing-todo-queue"), (Throwable)e);
                    }
                }
            }
        }
        catch (TaskmanagerException e) {
            this._log.warn((Object)("Error while deleting finishing-task '" + task.getTaskId() + "' with completion status '" + (Object)((Object)finishStatus) + "' from finishing-inprogress-queue"), (Throwable)e);
        }
    }

    private void finishTaskAsObsolete(Task task) throws TaskmanagerException {
        task.setTaskStartedProperties();
        Task obsoleteTask = task.createFinishTask(new ResultDescription(TaskCompletionStatus.OBSOLETE, null, null, null), "_finishingTasks");
        this._taskStorage.storeTask("_finishingTasks", obsoleteTask);
    }

    private boolean hasObsoleteQualifier(Task task) throws TaskmanagerException {
        return task.getQualifier() != null && this._taskStorage.isLockedQualifier(task.getWorkerName(), task.getQualifier());
    }

    private void postponeTask(Task task) {
        task.getProperties().remove("startTime");
        String postponed = task.getProperties().get("postponed");
        if (postponed != null) {
            int postponedInt = Integer.parseInt(postponed);
            task.getProperties().put("postponed", Integer.toString(++postponedInt));
        } else {
            task.getProperties().put("postponed", "1");
        }
    }

    @Override
    public void keepAlive(String workerName, String taskId) throws TaskmanagerException {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Taskmanager keepAlive for worker '" + workerName + "', taskId '" + taskId + "'."));
        }
        this.checkWorkerName(workerName);
        this._taskStorage.keepAlive(workerName, taskId);
    }

    @Override
    public void finishTasks(String workerName, Collection<String> qualifiers, ResultDescription resultDescription) throws TaskmanagerException {
        if (qualifiers == null) {
            throw new IllegalArgumentException("qualifiers must not be a null value");
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Taskmanager finish tasks for worker '" + workerName + "' and qualifiers = '" + qualifiers.toString() + "' as obsolete."));
        }
        this.checkWorkerName(workerName);
        this._taskStorage.lockQualifiers(workerName, qualifiers);
        Task task = null;
        do {
            if ((task = this.getTask(workerName, null, qualifiers)) == null) continue;
            try {
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)(" finish task '" + task.getTaskId() + "', qualifier: '" + task.getQualifier() + "'."));
                }
                this.finishTask(workerName, task.getTaskId(), resultDescription);
            }
            catch (Exception ex) {
                this._log.warn((Object)("Finishing task " + task.getTaskId() + " for worker " + workerName + "."), (Throwable)ex);
            }
        } while (task != null);
    }

    @Override
    public void removeTasks(AnyMap filterMap) throws TaskmanagerException {
        this._taskStorage.removeTasks(filterMap);
    }

    @Override
    public void addTaskQueue(String workerName) throws TaskmanagerException {
        this._taskStorage.createTaskQueue(workerName);
    }

    @Override
    public Map<String, TaskCounter> getTaskCounters() throws TaskmanagerException {
        return this._taskStorage.getTaskCounters();
    }

    @Override
    public TaskList getTaskList(String workerName, String section, int maxCount) throws TaskmanagerException {
        this.checkWorkerName(workerName);
        return this._taskStorage.getTaskList(workerName, section, maxCount);
    }

    @Override
    public Any getTaskInfo(String workerName, String section, String taskName) throws TaskmanagerException {
        this.checkWorkerName(workerName);
        return this._taskStorage.getTaskInfo(workerName, section, taskName);
    }

    @Override
    public long getFailSafetyLevel() {
        return this._taskStorage.getFailSafetyLevel();
    }

    @Override
    public long getMaxScaleUp() {
        return this._taskStorage.getMaxNoOfTasksPerHost();
    }

    @Override
    public Map<String, Integer> getScaleUpCounters() throws TaskmanagerException {
        Map<String, Integer> scaleUpCounters = this._taskStorage.getScaleUpCounters();
        try {
            List clusterNodes;
            if (this._clusterService.isConfigured() && (clusterNodes = this._clusterService.getClusterNodes()) != null && clusterNodes.size() > 1) {
                LinkedHashMap<String, Integer> sortedCounters = new LinkedHashMap<String, Integer>();
                for (String cluster : clusterNodes) {
                    Integer counter = scaleUpCounters.get(cluster);
                    if (counter == null) continue;
                    sortedCounters.put(cluster, counter);
                }
                return sortedCounters;
            }
        }
        catch (Exception exception) {}
        return scaleUpCounters;
    }

    private void checkWorkerName(String workerName) throws TaskmanagerException {
        if (workerName == null) {
            if (this._log.isDebugEnabled()) {
                this._log.error((Object)"parameter workerName is null");
            }
            throw new BadParameterTaskmanagerException("parameter workerName is null", BadParameterTaskmanagerException.Cause.workerName);
        }
        if (workerName.trim().length() == 0) {
            if (this._log.isDebugEnabled()) {
                this._log.error((Object)"parameter workerName is an empty String");
            }
            throw new BadParameterTaskmanagerException("parameter workerName is an empty String", BadParameterTaskmanagerException.Cause.workerName);
        }
        if (!this.isInternalWorker(workerName) && !this._taskStorage.hasTaskQueue(workerName)) {
            String msg = "Worker '" + workerName + "' does not exist.";
            if (this._log.isDebugEnabled()) {
                this._log.error((Object)msg);
            }
            throw new BadParameterTaskmanagerException(msg, BadParameterTaskmanagerException.Cause.workerName);
        }
    }

    private boolean isInternalWorker(String worker) {
        return worker.startsWith("_");
    }

    public void setTaskStorage(TaskStorage taskStorage) {
        this._taskStorage = taskStorage;
    }

    public void unsetTaskStorage(TaskStorage taskStorage) {
        if (taskStorage == this._taskStorage) {
            this._taskStorage = null;
        }
    }

    public void setClusterConfigService(ClusterConfigService ccs) {
        this._clusterService = ccs;
    }

    public void unsetClusterConfigService(ClusterConfigService ccs) {
        if (this._clusterService == ccs) {
            this._clusterService = null;
        }
    }
}

