/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.bulkbuilder.helper;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.BlackboardFactory;
import org.eclipse.smila.bulkbuilder.BulkbuilderException;
import org.eclipse.smila.bulkbuilder.BulkbuilderService;
import org.eclipse.smila.bulkbuilder.WorkflowRunInfo;
import org.eclipse.smila.bulkbuilder.helper.BulkTracker;
import org.eclipse.smila.bulkbuilder.helper.BulkbuilderBase;
import org.eclipse.smila.bulkbuilder.helper.BulkbuilderTaskProvider;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.validation.InvalidRecordException;
import org.eclipse.smila.datamodel.validation.RecordValidator;
import org.eclipse.smila.jobmanager.JobManager;
import org.eclipse.smila.jobmanager.events.JobEvent;
import org.eclipse.smila.jobmanager.events.JobListener;
import org.eclipse.smila.jobmanager.events.PrepareToFinishEvent;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskmanager.TaskManager;
import org.eclipse.smila.workermanager.TaskKeepAliveListener;
import org.eclipse.smila.workermanager.WorkerManager;
import org.osgi.service.component.ComponentContext;

public abstract class BulkbuilderServiceBase
implements BulkbuilderService,
JobListener,
TaskKeepAliveListener {
    private final Log _log = LogFactory.getLog(this.getClass());
    private boolean _isActive;
    private TaskManager _taskManager;
    private JobManager _jobManager;
    private WorkerManager _workerManager;
    private ObjectStoreService _objectStore;
    private BlackboardFactory _blackboardFactory;
    private BulkbuilderBase _bulkbuilder;
    private BulkbuilderTaskProvider _taskProvider;
    private RecordValidator _recordValidator;
    private BulkTracker _bulkTracker;
    private final ScheduledExecutorService _scheduledMonitorExecutor = Executors.newScheduledThreadPool(3);

    protected void activateService(BulkbuilderBase bulkbuilder, BulkbuilderTaskProvider taskProvider, RecordValidator validator) {
        this._bulkbuilder = bulkbuilder;
        this._taskProvider = taskProvider;
        this._recordValidator = validator;
        this._bulkTracker = new BulkTracker(this._bulkbuilder);
        this._scheduledMonitorExecutor.scheduleAtFixedRate(this._bulkTracker, 5000L, 5000L, TimeUnit.MILLISECONDS);
        this._workerManager.addKeepAliveListener((TaskKeepAliveListener)this);
        this._isActive = true;
    }

    protected abstract void activate(ComponentContext var1);

    protected void deactivate(ComponentContext context) {
        this._isActive = false;
        this._workerManager.removeKeepAliveListener((TaskKeepAliveListener)this);
        if (this._bulkbuilder != null) {
            this._bulkbuilder.shutdown();
        }
        if (this._scheduledMonitorExecutor != null) {
            this._scheduledMonitorExecutor.shutdown();
        }
    }

    @Override
    public WorkflowRunInfo addRecord(String jobName, Record record) throws BulkbuilderException, InvalidRecordException {
        this.checkActive();
        if (record == null) {
            throw new IllegalArgumentException("Error during adding record: Record must not be null");
        }
        this._recordValidator.validate(record);
        return this._bulkbuilder.addRecord(jobName, record);
    }

    @Override
    public WorkflowRunInfo deleteRecord(String jobName, Record record) throws BulkbuilderException, InvalidRecordException {
        this.checkActive();
        if (record == null) {
            throw new IllegalArgumentException("Error during deleting record: Record must not be null");
        }
        this._recordValidator.validate(record);
        return this._bulkbuilder.deleteRecord(jobName, record);
    }

    @Override
    public WorkflowRunInfo commitJob(String jobName) throws BulkbuilderException {
        this.checkActive();
        return this._bulkbuilder.commitBulk(jobName);
    }

    @Override
    public WorkflowRunInfo addToMicroBulk(String jobName, Record record, String microBulkId) throws BulkbuilderException, InvalidRecordException {
        this.checkActive();
        if (record == null) {
            throw new IllegalArgumentException("Error during adding record: Record must not be null");
        }
        this._recordValidator.validate(record);
        return this._bulkbuilder.addToMicroBulk(jobName, record, microBulkId);
    }

    @Override
    public WorkflowRunInfo finishMicroBulk(String jobName, String microBulkId) throws BulkbuilderException {
        this.checkActive();
        return this._bulkbuilder.finishMicroBulk(jobName, microBulkId);
    }

    @Override
    public void removeMicroBulk(String microBulkId) {
        this._bulkbuilder.removeMicroBulk(microBulkId);
    }

    public void processJobEvent(JobEvent evt) {
        if (evt instanceof PrepareToFinishEvent) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Finish job '" + evt.getJobName() + "', committing bulks."));
            }
            try {
                this.commitJob(evt.getJobName());
            }
            catch (BulkbuilderException e) {
                this._log.error((Object)("Error while finishing job '" + evt.getJobName() + "'."), (Throwable)((Object)e));
            }
        }
    }

    public void removedTask(Task task) {
        if (this._log.isWarnEnabled()) {
            this._log.warn((Object)("Task '" + task.getTaskId() + "' has been removed by the system."));
        }
        this._taskProvider.removeTask(task);
    }

    protected void checkActive() throws BulkbuilderException {
        if (!this._isActive) {
            throw new BulkbuilderException("BulkBuilder is currently not active, probably the system is shutting down.");
        }
    }

    public ObjectStoreService getObjectStoreService() {
        return this._objectStore;
    }

    public void setObjectStoreService(ObjectStoreService objectStoreService) {
        this._objectStore = objectStoreService;
    }

    public void unsetObjectStoreService(ObjectStoreService objectStoreService) {
        if (this._objectStore == objectStoreService) {
            this._objectStore = null;
        }
    }

    public TaskManager getTaskManager() {
        return this._taskManager;
    }

    public void setTaskManager(TaskManager taskManager) {
        this._taskManager = taskManager;
    }

    public void unsetTaskManager(TaskManager taskManager) {
        if (taskManager == this._taskManager) {
            this._taskManager = null;
        }
    }

    public JobManager getJobManager() {
        return this._jobManager;
    }

    public void setJobManager(JobManager jobManager) {
        this._jobManager = jobManager;
    }

    public void unsetJobManager(JobManager jobManager) {
        if (this._jobManager == jobManager) {
            this._jobManager = null;
        }
    }

    public WorkerManager getWorkerManager() {
        return this._workerManager;
    }

    public void setWorkerManager(WorkerManager workerManager) {
        this._workerManager = workerManager;
    }

    public void unsetWorkerManager(WorkerManager workerManager) {
        if (this._workerManager == workerManager) {
            this._workerManager = null;
        }
    }

    protected BlackboardFactory getBlackboardFactory() {
        return this._blackboardFactory;
    }

    protected void setBlackboardFactory(BlackboardFactory factory) {
        this._blackboardFactory = factory;
        if (this._bulkbuilder != null) {
            this._bulkbuilder.setBlackboardFactory(factory);
        }
    }

    protected void unsetBlackboardFactory(BlackboardFactory factory) {
        if (this._blackboardFactory == factory) {
            this._blackboardFactory = null;
            this._bulkbuilder.unsetBlackboardFactory(factory);
        }
    }
}

