/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.bulkbuilder.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.jobmanager.util.DataSizeParser;
import org.eclipse.smila.utils.config.ConfigUtils;

public class BulkbuilderConfig {
    public static final long MILLISECONDS_MULTIPLIER = 1000L;
    private static final String FILENAME = "bulkbuilder.properties";
    private static final String PROP_LIMIT_SIZE = "bulkLimitSize";
    private static final String PROP_LIMIT_TIME = "bulkLimitTime";
    private static final String PROP_MAX_PARALLEL_MICRO_BULKS = "maxParallelMicroBulks";
    private static final String DEFAULT_LIMIT_SIZE = "10m";
    private static final long DEFAULT_LIMIT_TIME = 120L;
    private static final long DEFAULT_MAX_PARALLEL_MICRO_BULKS = -1L;
    private final Log _log = LogFactory.getLog(this.getClass());
    private long _limitIncSize;
    private long _limitIncTime;
    private long _maxParallelMicroBulks;
    private Properties _properties = new Properties();

    public BulkbuilderConfig() {
        this.setFrom(new Properties());
    }

    public long getLimitTime() {
        return this._limitIncTime;
    }

    public long getLimitTimeMillis() {
        return this.getLimitTime() * 1000L;
    }

    public long getLimitSize() {
        return this._limitIncSize;
    }

    public long getMaxParallelMicroBulks() {
        return this._maxParallelMicroBulks;
    }

    public void readConfiguration() throws IOException {
        InputStream propStream = null;
        try {
            try {
                propStream = ConfigUtils.getConfigStream((String)"org.eclipse.smila.bulkbuilder", (String)FILENAME);
                if (propStream != null) {
                    Properties properties = new Properties();
                    properties.load(propStream);
                    this.setFrom(properties);
                }
            }
            catch (Exception ex) {
                throw new IOException("Could not find bulkbuilder.properties in configuration area.", ex);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(propStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)propStream);
    }

    public void setFrom(Properties properties) {
        this._properties = properties;
        this._limitIncSize = this.getDataSizeProperty(PROP_LIMIT_SIZE, DEFAULT_LIMIT_SIZE);
        this._limitIncTime = this.getIntProperty(PROP_LIMIT_TIME, 120L);
        this._maxParallelMicroBulks = this.getIntProperty(PROP_MAX_PARALLEL_MICRO_BULKS, -1L);
    }

    protected long getDataSizeProperty(String propName, String defaultValue) {
        block3: {
            String propertyString = this._properties.getProperty(propName);
            if (propertyString != null) {
                try {
                    return DataSizeParser.parse((String)propertyString);
                }
                catch (Exception exception) {
                    if (!this._log.isWarnEnabled()) break block3;
                    this._log.warn((Object)("Value " + propertyString + " of " + propName + " is not an data size value. Falling back to default " + defaultValue));
                }
            }
        }
        return DataSizeParser.parse((String)defaultValue);
    }

    private long getIntProperty(String propName, long defaultValue) {
        block3: {
            String propertyString = this._properties.getProperty(propName);
            if (propertyString != null) {
                try {
                    return Long.parseLong(propertyString);
                }
                catch (Exception exception) {
                    if (!this._log.isWarnEnabled()) break block3;
                    this._log.warn((Object)("Value " + propertyString + " of " + propName + " is not an integer value. Falling back to default " + defaultValue));
                }
            }
        }
        return defaultValue;
    }
}

