/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.eclipse.smila.search.datadictionary.DataDictionaryAccess;
import org.eclipse.smila.search.lucene.IndexAccess;
import org.eclipse.smila.search.lucene.TemplateAccess;
import org.eclipse.smila.search.plugin.IIndexAccess;
import org.eclipse.smila.search.plugin.ITemplateAccess;
import org.eclipse.smila.search.utils.advsearch.AdvSearchAccess;
import org.eclipse.smila.search.utils.indexstructure.IndexStructureAccess;
import org.eclipse.smila.search.utils.search.SearchAccess;
import org.eclipse.smila.utils.config.ConfigUtils;

public class Plugin
extends org.eclipse.smila.search.plugin.Plugin {
    private final IIndexAccess _indexAccess = new IndexAccess();
    private final IndexStructureAccess _indexStructureAccess = IndexStructureAccess.getInstance();
    private final AdvSearchAccess _advSearchAccess = AdvSearchAccess.getInstance();
    private final ITemplateAccess _templateAccess = new TemplateAccess();
    private final DataDictionaryAccess _dataDictionaryAccess = DataDictionaryAccess.getInstance();
    private final SearchAccess _searchAccess = SearchAccess.getInstance();

    public AdvSearchAccess getAdvSearchAccess() {
        return this._advSearchAccess;
    }

    public IndexStructureAccess getIndexStructureAccess() {
        return this._indexStructureAccess;
    }

    public IIndexAccess getIndexAccess() {
        return this._indexAccess;
    }

    public ITemplateAccess getTemplateAccess() {
        return this._templateAccess;
    }

    public DataDictionaryAccess getDataDictionaryAccess() {
        return this._dataDictionaryAccess;
    }

    public SearchAccess getSearchAccess() {
        return this._searchAccess;
    }

    public boolean dataTypeMatches(String indexDataType, String searchDataType) {
        if ("FTText".equals(searchDataType) && "Text".equals(indexDataType)) {
            return true;
        }
        if ("FTNumber".equals(searchDataType) && "Number".equals(indexDataType)) {
            return true;
        }
        return "FTDate".equals(searchDataType) && "Date".equals(indexDataType);
    }

    public byte[] getConfigurationFileForEngineData(String fileName) throws IOException {
        File xmlFolder = ConfigUtils.getConfigFolder((String)"org.eclipse.smila.lucene", (String)"xml");
        File file = new File(xmlFolder, fileName);
        byte[] bytes = FileUtils.readFileToByteArray((File)file);
        return bytes;
    }

    public String getConfigurationBundleForEngineData() {
        return "org.eclipse.smila.lucene";
    }
}

