/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.index;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.eclipse.smila.search.datadictionary.DataDictionaryController;
import org.eclipse.smila.search.datadictionary.DataDictionaryException;
import org.eclipse.smila.search.index.IndexException;
import org.eclipse.smila.search.lucene.index.AnalyzerFactory;
import org.eclipse.smila.search.utils.indexstructure.DIndexStructure;
import org.eclipse.smila.utils.workspace.WorkspaceHelper;

public class IndexAdmin
extends org.eclipse.smila.search.index.IndexAdmin {
    private final Log _log = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected void createIndex(DIndexStructure dIndexStructure) throws IndexException {
        Analyzer analyzer = AnalyzerFactory.getAnalyzer(dIndexStructure);
        try {
            File dataFolder = WorkspaceHelper.createWorkingDir((String)"org.eclipse.smila.lucene", (String)dIndexStructure.getName());
            IndexWriter iw = new IndexWriter(dataFolder.getAbsolutePath(), analyzer, true);
            iw.close();
        }
        catch (Throwable e) {
            String msg = "unable to create index [" + dIndexStructure.getName() + "]";
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)msg, e);
            }
            throw new IndexException(msg, e);
        }
    }

    protected boolean indexExists(String indexName) throws IndexException {
        try {
            return WorkspaceHelper.existsWorkingDir((String)"org.eclipse.smila.lucene", (String)indexName);
        }
        catch (IOException e) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new IndexException((Throwable)e);
        }
    }

    protected void deleteIndex(String indexName) throws IndexException {
        try {
            File dataFolder = WorkspaceHelper.createWorkingDir((String)"org.eclipse.smila.lucene", (String)indexName);
            FileUtils.deleteDirectory((File)dataFolder);
        }
        catch (IOException e) {
            throw new IndexException((Throwable)e);
        }
    }

    protected void renameIndex(String indexName, String newIndexName) throws IndexException {
        try {
            File dataFolder = WorkspaceHelper.createWorkingDir((String)"org.eclipse.smila.lucene", (String)indexName);
            File newDataFolder = new File(dataFolder.getParentFile(), newIndexName);
            FileUtils.moveDirectory((File)dataFolder, (File)newDataFolder);
        }
        catch (IOException e) {
            throw new IndexException((Throwable)e);
        }
    }

    protected void reorganizeIndex(String indexName) throws IndexException {
        Analyzer analyzer = null;
        try {
            analyzer = AnalyzerFactory.getAnalyzer(DataDictionaryController.getIndex((String)indexName));
        }
        catch (DataDictionaryException e) {
            throw new IndexException("unable to reorganize index [" + indexName + "]", (Throwable)e);
        }
        IndexWriter iw = null;
        try {
            try {
                File indexFolder = WorkspaceHelper.createWorkingDir((String)"org.eclipse.smila.lucene", (String)indexName);
                iw = new IndexWriter(indexFolder, analyzer, false);
                iw.optimize();
            }
            catch (Throwable e) {
                throw new IndexException("unable to reorganize index [" + indexName + "]", e);
            }
        }
        catch (Throwable throwable) {
            if (iw != null) {
                try {
                    iw.close();
                }
                catch (Throwable throwable2) {}
            }
            throw throwable;
        }
        if (iw != null) {
            try {
                iw.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public void saveIndex(String indexName) throws IndexException {
        throw new RuntimeException("saveIndex is not implemented!");
    }
}

