/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.messages.advsearch;

import org.eclipse.smila.search.lucene.messages.advsearch.DQueryExpression;
import org.eclipse.smila.search.lucene.messages.advsearch.DTerm;
import org.eclipse.smila.search.lucene.messages.advsearch.DTermCodec;
import org.eclipse.smila.search.utils.advsearch.AdvSearchException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DQueryExpressionCodec {
    private DQueryExpressionCodec() {
    }

    public static Element encode(DQueryExpression dQueryExpression, Element parent) throws AdvSearchException {
        Document doc = parent.getOwnerDocument();
        Element me = (Element)parent.appendChild(doc.createElementNS("http://www.anyfinder.de/AdvancedSearch", "QueryExpression"));
        me.setAttribute("IndexName", dQueryExpression.getIndexName());
        me.setAttribute("MaxHits", String.valueOf(dQueryExpression.getMaxHits()));
        me.setAttribute("MinSimilarity", String.valueOf(dQueryExpression.getMinSimilarity()));
        me.setAttribute("ShowHitDistribution", dQueryExpression.getShowHitDistribution() ? "true" : "false");
        if (dQueryExpression.getStartHits() != null) {
            me.setAttribute("StartHits", String.valueOf(dQueryExpression.getStartHits()));
        }
        DTermCodec.encode((DTerm)dQueryExpression.getTerm(), me);
        return me;
    }

    public static DQueryExpression decode(Element element) throws AdvSearchException {
        DQueryExpression dQueryExpression = new DQueryExpression();
        dQueryExpression.setIndexName(element.getAttribute("IndexName"));
        dQueryExpression.setMaxHits(Integer.parseInt(element.getAttribute("MaxHits")));
        dQueryExpression.setMinSimilarity(Integer.parseInt(element.getAttribute("MinSimilarity")));
        dQueryExpression.setShowHitDistribution(Boolean.valueOf(element.getAttribute("ShowHitDistribution")));
        if (element.hasAttribute("StartHits")) {
            dQueryExpression.setStartHits(new Integer(element.getAttribute("StartHits")));
        }
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if ("Term".equals(nl.item(i).getLocalName())) {
                dQueryExpression.setTerm(DTermCodec.decode((Element)nl.item(i)));
            }
            ++i;
        }
        return dQueryExpression;
    }
}

