/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.messages.advsearch;

import org.eclipse.smila.search.lucene.messages.advsearch.DTermCodec;
import org.eclipse.smila.search.lucene.messages.advsearch.DWMEAN;
import org.eclipse.smila.search.utils.advsearch.AdvSearchException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class DWMEANCodec {
    private DWMEANCodec() {
    }

    public static Element encode(DWMEAN dWMEAN, Element parent) throws AdvSearchException {
        Document doc = parent.getOwnerDocument();
        Element me = (Element)parent.appendChild(doc.createElementNS("http://www.anyfinder.de/AdvancedSearch", "WMEAN"));
        me.setAttribute("Operation", String.valueOf(dWMEAN.getOperation()));
        Element child = null;
        if (dWMEAN.getTermCount() < 2) {
            throw new AdvSearchException("Error: WMEAN must have at least two terms");
        }
        int i = 0;
        while (i < dWMEAN.getTermCount()) {
            child = (Element)me.appendChild(doc.createElementNS("http://www.anyfinder.de/AdvancedSearch", "Constraint"));
            child.appendChild(doc.createTextNode(dWMEAN.getConstraint(i)));
            child = (Element)me.appendChild(doc.createElementNS("http://www.anyfinder.de/AdvancedSearch", "Boost"));
            child.appendChild(doc.createTextNode(String.valueOf(dWMEAN.getBoost(i))));
            DTermCodec.encode(dWMEAN.getTerm(i), me);
            ++i;
        }
        return me;
    }

    public static DWMEAN decode(Element element) throws AdvSearchException {
        try {
            DWMEAN dWMEAN = new DWMEAN();
            dWMEAN.setOperation(element.getAttribute("Operation"));
            NodeList nl = element.getChildNodes();
            if (nl.getLength() < 4) {
                throw new AdvSearchException("Error: WMEAN must have at least two terms");
            }
            int i = 0;
            while (i < nl.getLength()) {
                if (nl.item(i).getNodeType() == 3) {
                    ++i;
                }
                if (i >= nl.getLength()) break;
                if ("Constraint".equals(nl.item(i).getLocalName())) {
                    String constraint = ((Text)nl.item(i).getFirstChild()).getData().trim();
                    if (constraint == null || constraint.equals("")) {
                        constraint = "optional";
                    }
                    float boost = 0.0f;
                    try {
                        String nullstring;
                        String data = null;
                        if (nl.item(i + 1).getNodeType() == 3) {
                            ++i;
                        }
                        if ("Boost".equals(nl.item(i + 1).getLocalName())) {
                            data = ((Text)nl.item(i + 1).getFirstChild()).getData().trim();
                        } else {
                            nullstring = null;
                            nullstring.toString();
                        }
                        try {
                            boost = Float.parseFloat(data);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new AdvSearchException("Error in WMEAN: Illegal number format '" + data + "' for Boost");
                        }
                        if (nl.item(i + 2).getNodeType() == 3) {
                            ++i;
                        }
                        if ("Term".equals(nl.item(i + 2).getLocalName())) {
                            dWMEAN.addTerm(DTermCodec.decode((Element)nl.item(i + 2)), boost, constraint);
                        } else {
                            nullstring = null;
                            nullstring.toString();
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new AdvSearchException("Illegal structure below WMEAN: Need sequence of <Constraint>...</Constraint><Boost>...</Boost><Term>...</Term>");
                    }
                }
                i += 3;
            }
            return dWMEAN;
        }
        catch (Exception e) {
            if (e instanceof AdvSearchException) {
                throw (AdvSearchException)((Object)e);
            }
            throw new AdvSearchException("Error in attributes to WMEAN: " + e);
        }
    }
}

