/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ontology.pipelets;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.ontology.pipelets.ASesameRecordPipelet;
import org.eclipse.smila.ontology.records.SesameRecordWriter;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.openrdf.repository.RepositoryConnection;

public class SesameRecordWriterPipelet
extends ASesameRecordPipelet {
    public static final String PARAM_TYPEURI = "typeUri";
    public static final String PARAM_URI_ATTRIBUTE = "uriAttribute";
    public static final String PARAM_DEFAULT_URI_ATTRIBUTE = "rdf:about";

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        if (recordIds != null) {
            ParameterAccessor parameters = this.getParameters(blackboard);
            String[] stringArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                try {
                    parameters.setCurrentRecord(id);
                    RepositoryConnection repoConn = this.getRepositoryConnection(parameters);
                    String recordFilterName = parameters.getParameter("recordFilter", null);
                    String typeUri = parameters.getParameter(PARAM_TYPEURI, null);
                    String uriAttribute = parameters.getParameter(PARAM_URI_ATTRIBUTE, PARAM_DEFAULT_URI_ATTRIBUTE);
                    SesameRecordWriter writer = new SesameRecordWriter(repoConn);
                    if (recordFilterName == null) {
                        writer.writeBlackboardRecord(blackboard, id, typeUri, uriAttribute);
                    } else {
                        Record record = blackboard.getRecord(id, recordFilterName);
                        Record unfilteredRecord = blackboard.getRecord(id);
                        Any copyProperties = (Any)unfilteredRecord.getMetadata().get((Object)"_deleteAll");
                        if (copyProperties != null) {
                            record.getMetadata().put("_deleteAll", copyProperties);
                        }
                        if ((copyProperties = (Any)unfilteredRecord.getMetadata().get((Object)"_deleteProperties")) != null) {
                            record.getMetadata().put("_deleteProperties", copyProperties);
                        }
                        if ((copyProperties = (Any)unfilteredRecord.getMetadata().get((Object)"_reverseProperties")) != null) {
                            record.getMetadata().put("_reverseProperties", copyProperties);
                        }
                        if ((copyProperties = (Any)unfilteredRecord.getMetadata().get((Object)"_objectProperties")) != null) {
                            record.getMetadata().put("_objectProperties", copyProperties);
                        }
                        writer.writeRecord(record, typeUri, uriAttribute);
                    }
                    repoConn.close();
                }
                catch (Exception ex) {
                    throw new ProcessingException("error writing record to ontology", (Throwable)ex);
                }
                ++n2;
            }
        }
        return recordIds;
    }
}

