/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.deltaindexing.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.smila.connectivity.ConnectivityId;
import org.eclipse.smila.connectivity.deltaindexing.DeltaIndexingException;
import org.eclipse.smila.connectivity.deltaindexing.impl.IdIterator;

public class DataSourceConnection
implements Serializable {
    private static final long serialVersionUID = -2263628823851855201L;
    private static final String EXCEPTION_DATA_SOURCE_LOCKED_BY_OTHER_SESSION = "Data source %s already locked by another session";
    private static final String EXCEPTION_DATA_SOURCE_SHOULD_BE_LOCKED = "Data source %s should be locked before using!";
    private final String _dataSourceId;
    private String _sessionId;
    private ReentrantLock _lock = new ReentrantLock();
    private final Object _lockMonitor = new Object[0];
    private final Map<ConnectivityId, String> _index = new HashMap<ConnectivityId, String>();
    private final transient Set<ConnectivityId> _modified = new HashSet<ConnectivityId>();
    private transient Map<ConnectivityId, String> _updated;
    private transient Set<ConnectivityId> _deleted;
    private final Map<ConnectivityId, Set<ConnectivityId>> _subCompounds = new HashMap<ConnectivityId, Set<ConnectivityId>>();

    public DataSourceConnection(String dataSourceId) {
        this._dataSourceId = dataSourceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(String sessionId) throws DeltaIndexingException {
        Object object = this._lockMonitor;
        synchronized (object) {
            if (this._lock.isLocked()) {
                throw new DeltaIndexingException(String.format(EXCEPTION_DATA_SOURCE_LOCKED_BY_OTHER_SESSION, this._dataSourceId));
            }
            this._modified.clear();
            this._lock.lock();
            this._sessionId = sessionId;
        }
        this.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() throws DeltaIndexingException {
        this.checkLock();
        this.commit();
        this.rollback();
        Object object = this._lockMonitor;
        synchronized (object) {
            this._lock.unlock();
            this._sessionId = null;
        }
    }

    public void put(ConnectivityId id) throws DeltaIndexingException {
        this.checkLock();
        this._updated.put(id, this._index.get(id));
    }

    public void put(ConnectivityId id, String hash, boolean isCompound) throws DeltaIndexingException {
        this.checkLock();
        this._updated.put(id, hash);
        if (isCompound) {
            this._modified.add(id);
        }
    }

    public String getHash(ConnectivityId id) throws DeltaIndexingException {
        this.checkLock();
        return this._index.get(id);
    }

    public Iterator<ConnectivityId> obsoleteIdIterator() throws DeltaIndexingException {
        this.checkLock();
        return new IdIterator(this._index.keySet(), this._updated.keySet(), this._modified);
    }

    public void delete(ConnectivityId id) throws DeltaIndexingException {
        this.checkLock();
        this._deleted.add(id);
    }

    public void rollback() throws DeltaIndexingException {
        this.checkLock();
        this._updated = new HashMap<ConnectivityId, String>();
        this.checkLock();
        this._deleted = new HashSet<ConnectivityId>();
    }

    public void clear() throws DeltaIndexingException {
        this.rollback();
        this._index.clear();
        this._modified.clear();
        for (Set<ConnectivityId> set : this._subCompounds.values()) {
            if (set == null) continue;
            set.clear();
        }
        this._subCompounds.clear();
    }

    private void commit() throws DeltaIndexingException {
        for (ConnectivityId id : this._updated.keySet()) {
            this.checkLock();
            this._index.put(id, this._updated.get(id));
        }
        for (ConnectivityId id : this._deleted) {
            this.checkLock();
            this._index.remove(id);
            this.removeSubCompound(id);
        }
    }

    private void checkLock() throws DeltaIndexingException {
        if (!this._lock.isLocked()) {
            throw new DeltaIndexingException(String.format(EXCEPTION_DATA_SOURCE_SHOULD_BE_LOCKED, this._dataSourceId));
        }
    }

    public void forceUnlockAndRollback() throws DeltaIndexingException {
        ReentrantLock lock = new ReentrantLock();
        lock.lock();
        this._lock = lock;
        this.rollback();
        this.unlock();
    }

    public void forceUnlockAndClear() throws DeltaIndexingException {
        ReentrantLock lock = new ReentrantLock();
        lock.lock();
        this._lock = lock;
        this.clear();
        this.unlock();
    }

    public void addSubCompound(ConnectivityId parentId, ConnectivityId subCompoundId) {
        Set<ConnectivityId> set = this._subCompounds.get(parentId);
        if (set == null) {
            set = new HashSet<ConnectivityId>();
        }
        set.add(subCompoundId);
        this._subCompounds.put(parentId, set);
    }

    public Set<ConnectivityId> getSubCompounds(ConnectivityId id) {
        return this._subCompounds.get(id);
    }

    public void removeSubCompound(ConnectivityId id) {
        Set<ConnectivityId> set = this._subCompounds.get(id);
        if (set != null) {
            set.clear();
        }
        this._subCompounds.remove(id);
    }

    public String getDataSourceId() {
        return this._dataSourceId;
    }

    public String getSessionId() {
        return this._sessionId;
    }

    public long getEntryCount() {
        HashSet<ConnectivityId> set = new HashSet<ConnectivityId>();
        if (this._index != null) {
            set.addAll(this._index.keySet());
        }
        if (this._updated != null) {
            set.addAll(this._updated.keySet());
        }
        if (this._modified != null) {
            set.addAll(this._modified);
        }
        if (this._deleted != null) {
            set.removeAll(this._deleted);
        }
        return set.size();
    }
}

