/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.recordstorage.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.utils.digest.DigestHelper;

public class RecordDao
implements Serializable {
    public static final String NAMED_QUERY_FIND_BY_SOURCE = "RecordDao.findBySource";
    public static final String NAMED_QUERY_PARAM_SOURCE = "source";
    public static final String ENTITY_MEMBER_ATTRIBUTES = "_attributes";
    private static final long serialVersionUID = 6500268394234442139L;
    private String _idHash;
    private String _source;
    private byte[] _serializedRecord;

    public RecordDao(Record record) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("parameter record is null");
        }
        if (record.getId() == null) {
            throw new IllegalArgumentException("parameter record has not Id set");
        }
        ArrayList<String> attachmentNames = new ArrayList<String>();
        Iterator names = record.getAttachmentNames();
        while (names.hasNext()) {
            attachmentNames.add((String)names.next());
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
        objectStream.writeObject(record.getMetadata());
        objectStream.writeObject(attachmentNames);
        objectStream.close();
        this._idHash = RecordDao.getIdHash(record.getId());
        this._source = record.getSource();
        this._serializedRecord = byteStream.toByteArray();
    }

    protected RecordDao() {
    }

    public static String getIdHash(String id) {
        return DigestHelper.calculateDigest((String)id);
    }

    public Record toRecord() throws IOException, ClassNotFoundException {
        ObjectInputStream objectStream = new ObjectInputStream(new ByteArrayInputStream(this._serializedRecord));
        AnyMap metadata = (AnyMap)objectStream.readObject();
        List attachmentNames = (List)objectStream.readObject();
        objectStream.close();
        Record record = DataFactory.DEFAULT.createRecord();
        record.getMetadata().putAll((Map)metadata);
        for (String name : attachmentNames) {
            record.setAttachment(name, null);
        }
        return record;
    }
}

