/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.agent.mock;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.ConnectivityId;
import org.eclipse.smila.connectivity.framework.AbstractAgent;
import org.eclipse.smila.connectivity.framework.AgentException;
import org.eclipse.smila.connectivity.framework.agent.mock.messages.Attribute;
import org.eclipse.smila.connectivity.framework.agent.mock.messages.Process;
import org.eclipse.smila.connectivity.framework.performancecounters.AgentPerformanceCounterHelper;
import org.eclipse.smila.connectivity.framework.performancecounters.ConnectivityPerformanceAgent;
import org.eclipse.smila.connectivity.framework.schema.config.DataSourceConnectionConfig;
import org.eclipse.smila.connectivity.framework.util.AgentThreadState;
import org.eclipse.smila.connectivity.framework.util.ConnectivityHashFactory;
import org.eclipse.smila.connectivity.framework.util.ConnectivityIdFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;

public class MockAgent
extends AbstractAgent {
    private static final long MILLI_SECOND_MULTIPLIER = 1000L;
    private final Log _log = LogFactory.getLog(MockAgent.class);
    private long _sleepTime;
    private Attribute[] _attributes;
    private AgentPerformanceCounterHelper<ConnectivityPerformanceAgent> _performanceCounters;

    public MockAgent() {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Creating MockAgent instance");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                while (true) {
                    if (this.isStopThread()) {
                        return;
                    }
                    try {
                        StringBuffer hash = new StringBuffer();
                        Record record = this.createRecord(hash);
                        if (this._log.isTraceEnabled()) {
                            this._log.trace((Object)("created record with Id " + record.getId()));
                        }
                        long recordAttachmentLength = this.getAttachmentsByteLength(record);
                        this.getCounterHelper().incrementAttachmentBytes(recordAttachmentLength);
                        this.getCounterHelper().incrementRecords();
                        this.getControllerCallback().add(this.getSessionId(), this.getConfig().getDeltaIndexing(), record, hash.toString());
                        Thread.sleep(this._sleepTime);
                    }
                    catch (InterruptedException e) {
                        this.getCounterHelper().addException((Throwable)e);
                        if (!this._log.isTraceEnabled()) continue;
                        this._log.trace((Object)"agent thread was interrupted ", (Throwable)e);
                    }
                }
            }
            catch (Throwable t) {
                if (this._performanceCounters != null) {
                    this._performanceCounters.addException(t);
                }
                this.getAgentState().setLastError(t);
                this.getAgentState().setState(AgentThreadState.Aborted);
                this._log.error((Object)"Fatal error, aborting", t);
                try {
                    this.stopThread();
                    return;
                }
                catch (Exception e) {
                    this._log.error((Object)"Error while stopping thread.", (Throwable)e);
                    return;
                }
            }
        }
        finally {
            try {
                this.stopThread();
            }
            catch (Exception e) {
                this._log.error((Object)"Error while stopping thread.", (Throwable)e);
            }
        }
    }

    protected void initialize() throws AgentException {
        this._sleepTime = ((Process)this.getConfig().getProcess()).getSleepTime().longValue() * 1000L;
        DataSourceConnectionConfig.Attributes attributes = this.getConfig().getAttributes();
        List attrs = attributes.getAttribute();
        this._attributes = attrs.toArray(new Attribute[attrs.size()]);
    }

    private Record createRecord(StringBuffer hash) throws AgentException {
        MockAgentData data = new MockAgentData();
        AnyMap idAttributes = DataFactory.DEFAULT.createAnyMap();
        AnyMap hashAttributes = DataFactory.DEFAULT.createAnyMap();
        HashMap<String, byte[]> hashAttachments = new HashMap<String, byte[]>();
        this.readIdAndHashAttributesAndAttachments(data, idAttributes, hashAttributes, hashAttachments);
        ConnectivityId id = ConnectivityIdFactory.getInstance().createId(this.getConfig().getDataSourceID(), idAttributes);
        hash.append(ConnectivityHashFactory.getInstance().createHash(hashAttributes));
        Record record = DataFactory.DEFAULT.createRecord();
        record.setId(id.getObjectId());
        record.setSource(id.getDataSourceId());
        this.fillRecord(data, record);
        return record;
    }

    private void readIdAndHashAttributesAndAttachments(MockAgentData data, AnyMap idAttributes, AnyMap hashAttributes, Map<String, byte[]> hashAttachments) throws AgentException {
        Attribute[] attributeArray = this._attributes;
        int n = this._attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attributeDef = attributeArray[n2];
            if (attributeDef.isKeyAttribute() || attributeDef.isHashAttribute()) {
                Object value;
                if (attributeDef.isAttachment()) {
                    value = this.readAttachment(data, attributeDef);
                    hashAttachments.put(attributeDef.getName(), (byte[])value);
                } else {
                    value = this.readAttribute(data, attributeDef);
                    if (value != null) {
                        Value attribute = DataFactory.DEFAULT.autoConvertValue(value);
                        if (attributeDef.isKeyAttribute()) {
                            idAttributes.put(attributeDef.getName(), (Any)attribute);
                        }
                        if (attributeDef.isHashAttribute()) {
                            hashAttributes.put(attributeDef.getName(), (Any)attribute);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private void fillRecord(MockAgentData data, Record record) throws AgentException {
        Attribute[] attributeArray = this._attributes;
        int n = this._attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Object value;
            Attribute attributeDef = attributeArray[n2];
            if (attributeDef.isAttachment()) {
                value = this.readAttachment(data, attributeDef);
                record.setAttachment(attributeDef.getName(), value);
            } else {
                value = this.readAttribute(data, attributeDef);
                if (value != null) {
                    Value attribute = DataFactory.DEFAULT.autoConvertValue(value);
                    record.getMetadata().put(attributeDef.getName(), (Any)attribute);
                }
            }
            ++n2;
        }
    }

    private Serializable readAttribute(MockAgentData data, Attribute attribute) throws AgentException {
        switch (attribute.getMockAttributes()) {
            case IDENTIFIER: {
                return data.getIdentifier();
            }
            case LAST_MODIFIED_DATE: {
                return data.getLastModified();
            }
            case MIME_TYPE: {
                return data.getMimeType();
            }
            case CONTENT: {
                return data.getContent();
            }
        }
        throw new RuntimeException("Unknown mock attributes type " + (Object)((Object)attribute.getMockAttributes()));
    }

    private byte[] readAttachment(MockAgentData data, Attribute attribute) throws AgentException {
        Serializable value = this.readAttribute(data, attribute);
        if (value != null) {
            if (value instanceof String) {
                try {
                    return ((String)((Object)value)).getBytes("utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new AgentException((Throwable)e);
                }
            }
            if (value instanceof byte[]) {
                return (byte[])value;
            }
        }
        return null;
    }

    private class MockAgentData {
        private final Date _lastModified;
        private final String _identifier;
        private final String _mimeType;
        private final String _content;

        MockAgentData() {
            long currentTime = System.currentTimeMillis();
            this._lastModified = new Date(currentTime);
            this._identifier = Long.toString(currentTime);
            this._mimeType = "text/plain";
            this._content = "This is some text content generated by MockAgent at " + this._lastModified;
        }

        public Date getLastModified() {
            return this._lastModified;
        }

        public String getIdentifier() {
            return this._identifier;
        }

        public String getMimeType() {
            return this._mimeType;
        }

        public String getContent() {
            return this._content;
        }
    }
}

