/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager;

import java.util.Collection;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.jobmanager.BucketDefinition;
import org.eclipse.smila.jobmanager.DataObjectTypeDefinition;
import org.eclipse.smila.jobmanager.util.IdGenerator;
import org.eclipse.smila.jobmanager.util.ValueExpression;
import org.eclipse.smila.taskmanager.BulkInfo;

public class Bucket {
    private final BucketDefinition _bucketDef;
    private final DataObjectTypeDefinition _dot;
    private String _bucketId;
    private String _storeName;
    private final DataObjectTypeDefinition.Mode _bucketMode;
    private final AnyMap _bucketParameters = DataFactory.DEFAULT.createAnyMap();

    public Bucket(BucketDefinition bucketDef, DataObjectTypeDefinition dot, boolean isPersistent, AnyMap parameters) {
        this._bucketDef = bucketDef;
        this._dot = dot;
        this._bucketMode = isPersistent ? DataObjectTypeDefinition.Mode.PERSISTENT : DataObjectTypeDefinition.Mode.TRANSIENT;
        this.applyParameters(parameters);
    }

    public BucketDefinition getBucketDefinition() {
        return this._bucketDef;
    }

    public DataObjectTypeDefinition getDataObjectTypeDefinition() {
        return this._dot;
    }

    public String getBucketId() {
        return this._bucketId;
    }

    public String getStoreName() {
        return this._storeName;
    }

    public boolean isPersistent() {
        return this._bucketMode == DataObjectTypeDefinition.Mode.PERSISTENT;
    }

    public boolean isTransient() {
        return this._bucketMode == DataObjectTypeDefinition.Mode.TRANSIENT;
    }

    public DataObjectTypeDefinition.Mode getMode() {
        return this._bucketMode;
    }

    private void applyParameters(AnyMap jobParameters) {
        this.mergeParameters(jobParameters);
        this._bucketId = this.createBucketId(this._bucketParameters);
        this._storeName = this._dot.getStore(this._bucketMode).evaluate(this._bucketParameters).getExpression();
        this._bucketParameters.put("_bucketName", this._bucketDef.getName());
        this._bucketParameters.put("_store", this._storeName);
    }

    private void mergeParameters(AnyMap jobParameters) {
        AnyMap bucketDefParams;
        if (jobParameters != null) {
            this._bucketParameters.putAll((Map)jobParameters);
        }
        if (this._bucketDef != null && (bucketDefParams = this._bucketDef.getParameters()) != null) {
            this._bucketParameters.putAll((Map)bucketDefParams);
        }
    }

    private String createBucketId(AnyMap jobParameters) {
        Collection<String> variables = this.getBucketIdVariables();
        StringBuilder idBuilder = new StringBuilder(this._bucketDef.getName());
        for (String variable : variables) {
            idBuilder.append('[').append(variable).append("=${").append(variable).append("}]");
        }
        ValueExpression bucketIdExpr = new ValueExpression(idBuilder.toString());
        return bucketIdExpr.evaluate(jobParameters).toString();
    }

    private Collection<String> getBucketIdVariables() {
        TreeSet<String> variables = new TreeSet<String>();
        for (String variable : this._dot.getStore(this._bucketMode).getVariables()) {
            if (variable.startsWith("_")) continue;
            variables.add(variable);
        }
        for (String variable : this._dot.getObject(this._bucketMode).getVariables()) {
            if (variable.startsWith("_")) continue;
            variables.add(variable);
        }
        return variables;
    }

    public BulkInfo createDataObject() {
        return this.createDataObject(null);
    }

    public BulkInfo createDataObject(AnyMap variableValues) {
        AnyMap parameters = DataFactory.DEFAULT.createAnyMap();
        if (variableValues != null) {
            parameters.putAll((Map)variableValues);
        }
        if (this._bucketParameters != null) {
            parameters.putAll((Map)this._bucketParameters);
        }
        if (!parameters.containsKey((Object)"_uuid")) {
            parameters.put("_uuid", IdGenerator.createBulkId());
        }
        for (String variable : this._dot.getObject(this._bucketMode).getVariables()) {
            if (parameters.containsKey((Object)variable)) continue;
            parameters.put(variable, "");
        }
        String objectName = this._dot.getObject(this._bucketMode).evaluate(parameters).getExpression();
        return new BulkInfo(this._bucketDef.getName(), this._storeName, objectName);
    }

    public String getDataObjectNamePrefix() {
        String objectName = this._dot.getObject(this._bucketMode).evaluate(this._bucketParameters).getExpression();
        int indexOfFirstVariable = objectName.indexOf("$");
        if (indexOfFirstVariable > 0) {
            String objectNamePrefix = objectName.substring(0, indexOfFirstVariable);
            return objectNamePrefix;
        }
        return null;
    }

    public Map<String, String> getDataObjectVariableValues(String objectId) {
        return this._dot.getObject(this._bucketMode).extractValues(objectId);
    }
}

