/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager;

import java.util.Date;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.jobmanager.InvalidConfigException;
import org.eclipse.smila.jobmanager.internal.AccessAny;

public class DefinitionBase {
    public static final String KEY_TIMESTAMP = "timestamp";
    public static final String KEY_NAME = "name";
    public static final String KEY_READ_ONLY = "readOnly";
    protected final String _name;
    protected final AnyMap _anyMap;
    protected final Date _timestamp;
    protected final boolean _readOnly;

    public DefinitionBase(AnyMap definitionAny) throws InvalidConfigException {
        this._anyMap = definitionAny;
        this._name = AccessAny.getStringRequired(definitionAny, KEY_NAME);
        this._timestamp = definitionAny.getDateTimeValue(KEY_TIMESTAMP);
        this._readOnly = definitionAny.containsKey((Object)KEY_READ_ONLY) ? definitionAny.getBooleanValue(KEY_READ_ONLY) : false;
    }

    protected DefinitionBase(String name) {
        this._name = name;
        this._timestamp = new Date();
        this._readOnly = false;
        this._anyMap = null;
    }

    public String getName() {
        return this._name;
    }

    public Date getTimestamp() {
        return this._timestamp;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public AnyMap toAny() {
        return this.toAny(true);
    }

    public String toString() {
        return this.toAny().toString();
    }

    public AnyMap toAny(boolean includingAdditionalAttributes) {
        if (includingAdditionalAttributes && this._anyMap != null) {
            return this._anyMap;
        }
        try {
            AnyMap workflowAny = DataFactory.DEFAULT.createAnyMap();
            workflowAny.put(KEY_NAME, this._name);
            if (this._timestamp != null) {
                workflowAny.put(KEY_TIMESTAMP, (Any)DataFactory.DEFAULT.createDateTimeValue(this._timestamp));
            }
            if (this._readOnly) {
                workflowAny.put(KEY_READ_ONLY, Boolean.valueOf(this._readOnly));
            }
            return workflowAny;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to create Any object for workflow " + this._name, ex);
        }
    }
}

