/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.clusterconfig.ClusterConfigService;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.jobmanager.Bucket;
import org.eclipse.smila.jobmanager.BucketDefinition;
import org.eclipse.smila.jobmanager.IllegalJobStateException;
import org.eclipse.smila.jobmanager.JobDefinition;
import org.eclipse.smila.jobmanager.JobManager;
import org.eclipse.smila.jobmanager.JobManagerException;
import org.eclipse.smila.jobmanager.JobRunDefinitions;
import org.eclipse.smila.jobmanager.JobRunInfo;
import org.eclipse.smila.jobmanager.JobRunMode;
import org.eclipse.smila.jobmanager.JobState;
import org.eclipse.smila.jobmanager.WorkerDefinition;
import org.eclipse.smila.jobmanager.WorkflowDefinition;
import org.eclipse.smila.jobmanager.events.JobListener;
import org.eclipse.smila.jobmanager.events.PrepareToFinishEvent;
import org.eclipse.smila.jobmanager.internal.JobRun;
import org.eclipse.smila.jobmanager.persistence.ConfigNotFoundException;
import org.eclipse.smila.jobmanager.persistence.DefinitionPersistence;
import org.eclipse.smila.jobmanager.persistence.DefinitionStorage;
import org.eclipse.smila.jobmanager.persistence.JobRunListener;
import org.eclipse.smila.jobmanager.persistence.PersistenceException;
import org.eclipse.smila.jobmanager.persistence.RunStorage;
import org.eclipse.smila.jobmanager.persistence.RunStorageException;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGenerator;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGeneratorException;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGeneratorProvider;
import org.eclipse.smila.jobmanager.util.IdGenerator;
import org.eclipse.smila.objectstore.NoSuchStoreException;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.objectstore.ServiceUnavailableException;
import org.eclipse.smila.objectstore.util.ObjectStoreRetryUtil;
import org.eclipse.smila.taskmanager.BulkInfo;
import org.eclipse.smila.taskmanager.ResultDescription;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskmanager.TaskCompletionStatus;
import org.eclipse.smila.taskmanager.TaskManager;
import org.eclipse.smila.taskmanager.TaskmanagerException;
import org.eclipse.smila.utils.collections.MultiValueMap;
import org.osgi.service.component.ComponentContext;

public class JobManagerImpl
implements JobManager,
JobRunListener {
    private static final int JOB_RUN_ID_SUFFIX_MAX = 1000;
    private static final Random RANDOM = new Random(System.nanoTime());
    private final Log _log = LogFactory.getLog(this.getClass());
    private DefinitionPersistence _defPersistence;
    private DefinitionStorage _defStorage;
    private RunStorage _runStorage;
    private ObjectStoreService _objectStore;
    private TaskGeneratorProvider _taskGeneratorProvider;
    private TaskManager _taskManager;
    private ClusterConfigService _clusterConfigService;
    private final Map<String, JobRun> _jobRuns = new HashMap<String, JobRun>();
    private final CopyOnWriteArrayList<JobListener> _jobListeners = new CopyOnWriteArrayList();

    protected void activate(ComponentContext context) {
        try {
            this._defPersistence = new DefinitionPersistence(this._defStorage, this, this._objectStore);
            Collection<String> workers = this._defPersistence.getWorkers();
            for (String worker : workers) {
                this._taskManager.addTaskQueue(worker);
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)"JobManager activate() successful");
            }
        }
        catch (Throwable e) {
            this._log.error((Object)"Error while activating 'org.eclipse.smila.jobmanager'.", e);
            throw new RuntimeException("Error while activating 'org.eclipse.smila.jobmanager'.", e);
        }
    }

    protected void deactivate(ComponentContext context) {
        this._defPersistence = null;
    }

    protected DefinitionPersistence getDefPersistence() {
        return this._defPersistence;
    }

    protected DefinitionStorage getDefStorage() {
        return this._defStorage;
    }

    protected RunStorage getRunStorage() {
        return this._runStorage;
    }

    protected ObjectStoreService getObjectStore() {
        return this._objectStore;
    }

    protected TaskGeneratorProvider getTaskGeneratorProvider() {
        return this._taskGeneratorProvider;
    }

    protected TaskManager getTaskManager() {
        return this._taskManager;
    }

    protected Map<String, JobRun> getJobRuns() {
        return this._jobRuns;
    }

    protected CopyOnWriteArrayList<JobListener> getJobListeners() {
        return this._jobListeners;
    }

    private JobDefinition getJob(String name) throws JobManagerException {
        JobDefinition job = this._defPersistence.getJob(name);
        if (job == null) {
            throw new ConfigNotFoundException("Job '" + name + "' not found.");
        }
        return job;
    }

    private WorkflowDefinition getWorkflow(String name) throws JobManagerException {
        WorkflowDefinition workflow = this._defPersistence.getWorkflow(name);
        if (workflow == null) {
            throw new ConfigNotFoundException("Workflow '" + name + "' not found.");
        }
        return workflow;
    }

    private WorkerDefinition getWorker(String name) throws ConfigNotFoundException {
        WorkerDefinition worker = this._defPersistence.getWorker(name);
        if (worker == null) {
            throw new ConfigNotFoundException("Worker '" + name + "' not found.");
        }
        return worker;
    }

    @Override
    public String startJob(String jobName) throws JobManagerException {
        return this.startJob(jobName, JobRunMode.STANDARD);
    }

    @Override
    public String startJob(String jobName, JobRunMode jobRunMode) throws JobManagerException {
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("start called for job '" + jobName + "', jobRunMode '" + (Object)((Object)jobRunMode) + "'"));
        }
        String jobId = null;
        JobState currentState = null;
        try {
            if (!this._defPersistence.hasJob(jobName)) {
                throw new IllegalArgumentException("No definition for job '" + jobName + "' exists.");
            }
            currentState = this._runStorage.getJobState(jobName);
            if (currentState != null) {
                throw new IllegalStateException("Job '" + jobName + "' is in state '" + (Object)((Object)currentState) + "'.");
            }
            JobRunDefinitions jobRunDefs = this.getJobRunDefinitions(jobName);
            jobId = this.createJobId();
            this._runStorage.startJobRun(jobName, jobId, jobRunMode, jobRunDefs);
            this._runStorage.registerJobRunListener(this, jobName);
            JobRun jobRun = this.ensureJobRun(jobName, jobId);
            this.checkBuckets(jobRun);
            this.addJobTriggers(jobRun);
            if (this._runStorage.setJobState(jobName, jobId, JobState.PREPARING, JobState.RUNNING)) {
                if (JobRunMode.RUNONCE == jobRunMode) {
                    this.executeRunOnceJob(jobRun);
                }
                if (this._log.isInfoEnabled()) {
                    this._log.info((Object)("started job run '" + jobId + "' for job '" + jobName + "'"));
                }
                return jobId;
            }
            throw new JobManagerException("Error while starting job '" + jobName + "' with jobId '" + jobId + "'. ");
        }
        catch (Exception e) {
            AnyMap jobData;
            String messagePrefix = "Could not start job '" + jobName + "': ";
            if (jobId != null && (currentState = this._runStorage.getJobState(jobName)) == null && (jobData = this.getJobRunData(jobName, jobId, false)) != null && jobData.getStringValue("state") != null) {
                currentState = JobState.valueOf(jobData.getStringValue("state"));
            }
            if (currentState == JobState.CANCELED || currentState == JobState.CANCELLING) {
                throw new JobManagerException(String.valueOf(messagePrefix) + "Job run was canceled while starting.", e);
            }
            this.cleanupFailedJobRun(jobName, jobId);
            throw new JobManagerException(String.valueOf(messagePrefix) + e.getMessage(), e);
        }
    }

    private JobRunDefinitions getJobRunDefinitions(String jobName) throws JobManagerException {
        JobRunDefinitions runDefs = new JobRunDefinitions();
        JobDefinition jobDef = this.getJob(jobName);
        runDefs.setJobDefinition(jobDef);
        WorkflowDefinition workflowDef = this.getWorkflow(jobDef.getWorkflow());
        runDefs.setWorkflowDefinition(workflowDef);
        Collection<String> workflowBuckets = workflowDef.getReferencedBuckets();
        Collection<String> persistentBuckets = this._defPersistence.getBuckets();
        persistentBuckets.retainAll(workflowBuckets);
        for (String bucket : persistentBuckets) {
            BucketDefinition bucketDef = this._defPersistence.getBucket(bucket);
            runDefs.addBucketDefinition(bucketDef);
        }
        return runDefs;
    }

    private void executeRunOnceJob(JobRun jobRun) throws JobManagerException, TaskmanagerException {
        String workflowRunId = this._runStorage.startWorkflowRun(jobRun.getJobName(), jobRun.getJobRunId());
        List<Task> followUpTasks = jobRun.getInitialRunOnceTasks(workflowRunId);
        if (!followUpTasks.isEmpty()) {
            this._runStorage.startTasks(jobRun.getJobName(), jobRun.getJobRunId(), workflowRunId, followUpTasks);
        }
        this.finishJob(jobRun.getJobName(), jobRun.getJobRunId());
        if (followUpTasks.isEmpty()) {
            this._runStorage.finishWorkflowRun(jobRun.getJobName(), jobRun.getJobRunId(), workflowRunId);
            this._runStorage.deleteWorkflowRun(jobRun.getJobName(), jobRun.getJobRunId(), workflowRunId);
            this.checkAndHandleJobRunCompleted(jobRun.getJobName(), jobRun.getJobRunId());
        }
        this._taskManager.addTasks(followUpTasks);
    }

    private void addJobTriggers(JobRun jobRun) throws RunStorageException {
        String jobName = jobRun.getJobName();
        for (Bucket triggerBucket : jobRun.getTriggerBuckets()) {
            this._runStorage.addJobTrigger(triggerBucket.getBucketId(), jobName);
        }
    }

    private void cleanupFailedJobRun(String jobName, String jobRunId) {
        if (jobRunId != null) {
            try {
                String currentJobRunId;
                if (this._jobRuns.containsKey(jobName) && jobRunId.equals(currentJobRunId = this._runStorage.getJobRunId(jobName))) {
                    this.removeJobTriggers(this._jobRuns.get(jobName));
                }
                this.completeJobRun(jobName, jobRunId, JobState.FAILED);
            }
            catch (Exception ex) {
                this._log.warn((Object)("Error while cleaning up failed job '" + jobName + "' with run '" + jobRunId + "' after prepare."), (Throwable)ex);
            }
        }
    }

    private void checkBuckets(JobRun jobRun) throws ObjectStoreException {
        for (Bucket bucket : jobRun.getBuckets()) {
            if (bucket.isTransient()) {
                ObjectStoreRetryUtil.retryEnsureStore((ObjectStoreService)this._objectStore, (String)bucket.getStoreName());
                continue;
            }
            if (ObjectStoreRetryUtil.retryExistsStore((ObjectStoreService)this._objectStore, (String)bucket.getStoreName())) continue;
            throw new NoSuchStoreException("Store '" + bucket.getStoreName() + "' of persistent bucket '" + bucket.getBucketId() + "' does not exist.");
        }
    }

    @Override
    public AnyMap getJobRunData(String jobName, String jobId) throws JobManagerException {
        return this.getJobRunData(jobName, jobId, false);
    }

    @Override
    public AnyMap getJobRunData(String jobName, String jobId, boolean returnDetails) throws JobManagerException {
        try {
            String jobRunId = this._runStorage.getJobRunId(jobName);
            if (jobId.equals(jobRunId)) {
                return this._runStorage.getJobRunData(jobName, returnDetails);
            }
        }
        catch (RunStorageException ex) {
            this._log.warn((Object)("Error determining live job run data for job '" + jobName + "'. Trying to read from history."), (Throwable)((Object)ex));
        }
        if (this._defStorage.containsJobRun(jobName, jobId)) {
            AnyMap jobRunData = this._defStorage.getJobRunData(jobName, jobId);
            if (!returnDetails && jobRunData != null) {
                jobRunData.remove((Object)"workflowDefinition");
                jobRunData.remove((Object)"bucketDefinitions");
            }
            return jobRunData;
        }
        throw new ConfigNotFoundException("No job run data available for run '" + jobId + "' of job '" + jobName + "'.");
    }

    @Override
    public AnyMap getWorkflowRunData(String jobName, String jobId, String workflowRunId) throws JobManagerException {
        String jobRunId = this._runStorage.getJobRunId(jobName);
        if (jobId.equals(jobRunId)) {
            return this._runStorage.getWorkflowRunData(jobName, workflowRunId);
        }
        throw new ConfigNotFoundException("No workflow run data available for run '" + jobId + "' of job '" + jobName + "'.");
    }

    @Override
    public JobRunInfo getJobRunInfo(String jobName) throws JobManagerException {
        return this._runStorage.getJobRunInfo(jobName);
    }

    @Override
    public Collection<String> getCompletedJobRunIds(String jobName) throws JobManagerException {
        Collection<String> completedJobRuns = this._defStorage.getJobRunIds(jobName);
        String currentjobRunRunId = this._runStorage.getJobRunId(jobName);
        if (currentjobRunRunId != null) {
            completedJobRuns.remove(currentjobRunRunId);
        }
        return completedJobRuns;
    }

    @Override
    public void deleteJobRunData(String jobName, String jobId) throws JobManagerException {
        String currentJobRunId = this._runStorage.getJobRunId(jobName);
        if (jobId.equals(currentJobRunId)) {
            throw new JobManagerException("Job run data of active job run cannot be deleted.");
        }
        this._defStorage.deleteJobRunData(jobName, jobId);
    }

    private boolean checkJobStateForTaskCreation(String jobName, String jobRunId, boolean isInitialTask) throws RunStorageException {
        JobState jobState = this._runStorage.getJobState(jobName, jobRunId);
        if (jobState == JobState.RUNNING) {
            return true;
        }
        return !isInitialTask && jobState == JobState.FINISHING;
    }

    private synchronized String createJobId() {
        Date date = new Date();
        return String.format("%1$tY%1$tm%1$td-%1$tH%1$tM%1$tS%1$tL%2$03d", date, RANDOM.nextInt(1000));
    }

    @Override
    public void finishJob(String jobName, String jobRunId) throws JobManagerException {
        JobState state;
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("finish called for job '" + jobName + "', run '" + jobRunId + "'"));
        }
        if ((state = this._runStorage.getJobState(jobName, jobRunId)) == JobState.RUNNING) {
            for (JobListener jobListener : this._jobListeners) {
                try {
                    jobListener.processJobEvent(new PrepareToFinishEvent(jobName, jobRunId));
                }
                catch (Throwable t) {
                    this._log.error((Object)("JobListener failed to process PrepareToFinishEvent for job '" + jobName + "', rob run id '" + jobRunId + "'."), t);
                }
            }
            if (this._runStorage.finishJobRun(jobName, jobRunId)) {
                this.removeJobTriggers(this.ensureJobRun(jobName, jobRunId));
                this.checkAndHandleJobRunCompleted(jobName, jobRunId);
            }
        } else if (state == null) {
            this.checkNonFoundJobRunWasPersisted(jobName, jobRunId);
        } else {
            throw new IllegalJobStateException("Job run '" + jobRunId + "' of job '" + jobName + "' couldn't be finished, because it's in state '" + (Object)((Object)state) + "'.");
        }
    }

    @Override
    public void cancelJob(String jobName, String jobRunId) throws JobManagerException {
        int tries = 0;
        boolean success = false;
        JobState state = null;
        do {
            ++tries;
            state = this._runStorage.getJobState(jobName, jobRunId);
            if (state == null) {
                this.checkNonFoundJobRunWasPersisted(jobName, jobRunId);
                continue;
            }
            if (state == JobState.CANCELLING || state == JobState.CANCELED) {
                throw new IllegalJobStateException("Job run '" + jobRunId + "' of job '" + jobName + "' couldn't be canceled, because someone else canceled it before.");
            }
            if (state == JobState.RUNNING || state == JobState.PREPARING || state == JobState.FINISHING) continue;
            throw new IllegalJobStateException("Job run '" + jobRunId + "' of job '" + jobName + "' couldn't be canceled, because it's in state '" + (Object)((Object)state) + "'.");
        } while (!(success = this._runStorage.setJobState(jobName, jobRunId, state, JobState.CANCELLING)) && tries <= 3);
        try {
            AnyMap taskFilter = DataFactory.DEFAULT.createAnyMap();
            taskFilter.put("jobName", jobName);
            taskFilter.put("jobRunId", jobRunId);
            this._taskManager.removeTasks(taskFilter);
            List<String> canceledWorkflowRunIds = this._runStorage.cancelJobRun(jobName, jobRunId);
            for (String canceledWorkflowRun : canceledWorkflowRunIds) {
                this.deleteTransientBulks(jobName, jobRunId, canceledWorkflowRun);
            }
            this.completeJobRun(jobName, jobRunId, JobState.CANCELED);
        }
        catch (TaskmanagerException e) {
            throw new JobManagerException("Error while canceling job run '" + jobRunId + "' of job '" + jobName + "': TaskManager couldn't remove canceled tasks", e);
        }
        catch (Exception e) {
            throw new JobManagerException("Error while canceling job run '" + jobRunId + "' of job '" + jobName + "'", e);
        }
    }

    private void checkNonFoundJobRunWasPersisted(String jobName, String jobRunId) throws JobManagerException {
        if (!this._defPersistence.hasJob(jobName)) {
            throw new ConfigNotFoundException("Couldn't find job definition '" + jobName + "'.");
        }
        if (!this._defStorage.containsJobRun(jobName, jobRunId)) {
            throw new ConfigNotFoundException("Couldn't find job run '" + jobRunId + "' for job '" + jobName + "'.");
        }
        throw new IllegalJobStateException("Requested job run '" + jobRunId + "' of job '" + jobName + "' was already closed, can be found in job run history.", true);
    }

    private void removeJobTriggers(JobRun jobRun) throws RunStorageException {
        String jobName = jobRun.getJobName();
        for (Bucket triggerBucket : jobRun.getTriggerBuckets()) {
            try {
                this._runStorage.removeJobTrigger(triggerBucket.getBucketId(), jobName);
            }
            catch (Exception ex) {
                this._log.info((Object)("Could not remove job '" + jobName + "' from trigger bucket '" + triggerBucket.getBucketId() + "'. This is not critical."), (Throwable)ex);
            }
        }
    }

    @Override
    public Task getInitialTask(String workerName, String jobName) throws JobManagerException {
        String jobRunId = null;
        String workflowRunId = null;
        Task task = null;
        jobRunId = this._runStorage.getJobRunId(jobName);
        if (jobRunId == null || !this.checkJobStateForTaskCreation(jobName, jobRunId, true)) {
            throw new IllegalJobStateException("Job with name '" + jobName + "' is not running or is already finishing.");
        }
        JobRun jobRun = this.ensureJobRun(jobName, jobRunId);
        try {
            workflowRunId = this._runStorage.startWorkflowRun(jobName, jobRunId);
            task = jobRun.getInitialTask(workerName, workflowRunId);
            task.getProperties().put("recoverable", Boolean.toString(Boolean.FALSE));
            this._runStorage.startTask(jobName, jobRunId, workflowRunId, workerName, task.getTaskId());
            this._taskManager.addInProgressTask(task);
            return task;
        }
        catch (Exception e) {
            this.cleanupFailedWorkflowRun(jobName, jobRunId, workflowRunId, workerName, task);
            throw new JobManagerException("Getting initial task failed for worker '" + workerName + "' for job '" + jobName + "' due to error.", e);
        }
    }

    private void cleanupFailedWorkflowRun(String jobName, String jobRunId, String workerName, String workflowRunId, Task task) {
        if (jobRunId != null && workflowRunId != null) {
            try {
                this.handleFatalError(jobName, jobRunId, workflowRunId, workerName, task, false);
            }
            catch (Exception ex) {
                this._log.error((Object)("Error during cleanup of failed new workflow run '" + jobRunId + "' for job '" + jobName + "'."), (Throwable)ex);
            }
        }
    }

    private synchronized JobRun ensureJobRun(String jobName, String jobRunId) throws JobManagerException {
        JobRun jobRun = this._jobRuns.get(jobName);
        if (jobRun == null || !jobRunId.equals(jobRun.getJobRunId())) {
            try {
                jobRun = new JobRun(jobRunId, jobName, this._runStorage, this._defPersistence, this._taskGeneratorProvider);
            }
            catch (Exception e) {
                throw new JobManagerException("Error during creation of job run: ", e);
            }
            this._jobRuns.put(jobName, jobRun);
        }
        return jobRun;
    }

    private List<Task> createFollowUpTasks(Task currentTask, JobRun jobRun, String workflowRunId) throws JobManagerException {
        MultiValueMap<String, BulkInfo> bucketNameToCreatedBulksMap = this.checkOutputBulksForCreation(jobRun, currentTask);
        ArrayList<JobRun> triggeredJobs = new ArrayList<JobRun>();
        for (Map.Entry bucketToBulksEntry : bucketNameToCreatedBulksMap.entrySet()) {
            String bucketName = (String)bucketToBulksEntry.getKey();
            if (jobRun.getBucket(bucketName).isPersistent()) {
                triggeredJobs.addAll(this.getJobsTriggeredByBucket(jobRun, bucketName));
                continue;
            }
            this.storeTransientBulks(jobRun, workflowRunId, (List)bucketToBulksEntry.getValue());
        }
        AnyMap taskParamsToCopy = this.getTaskParametersToCopy(currentTask);
        List<Task> followUpTasks = jobRun.getFollowupTasks(workflowRunId, bucketNameToCreatedBulksMap, taskParamsToCopy);
        for (JobRun triggeredJob : triggeredJobs) {
            try {
                List<Task> triggeredTasks = triggeredJob.getTriggeredInitialTasks(bucketNameToCreatedBulksMap);
                if (triggeredTasks.isEmpty()) continue;
                String triggeredJobWorkflowRunId = this._runStorage.startWorkflowRun(triggeredJob.getJobName(), triggeredJob.getJobRunId());
                for (Task task : triggeredTasks) {
                    task.getProperties().put("workflowRunId", triggeredJobWorkflowRunId);
                }
                followUpTasks.addAll(triggeredTasks);
            }
            catch (Exception e) {
                this._log.error((Object)("Tried to create tasks for potentially triggered jobs, but got an error. Job '" + triggeredJob.getJobName() + "' will not be triggered."), (Throwable)e);
            }
        }
        return followUpTasks;
    }

    private AnyMap getTaskParametersToCopy(Task currentTask) {
        AnyMap taskParams = currentTask.getParameters();
        AnyMap paramsToCopy = DataFactory.DEFAULT.createAnyMap();
        for (Map.Entry param : taskParams.entrySet()) {
            if (!((String)param.getKey()).startsWith("_") || ((String)param.getKey()).startsWith("_temp")) continue;
            paramsToCopy.put((String)param.getKey(), (Any)param.getValue());
        }
        return paramsToCopy;
    }

    @Override
    public List<Task> finishTask(Task currentTask) throws JobManagerException {
        ResultDescription resultDescription = currentTask.getResultDescription();
        String workflowRunId = (String)currentTask.getProperties().get("workflowRunId");
        String jobRunId = (String)currentTask.getProperties().get("jobRunId");
        String jobName = (String)currentTask.getProperties().get("jobName");
        String workerName = this.getOriginalWorkerName(currentTask);
        if (!this._runStorage.hasTask(jobName, workflowRunId, currentTask.getTaskId())) {
            throw new IllegalJobStateException("Task '" + currentTask.getTaskId() + "' for job '" + jobName + "' and run '" + jobRunId + "' is unknown, maybe already finished or workflow run was canceled.");
        }
        try {
            switch (resultDescription.getStatus()) {
                case SUCCESSFUL: {
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("Successfully handles task '" + currentTask.getTaskId() + "' of worker '" + workerName + "' in job run '" + jobRunId + "' of job '" + jobName + "'"));
                    }
                    return this.handleSuccessfulTask(jobName, jobRunId, workflowRunId, workerName, currentTask, resultDescription.getCounters());
                }
                case OBSOLETE: {
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("Obsolete task '" + currentTask.getTaskId() + "' of worker '" + workerName + "' in job run '" + jobRunId + "' of job '" + jobName + "'"));
                    }
                    this.handleObsoleteTask(jobName, jobRunId, workflowRunId, workerName, currentTask);
                    return Collections.emptyList();
                }
                case RECOVERABLE_ERROR: {
                    this._log.warn((Object)("A recoverable error '" + resultDescription.getErrorCode() + "'('" + resultDescription.getErrorMessage() + "') occurred in processing of task '" + currentTask.getTaskId() + "' for worker '" + workerName + "'"));
                    return this.handleRecoverableTaskError(jobName, jobRunId, workflowRunId, workerName, currentTask, resultDescription);
                }
            }
            this._log.error((Object)("A fatal error '" + resultDescription.getErrorCode() + "'('" + resultDescription.getErrorMessage() + "') occurred in processing of task " + currentTask.getTaskId() + " of worker " + workerName + ". Workflow run '" + workflowRunId + "' will be marked as failed, its tasks will be canceled."));
            this.handleFatalError(jobName, jobRunId, workflowRunId, workerName, currentTask, false);
            return new ArrayList<Task>();
        }
        catch (JobManagerException jme) {
            if (resultDescription.getStatus() != TaskCompletionStatus.FATAL_ERROR && !jme.isRecoverable()) {
                try {
                    this.handleFatalError(jobName, jobRunId, workflowRunId, workerName, currentTask, false);
                }
                catch (JobManagerException e) {
                    this._log.error((Object)"Exception while handling fatal error during nonrecoverable finishing exception.", (Throwable)((Object)e));
                }
            }
            throw jme;
        }
    }

    private String getOriginalWorkerName(Task currentTask) {
        return (String)currentTask.getProperties().get("originalWorker");
    }

    protected List<Task> handleSuccessfulTask(String jobName, String jobRunId, String workflowRunId, String workerName, Task currentTask, Map<String, Number> workerCounter) throws JobManagerException {
        ArrayList<Task> followUpTasks = new ArrayList<Task>();
        try {
            JobRun jobRun = this.ensureJobRun(jobName, jobRunId);
            WorkerDefinition worker = jobRun.getWorkerDefinition(workerName);
            if (!this.checkJobStateForTaskCreation(jobName, jobRunId, false)) {
                throw new IllegalJobStateException("Could not finish Task. Job with name'" + jobName + "' is not running or is already completed.");
            }
            followUpTasks.addAll(this.createFollowUpTasks(currentTask, jobRun, workflowRunId));
            for (Task newTask : followUpTasks) {
                String newTaskJobName = (String)newTask.getProperties().get("jobName");
                String newTaskJobRunId = (String)newTask.getProperties().get("jobRunId");
                String newTaskWfRunId = (String)newTask.getProperties().get("workflowRunId");
                this._runStorage.startTask(newTaskJobName, newTaskJobRunId, newTaskWfRunId, newTask.getWorkerName(), newTask.getTaskId());
                this._taskManager.addTask(newTask);
            }
            this.notifyTaskGenerator(worker, currentTask, TaskCompletionStatus.SUCCESSFUL);
            this._runStorage.finishTask(jobName, jobRunId, workflowRunId, workerName, currentTask.getTaskId(), workerCounter, currentTask.getProperties());
            if (this.checkAndHandleWorkflowRunCompleted(jobName, jobRunId, workflowRunId)) {
                this.checkAndHandleJobRunCompleted(jobName, jobRunId);
            }
        }
        catch (Exception e) {
            throw new JobManagerException("Error while handling successful task '" + currentTask.getTaskId() + "' in job run '" + jobRunId + "' of job '" + jobName + "'.", e);
        }
        return followUpTasks;
    }

    private void notifyTaskGenerator(WorkerDefinition worker, Task task, TaskCompletionStatus status) throws TaskGeneratorException {
        TaskGenerator taskGenerator = this.getTaskGenerator(worker);
        taskGenerator.finishTask(task, status);
    }

    protected void handleObsoleteTask(String jobName, String jobRunId, String workflowRunId, String workerName, Task currentTask) throws JobManagerException {
        try {
            JobRun jobRun = this.ensureJobRun(jobName, jobRunId);
            WorkerDefinition worker = jobRun.getWorkerDefinition(workerName);
            if (!this.checkJobStateForTaskCreation(jobName, jobRunId, false)) {
                throw new IllegalJobStateException("Could not finish obsolete task '" + currentTask.getTaskId() + "'. Job with name'" + jobName + "' is not running or is already completed.");
            }
            this.notifyTaskGenerator(worker, currentTask, TaskCompletionStatus.OBSOLETE);
            this._runStorage.obsoleteTask(jobName, jobRunId, workflowRunId, workerName, currentTask.getTaskId(), currentTask.getProperties());
            if (this.checkAndHandleWorkflowRunCompleted(jobName, jobRunId, workflowRunId)) {
                this.checkAndHandleJobRunCompleted(jobName, jobRunId);
            }
        }
        catch (Exception e) {
            throw new JobManagerException("Error while handling obsolete task '" + currentTask.getTaskId() + "' in job run '" + jobRunId + "' of job '" + jobName + "'.", e);
        }
    }

    private void removeStoreObjectQuietly(String storeName, String objectId) {
        try {
            this._objectStore.removeObject(storeName, objectId);
        }
        catch (Exception ex) {
            this._log.warn((Object)("Error removing obsolete input object '" + objectId + "'"), (Throwable)ex);
        }
    }

    protected List<Task> handleRecoverableTaskError(String jobName, String jobRunId, String workflowRunId, String workerName, Task currentTask, ResultDescription resultDescription) throws JobManagerException {
        ArrayList<Task> followUpTasks = new ArrayList<Task>();
        try {
            WorkerDefinition worker;
            try {
                worker = this.getWorker(workerName);
            }
            catch (ConfigNotFoundException e) {
                throw new JobManagerException("Worker '" + workerName + "' not found while handling recoverable task '" + currentTask.getTaskId() + "' in job run '" + jobRunId + "' of job '" + jobName + "'.", (Throwable)((Object)e));
            }
            if (worker.getModes().contains((Object)WorkerDefinition.Mode.AUTOCOMMIT)) {
                this.handleRecoverableTaskWithAutocommit(jobName, jobRunId, workflowRunId, workerName, currentTask, resultDescription, followUpTasks);
            } else if (currentTask.getProperties().containsKey("recoverable") && !Boolean.valueOf((String)currentTask.getProperties().get("recoverable")).booleanValue()) {
                this._log.warn((Object)("Could not retry failed task '" + currentTask.getTaskId() + "' cause it's not recoverable."));
                this.handleFatalError(jobName, jobRunId, workflowRunId, workerName, currentTask, false);
            } else {
                int numberOfRetries = this._runStorage.getTaskRetries(jobName, jobRunId, workflowRunId, workerName, currentTask.getTaskId()) + 1;
                if ((long)numberOfRetries <= this._clusterConfigService.getMaxRetries()) {
                    this._runStorage.retriedTask(jobName, jobRunId, workflowRunId, workerName, currentTask.getTaskId(), !"TimeToLive".equals(resultDescription.getErrorCode()), currentTask.getProperties());
                    Task retryTask = currentTask.createRetryTask(IdGenerator.createTaskId());
                    this._taskManager.addTask(retryTask);
                    this._runStorage.startTask(jobName, jobRunId, workflowRunId, retryTask.getWorkerName(), retryTask.getTaskId(), numberOfRetries);
                    followUpTasks.add(retryTask);
                } else {
                    this._log.error((Object)("Could not retry failed recoverable task '" + currentTask.getTaskId() + "' , because maximum number of retries was reached."));
                    this.handleFatalError(jobName, jobRunId, workflowRunId, workerName, currentTask, true);
                }
            }
        }
        catch (Exception e) {
            throw new JobManagerException("Error while handling recoverable task '" + currentTask.getTaskId() + "' in job run '" + jobRunId + "' of job '" + jobName + "'.", e);
        }
        return followUpTasks;
    }

    protected void handleRecoverableTaskWithAutocommit(String jobName, String jobRunId, String workflowRunId, String workerName, Task currentTask, ResultDescription resultDescription, List<Task> followUpTasks) throws JobManagerException {
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("Task '" + currentTask.getTaskId() + "' of autocommit worker '" + workerName + "' in job '" + jobName + "' failed with an recoverable error: finishing it as successful."));
        }
        for (Map.Entry entry : currentTask.getOutputBulks().entrySet()) {
            for (BulkInfo bulkInfo : (List)entry.getValue()) {
                String storeName = bulkInfo.getStoreName();
                String objectId = bulkInfo.getObjectName();
                try {
                    if (!ObjectStoreRetryUtil.retryExistsObject((ObjectStoreService)this.getObjectStore(), (String)storeName, (String)objectId)) continue;
                    this.getObjectStore().finishObject(storeName, objectId);
                }
                catch (ServiceUnavailableException ex) {
                    this._log.warn((Object)("Error finishing object '" + objectId + "' in store '" + storeName + "', retrying."), (Throwable)ex);
                    throw new JobManagerException("Could not finish object '" + objectId + "' in store '" + storeName + "'.", ex);
                }
                catch (Exception ex) {
                    this._log.warn((Object)("Error finishing object '" + objectId + "' in store '" + storeName + "', ignoring and continuing."), (Throwable)ex);
                }
            }
        }
        followUpTasks.addAll(this.handleSuccessfulTask(jobName, jobRunId, workflowRunId, workerName, currentTask, resultDescription.getCounters()));
    }

    protected void handleFatalError(String jobName, String jobRunId, String workflowRunId, String workerName, Task currentTask, boolean failedAfterRetry) throws JobManagerException {
        try {
            try {
                WorkerDefinition worker = this.getWorker(workerName);
                this.notifyTaskGenerator(worker, currentTask, TaskCompletionStatus.FATAL_ERROR);
            }
            finally {
                this._runStorage.failedTask(jobName, jobRunId, workflowRunId, workerName, currentTask.getTaskId(), failedAfterRetry, currentTask.getProperties());
                if (this._runStorage.failedWorkflowRun(jobName, jobRunId, workflowRunId)) {
                    this.deleteTransientBulks(jobName, jobRunId, workflowRunId);
                    this._runStorage.deleteWorkflowRun(jobName, jobRunId, workflowRunId);
                    this.checkAndHandleJobRunCompleted(jobName, jobRunId);
                }
            }
        }
        catch (Exception e) {
            throw new JobManagerException("Error while handling failed task in workflow run '" + workflowRunId + "' in job run '" + jobRunId + "' of job '" + jobName + "'.", e);
        }
    }

    private void storeTransientBulks(JobRun jobRun, String workflowRunId, List<BulkInfo> transientBulks) throws RunStorageException {
        String jobName = jobRun.getJobName();
        String jobRunId = jobRun.getJobRunId();
        for (BulkInfo bulkInfo : transientBulks) {
            this._runStorage.addTransientBulk(jobName, jobRunId, workflowRunId, String.valueOf(bulkInfo.getStoreName()) + "/" + bulkInfo.getObjectName());
        }
    }

    private boolean checkAndHandleWorkflowRunCompleted(String jobName, String jobRunId, String workflowRunId) throws JobManagerException {
        boolean completed = this.isWorkflowRunCompleted(jobName, jobRunId, workflowRunId);
        if (completed) {
            this.deleteTransientBulks(jobName, jobRunId, workflowRunId);
            if (this._runStorage.finishWorkflowRun(jobName, jobRunId, workflowRunId)) {
                this._runStorage.deleteWorkflowRun(jobName, jobRunId, workflowRunId);
            }
        }
        return completed;
    }

    private void checkAndHandleJobRunCompleted(String jobName, String jobRunId) throws JobManagerException {
        if (this.isJobRunCompleted(jobName, jobRunId)) {
            boolean success = this._runStorage.setJobState(jobName, jobRunId, JobState.FINISHING, JobState.COMPLETING);
            if (success) {
                this.completeJobRun(jobName, jobRunId, JobState.SUCCEEDED);
            } else {
                this._log.warn((Object)("Couldn't change job state from " + (Object)((Object)JobState.FINISHING) + " to " + (Object)((Object)JobState.COMPLETING) + " for job run '" + jobRunId + "' of job '" + jobName + "'"));
            }
        }
    }

    private void completeJobRun(String jobName, String jobRunId, JobState finalState) throws JobManagerException {
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("Completing job run '" + jobRunId + "' for job '" + jobName + "' with final state " + (Object)((Object)finalState)));
        }
        AnyMap jobRunData = DataFactory.DEFAULT.createAnyMap();
        String currentJobRunId = this._runStorage.getJobRunId(jobName);
        if (jobRunId.equals(currentJobRunId)) {
            jobRunData.putAll((Map)this._runStorage.getJobRunData(jobName, true));
            if (finalState == JobState.SUCCEEDED) {
                AnyMap workflowRunData = jobRunData.getMap("workflowRuns");
                int startedWorkflowRuns = Integer.parseInt(workflowRunData.getStringValue("startedWorkflowRunCount"));
                int successfulWorkflowRuns = Integer.parseInt(workflowRunData.getStringValue("successfulWorkflowRunCount"));
                if (startedWorkflowRuns > 0 && successfulWorkflowRuns == 0) {
                    finalState = JobState.FAILED;
                }
            }
        }
        jobRunData.put("state", finalState.name());
        jobRunData.put("endTime", this._runStorage.getCurrentTimestamp());
        this._defStorage.storeJobRun(jobName, jobRunId, this.sortedJobRunData(jobRunData));
        if (jobRunId.equals(currentJobRunId)) {
            this._runStorage.deleteJobRun(jobName, jobRunId);
            this._jobRuns.remove(jobName);
        }
    }

    private AnyMap sortedJobRunData(AnyMap jobRunData) {
        TreeMap<String, Any> simpleValues = new TreeMap<String, Any>();
        AnyMap complexValues = jobRunData.getFactory().createAnyMap();
        for (Map.Entry entry : jobRunData.entrySet()) {
            String key = (String)entry.getKey();
            Any value = (Any)entry.getValue();
            if (value.isValue()) {
                simpleValues.put(key, value);
                continue;
            }
            complexValues.put(key, value);
        }
        AnyMap sortedData = jobRunData.getFactory().createAnyMap();
        sortedData.putAll(simpleValues);
        sortedData.putAll((Map)complexValues);
        return sortedData;
    }

    private MultiValueMap<String, BulkInfo> checkOutputBulksForCreation(JobRun jobRun, Task task) throws JobManagerException {
        WorkerDefinition workerDef = jobRun.getWorkerDefinition(this.getOriginalWorkerName(task));
        MultiValueMap outputBulkMap = new MultiValueMap();
        for (Map.Entry currentEntry : task.getOutputBulks().entrySet()) {
            String currentSlotName = (String)currentEntry.getKey();
            boolean isOptional = workerDef.getOutput(currentSlotName).getModes().contains((Object)WorkerDefinition.OutputMode.OPTIONAL);
            for (BulkInfo bulkInfo : (List)currentEntry.getValue()) {
                String storeName = bulkInfo.getStoreName();
                String objectName = bulkInfo.getObjectName();
                try {
                    if (!ObjectStoreRetryUtil.retryExistsObject((ObjectStoreService)this._objectStore, (String)storeName, (String)objectName)) {
                        if (isOptional) continue;
                        throw new JobManagerException("Output bulk '" + objectName + "' in bucket '" + bulkInfo.getBucketName() + "' of worker '" + workerDef.getName() + "' (job '" + jobRun.getJobName() + "') has not been created but is not optional.");
                    }
                    outputBulkMap.add((Object)bulkInfo.getBucketName(), (Object)bulkInfo);
                }
                catch (Exception e) {
                    throw new JobManagerException(String.valueOf(e.getClass().getName()) + " occurred while checking output buckets.", e);
                }
            }
        }
        return outputBulkMap;
    }

    private Collection<JobRun> getJobsTriggeredByBucket(JobRun triggeringJobRun, String bucketName) throws JobManagerException {
        Bucket triggeringBucket = triggeringJobRun.getBucket(bucketName);
        Collection<String> jobNames = this._runStorage.getTriggeredJobs(triggeringBucket.getBucketId());
        jobNames.remove(triggeringJobRun.getJobName());
        ArrayList<JobRun> triggeredJobs = new ArrayList<JobRun>();
        for (String jobName : jobNames) {
            try {
                String jobRunId;
                JobRun jobRun;
                JobRunInfo runInfo = this._runStorage.getJobRunInfo(jobName);
                if (runInfo == null || runInfo.getState() != JobState.RUNNING || !(jobRun = this.ensureJobRun(jobName, jobRunId = runInfo.getId())).isTriggeredBy(triggeringBucket)) continue;
                triggeredJobs.add(jobRun);
            }
            catch (Exception e) {
                this._log.warn((Object)("Tried to check potentially triggered jobs, but got an error. Job '" + jobName + "' will not be triggered."), (Throwable)e);
            }
        }
        return triggeredJobs;
    }

    private boolean isWorkflowRunCompleted(String jobName, String jobRunId, String workflowRunId) throws RunStorageException {
        return !this._runStorage.hasTasks(jobName, jobRunId, workflowRunId);
    }

    private boolean isJobRunCompleted(String jobName, String jobRunId) throws RunStorageException {
        return this._runStorage.getJobState(jobName) == JobState.FINISHING && !this._runStorage.hasWorkflowRuns(jobName, jobRunId);
    }

    private void deleteTransientBulks(String jobName, String jobRunId, String workflowRunId) {
        try {
            Collection<String> transientBulks = this._runStorage.getTransientBulks(jobName, jobRunId, workflowRunId);
            for (String transientBulkId : transientBulks) {
                int indexOfSlash = transientBulkId.indexOf(47);
                if (indexOfSlash <= 0 || transientBulkId.length() <= indexOfSlash) {
                    this._log.warn((Object)("Stored transient bulk id '" + transientBulkId + "' is invalid, skipping"));
                    continue;
                }
                String storeName = transientBulkId.substring(0, indexOfSlash);
                String objectId = transientBulkId.substring(indexOfSlash + 1);
                try {
                    this.removeStoreObjectQuietly(storeName, objectId);
                    if (!this._log.isDebugEnabled()) continue;
                    this._log.debug((Object)("Deleted transient bulk '" + objectId + "' from store'" + storeName + "'."));
                }
                catch (Exception e) {
                    this._log.warn((Object)("Error while deleting transient bulk object '" + objectId + "' in store '" + storeName + "'. It could not be deleted."), (Throwable)e);
                }
            }
        }
        catch (JobManagerException ex) {
            this._log.warn((Object)"Failed to retrieve stored transient bulk Ids, obsolete data remains in stores possibly.", (Throwable)((Object)ex));
        }
    }

    public void setDefinitionStorage(DefinitionStorage defStorage) {
        this._defStorage = defStorage;
    }

    public void unsetDefinitionStorage(DefinitionStorage defStorage) {
        if (this._defStorage == defStorage) {
            this._defStorage = null;
        }
    }

    public void setRunStorage(RunStorage runStorage) {
        this._runStorage = runStorage;
    }

    public void unsetRunStorage(RunStorage runStorage) {
        if (this._runStorage == runStorage) {
            this._runStorage = null;
        }
    }

    public void setObjectStoreService(ObjectStoreService objectStore) {
        this._objectStore = objectStore;
    }

    public void unsetObjectStoreService(ObjectStoreService objectStore) {
        if (this._objectStore == objectStore) {
            this._objectStore = null;
        }
    }

    public void setTaskGeneratorProvider(TaskGeneratorProvider taskGeneratorProvider) {
        this._taskGeneratorProvider = taskGeneratorProvider;
    }

    public void unsetTaskGeneratorProvider(TaskGeneratorProvider taskGeneratorProvider) {
        if (this._taskGeneratorProvider == taskGeneratorProvider) {
            this._taskGeneratorProvider = null;
        }
    }

    public void setTaskManager(TaskManager taskManager) {
        this._taskManager = taskManager;
    }

    public void unsetTaskManager(TaskManager taskManager) {
        if (this._taskManager == taskManager) {
            this._taskManager = null;
        }
    }

    public void setClusterConfigService(ClusterConfigService clusterConfigService) {
        this._clusterConfigService = clusterConfigService;
    }

    public void unsetClusterConfigService(ClusterConfigService clusterConfigService) {
        if (this._clusterConfigService == clusterConfigService) {
            this._clusterConfigService = null;
        }
    }

    @Override
    public TaskGenerator getTaskGenerator(WorkerDefinition worker) {
        TaskGenerator taskGenerator = worker.getTaskGenerator() != null && !worker.getTaskGenerator().equals("") ? this._taskGeneratorProvider.getTaskGenerator(worker.getTaskGenerator()) : this._taskGeneratorProvider.getDefaultTaskGenerator();
        return taskGenerator;
    }

    public void addJobListener(JobListener listener) {
        this._jobListeners.add(listener);
    }

    public void removeJobListener(JobListener listener) {
        if (this._jobListeners.contains(listener)) {
            this._jobListeners.remove(listener);
        }
    }

    @Override
    public DefinitionPersistence getDefinitionPersistence() {
        return this._defPersistence;
    }

    @Override
    public Map<String, String> getJobRunsUsingStore(String storeName) {
        HashMap<String, String> jobRuns = new HashMap<String, String>();
        try {
            Collection<String> currentJobs = this._runStorage.getCurrentJobs();
            for (String jobName : currentJobs) {
                String jobRunId = this._runStorage.getJobRunId(jobName);
                JobRun jobRun = null;
                if (jobRunId == null) continue;
                try {
                    jobRun = this.ensureJobRun(jobName, jobRunId);
                }
                catch (JobManagerException jobManagerException) {}
                if (jobRun == null) continue;
                Collection<Bucket> buckets = jobRun.getBuckets();
                for (Bucket bucket : buckets) {
                    if (!bucket.getStoreName().equals(storeName)) continue;
                    jobRuns.put(jobName, jobRunId);
                }
            }
        }
        catch (RunStorageException runStorageException) {}
        return jobRuns;
    }

    @Override
    public synchronized void notifiyAboutJobRunCompletion(String jobName) {
        JobRun jobRun = this._jobRuns.get(jobName);
        if (jobRun != null) {
            String jobRunId = jobRun.getJobRunId();
            try {
                if (this._defStorage.containsJobRun(jobName, jobRunId)) {
                    this._jobRuns.remove(jobName);
                }
            }
            catch (PersistenceException e) {
                this._log.warn((Object)"Error while checking if job run is finished.", (Throwable)((Object)e));
            }
        }
    }
}

