/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.messages.fieldrequest;

import org.eclipse.smila.search.messages.fieldrequest.DField;
import org.eclipse.smila.search.messages.fieldrequest.FieldRequestException;
import org.eclipse.smila.search.utils.search.DSearchException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DFieldCodec {
    private DFieldCodec() {
    }

    public static Element encode(DField field, Element parent) throws FieldRequestException {
        if (parent == null) {
            throw new FieldRequestException("parameter must not be null [parent]");
        }
        if (field == null) {
            throw new FieldRequestException("parameter must not be null [field]");
        }
        Document doc = parent.getOwnerDocument();
        Element el = doc.createElementNS("http://www.anyfinder.de/FieldRequest", "Field");
        el.setAttribute("ReferenceID", field.getReferenceID());
        try {
            org.eclipse.smila.search.utils.search.DFieldCodec.encode((org.eclipse.smila.search.utils.search.DField)field.getField(), (Element)el);
        }
        catch (DSearchException exception) {
            throw new FieldRequestException("unable to encode field.", exception);
        }
        parent.appendChild(el);
        return el;
    }

    public static DField decode(Element element) throws FieldRequestException {
        if (element == null) {
            throw new FieldRequestException("parameter must not be null [element]");
        }
        DField field = new DField();
        field.setReferenceID(element.getAttribute("ReferenceID"));
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Element el;
            if (nl.item(i) instanceof Element && "Field".equals((el = (Element)nl.item(i)).getLocalName())) {
                try {
                    org.eclipse.smila.search.utils.search.DField ssField = org.eclipse.smila.search.utils.search.DFieldCodec.decode((Element)el);
                    field.setField(ssField);
                }
                catch (DSearchException exception) {
                    throw new FieldRequestException("unable to decode field.", exception);
                }
            }
            ++i;
        }
        return field;
    }
}

