/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.templates;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.smila.search.templates.NodeTransformer;
import org.eclipse.smila.search.templates.NodeTransformerException;
import org.eclipse.smila.search.utils.param.def.DParameterDefinition;
import org.eclipse.smila.search.utils.param.def.DParameterDefinitionCodec;
import org.eclipse.smila.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class NodeTransformerType {
    public static final String EXTENSION_POINT = "org.eclipse.smila.search.templates.nodetransformer";
    private static Hashtable<String, NodeTransformerType> s_cachedNodeTransformerTypes;
    public static final NodeTransformerType UNKNOWN;
    private static final String ATT_NAME = "Name";
    private static final String ATT_CLASS_NAME = "ClassName";
    private static final String TAG_NODE_TRANSFORMER = "NodeTransformer";
    private final String _name;
    private final String _className;
    private final int _ordinal;
    private final IConfigurationElement _configurationElement;
    private NodeTransformer _nodeTransformer;

    static {
        UNKNOWN = new NodeTransformerType();
    }

    private NodeTransformerType() {
        this._configurationElement = null;
        this._ordinal = 0;
        this._name = "Unknown";
        this._className = null;
    }

    private NodeTransformerType(IConfigurationElement configurationElement, int ordinal) {
        this._configurationElement = configurationElement;
        this._ordinal = ordinal;
        this._name = NodeTransformerType.getAttribute(configurationElement, ATT_NAME, null);
        this._className = NodeTransformerType.getAttribute(configurationElement, ATT_CLASS_NAME, null);
    }

    private static String getAttribute(IConfigurationElement configurationElement, String name, String defaultValue) {
        String value = configurationElement.getAttribute(name);
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new IllegalArgumentException("Missing " + name + " attribute");
    }

    public static Hashtable<String, NodeTransformerType> getTypes() {
        if (s_cachedNodeTransformerTypes != null) {
            return s_cachedNodeTransformerTypes;
        }
        s_cachedNodeTransformerTypes = new Hashtable();
        ArrayList found = new ArrayList();
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] configElements = extension.getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                IConfigurationElement configurationElement = configElements[j];
                NodeTransformerType proxy = NodeTransformerType.parseType(configurationElement, found.size());
                if (proxy != null) {
                    s_cachedNodeTransformerTypes.put(proxy.getName(), proxy);
                }
                ++j;
            }
            ++i;
        }
        return s_cachedNodeTransformerTypes;
    }

    public NodeTransformer loadNodeTransformer() throws NodeTransformerException {
        if (this._nodeTransformer != null) {
            return this._nodeTransformer;
        }
        Log log = LogFactory.getLog(NodeTransformerType.class);
        try {
            Object obj = this._configurationElement.createExecutableExtension(ATT_CLASS_NAME);
            this._nodeTransformer = (NodeTransformer)obj;
            return this._nodeTransformer;
        }
        catch (Exception exception) {
            if (log.isErrorEnabled()) {
                if (this._configurationElement != null) {
                    log.error((Object)("Failed to instantiate node transformer: " + this._configurationElement.getAttribute(ATT_CLASS_NAME) + " in uri: " + this._name + " in plugin: " + this._configurationElement.getDeclaringExtension().getNamespaceIdentifier()));
                } else {
                    log.error((Object)"Unknown!");
                }
            }
            throw new NodeTransformerException("unable to load node transformer", exception);
        }
    }

    public static NodeTransformerType parseType(IConfigurationElement configurationElement, int ordinal) {
        if (!configurationElement.getName().equals(TAG_NODE_TRANSFORMER)) {
            return null;
        }
        Log log = LogFactory.getLog(NodeTransformerType.class);
        try {
            return new NodeTransformerType(configurationElement, ordinal);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                String name = configurationElement.getAttribute(ATT_NAME);
                if (name == null) {
                    name = "[missing attribute name]";
                }
                String msg = "Failed to load StrategyType named " + name + " in " + configurationElement.getDeclaringExtension().getNamespaceIdentifier();
                log.error((Object)msg, (Throwable)e);
            }
            return null;
        }
    }

    public String getName() {
        return this._name;
    }

    public DParameterDefinition getParameterDefinition() throws NodeTransformerException {
        NodeTransformer nodeTransformer = this.loadNodeTransformer();
        InputStream inputStream = nodeTransformer.getParameterDefinition();
        try {
            Document document = XMLUtils.parse((InputStream)inputStream, (boolean)true);
            DParameterDefinition parameterDefinition = DParameterDefinitionCodec.decode((Element)document.getDocumentElement());
            return parameterDefinition;
        }
        catch (Exception exception) {
            throw new NodeTransformerException("unable to aquire parameter definition", exception);
        }
    }
}

