/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets.xmlprocessing;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.pipelets.xmlprocessing.AXmlTransformationPipelet;
import org.eclipse.smila.processing.pipelets.xmlprocessing.util.XMLUtils;
import org.eclipse.smila.processing.pipelets.xmlprocessing.util.XPathUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XPathExtractorPipelet
extends AXmlTransformationPipelet {
    public static final String PROP_XPATH = "xpath";
    public static final String PROP_SEPARATOR = "separator";
    public static final String PROP_NAMESPACE = "namespace";

    @Override
    protected void processRecord(Blackboard blackboard, ParameterAccessor paramAccessor, String id) throws Exception {
        Object result;
        String xpath = paramAccessor.getRequiredParameter(PROP_XPATH);
        String separator = paramAccessor.getParameter(PROP_SEPARATOR, "");
        String namespace = paramAccessor.getParameter(PROP_NAMESPACE, "");
        Element namespaceElement = this.createNamespaceElement(namespace);
        Document inputDocument = this.createDocument(blackboard, id, paramAccessor);
        if (inputDocument != null && (result = XPathUtils.queryForIndexField(inputDocument, xpath, namespaceElement, separator)) != null) {
            if (this.isStoreInAttribute(this.getOutputType(paramAccessor))) {
                Value value = null;
                value = result instanceof Boolean ? blackboard.getDataFactory().createBooleanValue((Boolean)result) : (result instanceof Double ? blackboard.getDataFactory().createDoubleValue((Double)result) : blackboard.getDataFactory().createStringValue(result.toString()));
                blackboard.getMetadata(id).put(this.getOutputName(paramAccessor), (Any)value);
            } else {
                this.storeResult(blackboard, id, result.toString(), paramAccessor);
            }
        }
    }

    private Element createNamespaceElement(String namespace) throws ProcessingException {
        Document doc = XMLUtils.getDocument();
        Element namespaceElement = doc.createElement("NamespaceDef");
        String[] namespaces = namespace.split(" ");
        int i = 0;
        while (i < namespaces.length) {
            if (!"".equals(namespaces[i].trim())) {
                String[] nsItems = namespaces[i].split("=");
                if (nsItems.length != 2) {
                    throw new ProcessingException("Property namespace in invalid format [Namespace;ns1=val ns2=val]");
                }
                namespaceElement.setAttribute("xmlns:" + nsItems[0], nsItems[1]);
            }
            ++i;
        }
        return namespaceElement;
    }
}

