/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.datadictionary.messages.datadictionary;

import org.eclipse.smila.search.datadictionary.DataDictionaryAccess;
import org.eclipse.smila.search.datadictionary.messages.datadictionary.DDException;
import org.eclipse.smila.search.datadictionary.messages.datadictionary.DIndex;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.ConfigurationException;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DConfigurationCodec;
import org.eclipse.smila.search.utils.indexstructure.ISException;
import org.eclipse.smila.search.utils.indexstructure.IndexStructureAccess;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DIndexCodec {
    public static DIndex decode(Element element) throws DDException {
        String forceFlush;
        DIndex dIndex = new DIndex();
        if (!element.getAttribute("Name").toString().equals("")) {
            dIndex.setName(element.getAttribute("Name"));
        }
        if (!(forceFlush = element.getAttribute("ForceFlush").toString()).equals("")) {
            dIndex.setForceFlush(Boolean.valueOf(forceFlush));
        }
        if (!element.getAttribute("RAMBufferSize").toString().equals("")) {
            dIndex.setRamBufferSize(Integer.valueOf(element.getAttribute("RAMBufferSize")));
        }
        if (!element.getAttribute("MaxBufferedDocs").toString().equals("")) {
            dIndex.setMaxBufferedDocs(Integer.valueOf(element.getAttribute("MaxBufferedDocs")));
        }
        if (!element.getAttribute("MaxBufferedDeleteTerms").toString().equals("")) {
            dIndex.setMaxBufferedDeleteTerms(Integer.valueOf(element.getAttribute("MaxBufferedDeleteTerms")));
        }
        DataDictionaryAccess dataDictionaryAccess = DataDictionaryAccess.getInstance();
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if ("Connection".equals(nl.item(i).getLocalName())) {
                dIndex.setConnection(dataDictionaryAccess.decodeConnection((Element)nl.item(i)));
            } else {
                if ("IndexStructure".equals(nl.item(i).getLocalName())) {
                    try {
                        IndexStructureAccess indexStructureAccess = IndexStructureAccess.getInstance();
                        dIndex.setIndexStructure(indexStructureAccess.decode((Element)nl.item(i)));
                    }
                    catch (ISException e) {
                        throw new DDException(e.getMessage());
                    }
                }
                if ("Configuration".equals(nl.item(i).getLocalName())) {
                    try {
                        dIndex.setConfiguration(DConfigurationCodec.decode((Element)nl.item(i)));
                    }
                    catch (ConfigurationException e) {
                        throw new DDException("unable to resolve configuration [" + e.getMessage() + "]");
                    }
                }
            }
            ++i;
        }
        return dIndex;
    }

    public static Element encode(DIndex dIndex, Element element) throws DDException {
        Document doc = element.getOwnerDocument();
        Element el = doc.createElementNS("http://www.anyfinder.de/DataDictionary", "Index");
        Attr attr = null;
        if (dIndex.getName() != null) {
            attr = doc.createAttribute("Name");
            attr.setValue(dIndex.getName());
            el.setAttributeNode(attr);
        }
        attr = doc.createAttribute("ForceFlush");
        attr.setValue(Boolean.toString(dIndex.isForceFlush()));
        el.setAttributeNode(attr);
        if (dIndex.getRamBufferSize() != null) {
            attr = doc.createAttribute("RAMBufferSize");
            attr.setValue(dIndex.getRamBufferSize().toString());
            el.setAttributeNode(attr);
        }
        if (dIndex.getMaxBufferedDocs() != null) {
            attr = doc.createAttribute("MaxBufferedDocs");
            attr.setValue(dIndex.getMaxBufferedDocs().toString());
            el.setAttributeNode(attr);
        }
        if (dIndex.getMaxBufferedDeleteTerms() != null) {
            attr = doc.createAttribute("MaxBufferedDeleteTerms");
            attr.setValue(dIndex.getMaxBufferedDeleteTerms().toString());
            el.setAttributeNode(attr);
        }
        DataDictionaryAccess dataDictionaryAccess = DataDictionaryAccess.getInstance();
        dataDictionaryAccess.encodeConnection(dIndex.getConnection(), el);
        try {
            IndexStructureAccess indexStructureAccess = IndexStructureAccess.getInstance();
            indexStructureAccess.encode(dIndex.getIndexStructure(), el);
        }
        catch (ISException e) {
            throw new DDException(e.getMessage());
        }
        try {
            DConfigurationCodec.encode(dIndex.getConfiguration(), el);
        }
        catch (ConfigurationException e) {
            throw new DDException("unable to encode configuration [" + e.getMessage() + "]");
        }
        element.appendChild(el);
        return el;
    }
}

