/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.NSContext;
import org.apache.ode.utils.XMLParserUtils;
import org.apache.ode.utils.sax.LoggingErrorHandler;
import org.apache.xerces.dom.DOMOutputImpl;
import org.apache.xml.serialize.DOMSerializerImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.ls.LSOutput;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMUtils {
    private static Log __log = LogFactory.getLog(DOMUtils.class);
    public static final String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";
    private static ThreadLocal<Transformer> __txers = new ThreadLocal();
    private static ThreadLocal<DocumentBuilder> __builders = new ThreadLocal();
    private static TransformerFactory _transformerFactory = TransformerFactory.newInstance();
    private static DocumentBuilderFactory __documentBuilderFactory;
    public static final String WSDL_NS = "http://schemas.xmlsoap.org/wsdl/";
    public static final String WSDL_ROOT_ELEMENT = "definitions";
    public static final String XSD_NS = "http://www.w3.org/2001/XMLSchema";
    public static final String XSD_ROOT_ELEMENT = "schema";

    private static void initDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = XMLParserUtils.getDocumentBuilderFactory();
        documentBuilderFactory.setNamespaceAware(true);
        __documentBuilderFactory = documentBuilderFactory;
    }

    public static String getAttribute(Element element, String string) {
        String string2 = null;
        Attr attr = element.getAttributeNode(string);
        if (attr != null) {
            string2 = attr.getValue();
        }
        return string2;
    }

    public static String prettyPrint(Element element) throws IOException {
        OutputFormat outputFormat = new OutputFormat(element.getOwnerDocument());
        outputFormat.setLineWidth(65);
        outputFormat.setIndenting(true);
        outputFormat.setIndent(2);
        StringWriter stringWriter = new StringWriter();
        XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, outputFormat);
        xMLSerializer.serialize(element);
        return stringWriter.toString();
    }

    public static String getAttributeNS(Element element, String string, String string2) {
        String string3 = null;
        Attr attr = element.getAttributeNodeNS(string, string2);
        if (attr != null) {
            string3 = attr.getValue();
        }
        return string3;
    }

    public static String getChildCharacterData(Element element) {
        if (element == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    CharacterData characterData = (CharacterData)node;
                    stringBuffer.append(characterData.getData());
                }
            }
        }
        return stringBuffer.toString();
    }

    public static Element getElementByID(Element element, String string) {
        if (element == null) {
            return null;
        }
        String string2 = element.getAttribute("id");
        if (string.equals(string2)) {
            return element;
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || (element2 = DOMUtils.getElementByID((Element)node, string)) == null) continue;
            return element2;
        }
        return null;
    }

    public static Element getFirstChildElement(Element element) {
        return (Element)DOMUtils.findChildByType(element, 1);
    }

    public static String getNamespaceURIFromPrefix(Node node, String string) {
        short s = node.getNodeType();
        Node node2 = null;
        switch (s) {
            case 2: {
                node2 = ((Attr)node).getOwnerElement();
                break;
            }
            case 1: {
                node2 = node;
                break;
            }
            default: {
                node2 = node.getParentNode();
            }
        }
        while (node2 != null && node2.getNodeType() == 1) {
            String string2;
            Element element = (Element)node2;
            String string3 = string2 = string == null ? DOMUtils.getAttribute(element, "xmlns") : DOMUtils.getAttributeNS(element, NS_URI_XMLNS, string);
            if (string2 != null) {
                return string2;
            }
            node2 = element.getParentNode();
        }
        return null;
    }

    public static Element getNextSiblingElement(Element element) {
        for (Node node = element.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    public static QName getQualifiedAttributeValue(Element element, String string) throws IllegalArgumentException {
        String string2 = DOMUtils.getAttribute(element, string);
        if (string2 != null) {
            int n = string2.indexOf(58);
            String string3 = n != -1 ? string2.substring(0, n) : null;
            String string4 = string2.substring(n + 1);
            String string5 = DOMUtils.getNamespaceURIFromPrefix(element, string3);
            if (string5 != null) {
                return new QName(string5, string4);
            }
            throw new IllegalArgumentException("Unable to determine namespace of '" + (string3 != null ? string3 + ":" : "") + string4 + "'.");
        }
        return null;
    }

    public static int countKids(Element element, short s) {
        int n = 0;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != s) continue;
            ++n;
        }
        return n;
    }

    public static Map<String, String> getParentNamespaces(Element element) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Map<String, String> map = DOMUtils.getMyNamespaces(element);
        for (Node node = element.getParentNode(); node != null && node.getNodeType() != 9; node = node.getParentNode()) {
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            NamedNodeMap namedNodeMap = element2.getAttributes();
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                if (!DOMUtils.isNSAttribute(attr)) continue;
                String string = DOMUtils.getNSPrefixFromNSAttr(attr);
                String string2 = attr.getValue();
                if (hashMap.containsKey(string) || map.containsKey(string)) continue;
                hashMap.put(string, string2);
            }
        }
        return hashMap;
    }

    public static NSContext getMyNSContext(Element element) {
        NSContext nSContext = new NSContext();
        nSContext.register(DOMUtils.getParentNamespaces(element));
        nSContext.register(DOMUtils.getMyNamespaces(element));
        return nSContext;
    }

    public static Map<String, String> getMyNamespaces(Element element) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (!DOMUtils.isNSAttribute(attr)) continue;
            hashMap.put(DOMUtils.getNSPrefixFromNSAttr(attr), attr.getValue());
        }
        return hashMap;
    }

    public static boolean isNSAttribute(Attr attr) {
        assert (attr != null);
        String string = attr.getNamespaceURI();
        return string != null && string.equals(NS_URI_XMLNS);
    }

    public static String getNSPrefixFromNSAttr(Attr attr) {
        assert (attr != null);
        assert (DOMUtils.isNSAttribute(attr));
        if (attr.getPrefix() == null) {
            return "";
        }
        return attr.getName().substring(attr.getPrefix().length() + 1);
    }

    public static String domToString(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Cannot stringify null Node!");
        }
        String string = null;
        short s = node.getNodeType();
        if (s == 1 || s == 9) {
            String string2;
            DOMSerializerImpl dOMSerializerImpl = new DOMSerializerImpl();
            dOMSerializerImpl.setParameter("namespaces", (Object)Boolean.TRUE);
            dOMSerializerImpl.setParameter("well-formed", (Object)Boolean.FALSE);
            dOMSerializerImpl.setParameter("validate", (Object)Boolean.FALSE);
            String string3 = "UTF-8";
            Document document = node.getOwnerDocument();
            if (document != null && (string2 = document.getXmlEncoding()) != null) {
                string3 = string2;
            }
            string2 = new DOMOutputImpl();
            string2.setEncoding(string3);
            StringWriter stringWriter = new StringWriter(4096);
            string2.setCharacterStream((Writer)stringWriter);
            dOMSerializerImpl.write(node, (LSOutput)((Object)string2));
            stringWriter.flush();
            string = stringWriter.toString();
        } else {
            string = node.getNodeValue();
        }
        return string;
    }

    public static void serialize(Element element, OutputStream outputStream) {
        String string;
        String string2 = "UTF-8";
        Document document = element.getOwnerDocument();
        if (document != null && (string = document.getXmlEncoding()) != null) {
            string2 = string;
        }
        string = new DOMOutputImpl();
        string.setEncoding(string2);
        DOMSerializerImpl dOMSerializerImpl = new DOMSerializerImpl();
        string.setByteStream(outputStream);
        dOMSerializerImpl.write((Node)element, (LSOutput)((Object)string));
    }

    public static String domToStringLevel2(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Cannot stringify null Node!");
        }
        String string = null;
        short s = node.getNodeType();
        if (s == 1 || s == 9) {
            DOMSerializerImpl dOMSerializerImpl = new DOMSerializerImpl();
            dOMSerializerImpl.setParameter("namespaces", (Object)Boolean.TRUE);
            dOMSerializerImpl.setParameter("well-formed", (Object)Boolean.FALSE);
            dOMSerializerImpl.setParameter("validate", (Object)Boolean.FALSE);
            DOMOutputImpl dOMOutputImpl = new DOMOutputImpl();
            dOMOutputImpl.setEncoding("UTF-8");
            StringWriter stringWriter = new StringWriter(4096);
            dOMOutputImpl.setCharacterStream((Writer)stringWriter);
            dOMSerializerImpl.write(node, (LSOutput)dOMOutputImpl);
            stringWriter.flush();
            string = stringWriter.toString();
        } else {
            string = node.getNodeValue();
        }
        return string;
    }

    public static Element findChildElementWithAttribute(Element element, String string, String string2) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !string2.equals(DOMUtils.getAttribute((Element)node, string))) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element stringToDOM(String string) throws SAXException, IOException {
        return DOMUtils.parse(new InputSource(new StringReader(string))).getDocumentElement();
    }

    public static boolean isWsdlDocument(Document document) {
        Element element = document.getDocumentElement();
        String string = element.getNamespaceURI();
        String string2 = element.getLocalName();
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(WSDL_NS) && string2.equals(WSDL_ROOT_ELEMENT);
    }

    public static boolean isXmlSchemaDocument(Document document) {
        Element element = document.getDocumentElement();
        String string = element.getNamespaceURI();
        String string2 = element.getLocalName();
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(XSD_NS) && string2.equals(XSD_ROOT_ELEMENT);
    }

    public static void pancakeNamespaces(Element element) {
        Map<String, String> map = DOMUtils.getParentNamespaces(element);
        Document document = element.getOwnerDocument();
        assert (document != null);
        for (String string : map.keySet()) {
            String string2 = map.get(string);
            Attr attr = document.createAttributeNS(NS_URI_XMLNS, string.length() != 0 ? "xmlns:" + string : "xmlns");
            attr.setValue(string2);
            element.setAttributeNodeNS(attr);
        }
    }

    public static Document newDocument() {
        DocumentBuilder documentBuilder = DOMUtils.getBuilder();
        return documentBuilder.newDocument();
    }

    public static Document parse(InputStream inputStream) throws SAXException, IOException {
        return DOMUtils.parse(new InputSource(inputStream));
    }

    public static Document parse(InputSource inputSource) throws SAXException, IOException {
        DocumentBuilder documentBuilder = DOMUtils.getBuilder();
        return documentBuilder.parse(inputSource);
    }

    public static Document sourceToDOM(Source source) throws IOException {
        try {
            Object object;
            if (source instanceof SAXSource && (((InputSource)(object = ((SAXSource)source).getInputSource())).getCharacterStream() != null || ((InputSource)object).getByteStream() != null)) {
                return DOMUtils.parse(((SAXSource)source).getInputSource());
            }
            if (source instanceof DOMSource && (object = ((DOMSource)source).getNode()) != null) {
                return DOMUtils.toDOMDocument((Node)object);
            }
            if (source instanceof StreamSource && (((StreamSource)(object = (StreamSource)source)).getReader() != null || ((StreamSource)object).getInputStream() != null)) {
                return DOMUtils.toDocumentFromStream((StreamSource)source);
            }
            object = new DOMResult(DOMUtils.newDocument());
            Transformer transformer = DOMUtils.getTransformer();
            transformer.transform(source, (Result)object);
            return (Document)((DOMResult)object).getNode();
        }
        catch (SAXException sAXException) {
            DOMUtils.throwIOException(sAXException);
        }
        catch (TransformerException transformerException) {
            DOMUtils.throwIOException(transformerException);
        }
        throw new IllegalArgumentException("Cannot parse XML source: " + source.getClass());
    }

    public static boolean isEmptyElement(Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        block4: for (int i = 0; i < n; ++i) {
            switch (nodeList.item(i).getNodeType()) {
                case 3: 
                case 4: {
                    String string = nodeList.item(i).getNodeValue();
                    if (string == null || string.trim().length() <= 0) continue block4;
                    return false;
                }
                case 1: {
                    return false;
                }
            }
        }
        return true;
    }

    public static QName getElementQName(Element element) {
        return new QName(element.getNamespaceURI(), element.getLocalName());
    }

    public static void removeChildren(Node node) {
        while (node.hasChildNodes()) {
            node.removeChild(node.getFirstChild());
        }
    }

    public static void removeAttributes(Element element, boolean bl) {
        if (!element.hasAttributes()) {
            return;
        }
        String string = element.getPrefix();
        NamedNodeMap namedNodeMap = element.getAttributes();
        Attr attr = null;
        if (bl) {
            attr = string == null ? element.getAttributeNodeNS(NS_URI_XMLNS, "xmlns") : element.getAttributeNodeNS(NS_URI_XMLNS, "xmlns:" + string);
        }
        while (namedNodeMap.getLength() != 0) {
            element.removeAttributeNode((Attr)namedNodeMap.item(0));
        }
        if (attr != null) {
            element.setAttributeNodeNS(attr);
        }
    }

    public static Element findChildByName(Element element, QName qName) {
        return DOMUtils.findChildByName(element, qName, false);
    }

    public static Element findChildByName(Element element, QName qName, boolean bl) {
        Object object;
        if (element == null) {
            throw new IllegalArgumentException("null parent");
        }
        if (qName == null) {
            throw new IllegalArgumentException("null name");
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Object object2 = object = node.getLocalName() != null ? node.getLocalName() : node.getNodeName();
            if (!new QName(node.getNamespaceURI(), (String)object).equals(qName)) continue;
            return (Element)node;
        }
        if (bl) {
            NodeList nodeList2 = element.getChildNodes();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Element element2;
                object = nodeList2.item(i);
                if (object.getNodeType() != 1 || (element2 = DOMUtils.findChildByName((Element)object, qName, bl)) == null) continue;
                return element2;
            }
        }
        return null;
    }

    public static Node findChildByType(Element element, int n) {
        if (element == null) {
            throw new NullPointerException("elem parameter must not be null!");
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != n) continue;
            return node;
        }
        return null;
    }

    public static String getTextContent(Node node) {
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            String string;
            Node node2 = node.getChildNodes().item(i);
            if (node2.getNodeType() != 3 || (string = node2.getNodeValue().trim()).length() <= 0) continue;
            return string;
        }
        return null;
    }

    public static Element getElementContent(Node node) {
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node node2 = node.getChildNodes().item(i);
            if (node2.getNodeType() != 1) continue;
            return (Element)node2;
        }
        return null;
    }

    public static void injectNamespaces(Element element, NSContext nSContext) {
        for (String string : nSContext.getUriSet()) {
            String string2 = nSContext.getPrefix(string);
            if (string2 == null || "".equals(string2)) {
                element.setAttributeNS(NS_URI_XMLNS, "xmlns", string);
                continue;
            }
            element.setAttributeNS(NS_URI_XMLNS, "xmlns:" + string2, string);
        }
    }

    public static void copyNSContext(Element element, Element element2) {
        Map<String, String> map = DOMUtils.getParentNamespaces(element);
        map.putAll(DOMUtils.getMyNamespaces(element));
        Map<String, String> map2 = DOMUtils.getParentNamespaces(element2);
        map2.putAll(DOMUtils.getMyNamespaces(element2));
        for (String object : map2.keySet()) {
            map.remove(object);
        }
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (string == null || "".equals(string)) {
                element2.setAttributeNS(NS_URI_XMLNS, "xmlns", string2);
                continue;
            }
            element2.setAttributeNS(NS_URI_XMLNS, "xmlns:" + string, string2);
        }
    }

    public static Document toDOMDocument(Node node) throws TransformerException {
        if (node instanceof Document) {
            return (Document)node;
        }
        if (node instanceof Element) {
            Element element = (Element)node;
            if (element.getOwnerDocument().getDocumentElement() == element) {
                return element.getOwnerDocument();
            }
            Document document = DOMUtils.newDocument();
            document.appendChild(document.importNode(node, true));
            return document;
        }
        throw new TransformerException("Unable to convert DOM node to a Document");
    }

    public static Document toDocumentFromStream(StreamSource streamSource) throws IOException, SAXException {
        DocumentBuilder documentBuilder = DOMUtils.getBuilder();
        Document document = null;
        Reader reader = streamSource.getReader();
        if (reader != null) {
            document = documentBuilder.parse(new InputSource(reader));
        } else {
            InputStream inputStream = streamSource.getInputStream();
            if (inputStream != null) {
                InputSource inputSource = new InputSource(inputStream);
                inputSource.setSystemId(streamSource.getSystemId());
                document = documentBuilder.parse(inputSource);
            } else {
                throw new IOException("No input stream or reader available");
            }
        }
        return document;
    }

    private static void throwIOException(Throwable throwable) throws IOException {
        IOException iOException = new IOException(throwable.getMessage());
        iOException.setStackTrace(throwable.getStackTrace());
        throw iOException;
    }

    public static Document parse(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        Document document = DOMUtils.newDocument();
        DOMUtils.parse(xMLStreamReader, document, document);
        return document;
    }

    private static void parse(XMLStreamReader xMLStreamReader, Document document, Node node) throws XMLStreamException {
        int n = xMLStreamReader.getEventType();
        while (xMLStreamReader.hasNext()) {
            switch (n) {
                case 1: {
                    String string;
                    String string2;
                    int n2;
                    Element element = document.createElementNS(xMLStreamReader.getNamespaceURI(), xMLStreamReader.getLocalName());
                    if (xMLStreamReader.getPrefix() != null && xMLStreamReader.getPrefix() != "") {
                        element.setPrefix(xMLStreamReader.getPrefix());
                    }
                    node.appendChild(element);
                    for (n2 = 0; n2 < xMLStreamReader.getNamespaceCount(); ++n2) {
                        string2 = xMLStreamReader.getNamespaceURI(n2);
                        string = xMLStreamReader.getNamespacePrefix(n2);
                        DOMUtils.declare(element, string2, string);
                    }
                    for (n2 = 0; n2 < xMLStreamReader.getAttributeCount(); ++n2) {
                        string2 = xMLStreamReader.getAttributeLocalName(n2);
                        string = xMLStreamReader.getAttributePrefix(n2);
                        if (string != null && string.length() > 0) {
                            string2 = string + ":" + string2;
                        }
                        Attr attr = document.createAttributeNS(xMLStreamReader.getAttributeNamespace(n2), string2);
                        attr.setValue(xMLStreamReader.getAttributeValue(n2));
                        element.setAttributeNode(attr);
                    }
                    if (xMLStreamReader.hasNext()) {
                        xMLStreamReader.next();
                        DOMUtils.parse(xMLStreamReader, document, element);
                    }
                    if (!(node instanceof Document)) break;
                    while (xMLStreamReader.hasNext()) {
                        xMLStreamReader.next();
                    }
                    return;
                }
                case 2: {
                    return;
                }
                case 4: {
                    if (node == null) break;
                    node.appendChild(document.createTextNode(xMLStreamReader.getText()));
                    break;
                }
                case 5: {
                    if (node == null) break;
                    node.appendChild(document.createComment(xMLStreamReader.getText()));
                    break;
                }
                case 12: {
                    node.appendChild(document.createCDATASection(xMLStreamReader.getText()));
                    break;
                }
                case 3: {
                    node.appendChild(document.createProcessingInstruction(xMLStreamReader.getPITarget(), xMLStreamReader.getPIData()));
                    break;
                }
                case 9: {
                    node.appendChild(document.createProcessingInstruction(xMLStreamReader.getPITarget(), xMLStreamReader.getPIData()));
                    break;
                }
                case 10: 
                case 13: {
                    break;
                }
            }
            if (!xMLStreamReader.hasNext()) continue;
            n = xMLStreamReader.next();
        }
    }

    private static void declare(Element element, String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            element.setAttributeNS(NS_URI_XMLNS, "xmlns:" + string2, string);
        } else if (string != null) {
            element.setAttributeNS(NS_URI_XMLNS, "xmlns", string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Transformer getTransformer() {
        Transformer transformer = __txers.get();
        if (transformer == null) {
            TransformerFactory transformerFactory = _transformerFactory;
            synchronized (transformerFactory) {
                try {
                    transformer = _transformerFactory.newTransformer();
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    String string = "Transformer configuration error!";
                    __log.fatal((Object)string, (Throwable)transformerConfigurationException);
                    throw new Error(string, transformerConfigurationException);
                }
            }
            __txers.set(transformer);
        }
        return transformer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DocumentBuilder getBuilder() {
        DocumentBuilder documentBuilder = __builders.get();
        if (documentBuilder == null) {
            DocumentBuilderFactory documentBuilderFactory = __documentBuilderFactory;
            synchronized (documentBuilderFactory) {
                try {
                    documentBuilder = __documentBuilderFactory.newDocumentBuilder();
                    documentBuilder.setErrorHandler(new LoggingErrorHandler());
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    __log.error((Object)parserConfigurationException);
                    throw new RuntimeException(parserConfigurationException);
                }
            }
            __builders.set(documentBuilder);
        }
        return documentBuilder;
    }

    public static List<Node> toList(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof List) {
            return (List)object;
        }
        NodeList nodeList = (NodeList)object;
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            linkedList.add(nodeList.item(i));
        }
        return linkedList;
    }

    public static List<Element> findChildrenByName(Element element, QName qName) {
        if (element == null) {
            throw new IllegalArgumentException("null parent");
        }
        if (qName == null) {
            throw new IllegalArgumentException("null name");
        }
        LinkedList<Element> linkedList = new LinkedList<Element>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            String string2 = string = node.getLocalName() != null ? node.getLocalName() : node.getNodeName();
            if (!new QName(node.getNamespaceURI(), string).equals(qName)) continue;
            linkedList.add((Element)node);
        }
        return linkedList;
    }

    public static QName getNodeQName(String string) {
        int n = string.indexOf(":");
        if (n >= 0) {
            return new QName(string.substring(0, n), string.substring(n + 1));
        }
        return new QName(string);
    }

    public static Document getDocument(Node node) {
        return node == null ? DOMUtils.newDocument() : node.getOwnerDocument();
    }

    public static String getQualifiedName(QName qName) {
        String string = qName.getPrefix();
        String string2 = qName.getLocalPart();
        return string == null || "".equals(string) ? string2 : string + ":" + string2;
    }

    public static Node cloneNode(Document document, Node node) {
        Node node2 = null;
        String string = node.getNamespaceURI();
        String string2 = node.getLocalName();
        switch (node.getNodeType()) {
            case 2: {
                if (string == null) {
                    node2 = document.createAttribute(string2);
                    break;
                }
                node2 = document.createAttributeNS(string, string2);
                break;
            }
            case 4: {
                node2 = document.createCDATASection(((CDATASection)node).getData());
                break;
            }
            case 8: {
                node2 = document.createComment(((Comment)node).getData());
                break;
            }
            case 11: {
                node2 = document.createDocumentFragment();
                break;
            }
            case 9: {
                node2 = document;
                break;
            }
            case 1: {
                if (string == null) {
                    node2 = document.createElement(string2);
                    break;
                }
                node2 = document.createElementNS(string, string2);
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                node2 = document.createEntityReference(string2);
                break;
            }
            case 12: {
                break;
            }
            case 7: {
                node2 = document.createProcessingInstruction(((ProcessingInstruction)node).getData(), string2);
                break;
            }
            case 3: {
                node2 = document.createTextNode(((Text)node).getData());
                break;
            }
        }
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                node2.appendChild(DOMUtils.cloneNode(document, nodeList.item(i)));
            }
        }
        return node2;
    }

    static {
        DOMUtils.initDocumentBuilderFactory();
    }
}

