/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.highlighting.transformer;

import java.util.ArrayList;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.search.highlighting.transformer.HighlightingTransformer;
import org.eclipse.smila.search.highlighting.transformer.HighlightingTransformerException;
import org.eclipse.smila.search.utils.param.ParameterException;
import org.eclipse.smila.search.utils.param.ParameterSet;
import org.eclipse.smila.search.utils.param.set.DParameterSet;

public class MaxTextLength
extends HighlightingTransformer {
    @Override
    public AnyMap transform(AnyMap highlight, DParameterSet highlightConfig) throws HighlightingTransformerException, ParameterException {
        ParameterSet parameterSet = this.createParameterSet(highlightConfig);
        String markupPrefix = parameterSet.getStringParameter("MarkupPrefix");
        String markupSuffix = parameterSet.getStringParameter("MarkupSuffix");
        int maxLength = parameterSet.getIntegerParameter("MaxLength");
        StringBuilder buffer = new StringBuilder();
        int pos = 0;
        String originalText = highlight.getStringValue("text");
        AnySeq highlightPositions = highlight.getSeq("positions");
        for (Any element : highlightPositions) {
            if (!element.isMap()) continue;
            AnyMap highlightPos = (AnyMap)element;
            int start = highlightPos.getLongValue("start").intValue();
            int end = highlightPos.getLongValue("end").intValue();
            if (start > maxLength) {
                buffer.append(originalText.substring(pos, maxLength));
                pos = maxLength;
                break;
            }
            buffer.append(originalText.substring(pos, start));
            if (end > maxLength) {
                pos = maxLength;
                break;
            }
            buffer.append(markupPrefix);
            buffer.append(originalText.substring(start, end));
            buffer.append(markupSuffix);
            pos = end;
        }
        if (pos < maxLength) {
            if (originalText.length() < maxLength) {
                buffer.append(originalText.substring(pos));
            } else {
                buffer.append(originalText.substring(pos, maxLength));
            }
        }
        AnyMap transformedHighlight = highlight.getFactory().createAnyMap();
        transformedHighlight.put("text", buffer.toString());
        return transformedHighlight;
    }

    @Override
    public ArrayList<Object> transform(ArrayList<Object> data, ParameterSet parameterSet) throws HighlightingTransformerException {
        return data;
    }
}

