/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.utils.search;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.smila.search.utils.search.DDateField;
import org.eclipse.smila.search.utils.search.DDateFieldCodec;
import org.eclipse.smila.search.utils.search.DField;
import org.eclipse.smila.search.utils.search.DNumberField;
import org.eclipse.smila.search.utils.search.DNumberFieldCodec;
import org.eclipse.smila.search.utils.search.DSearchException;
import org.eclipse.smila.search.utils.search.DTextField;
import org.eclipse.smila.search.utils.search.DTextFieldCodec;
import org.eclipse.smila.search.utils.search.IParameter;
import org.eclipse.smila.search.utils.search.SearchAccess;
import org.eclipse.smila.search.utils.search.parameterobjects.DNodeTransformerCodec;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DFieldCodec {
    public static final String NS = "http://www.anyfinder.de/Search";

    public static DField decode(Element element) throws DSearchException {
        String type = element.getAttribute("xsi:type");
        if (type.indexOf(":") != -1) {
            String[] tokens = type.split(":");
            type = tokens[tokens.length - 1];
        }
        if (type.equals("FTText")) {
            return DTextFieldCodec.decode(element);
        }
        if (type.equals("FTDate")) {
            return DDateFieldCodec.decode(element);
        }
        return DNumberFieldCodec.decode(element);
    }

    public static void decodeStandardValues(DField dField, Element element) throws DSearchException {
        dField.setFieldNo(Integer.parseInt(element.getAttribute("FieldNo")));
        String type = element.getAttribute("xsi:type");
        if (type.indexOf(":") != -1) {
            String[] tokens = type.split(":");
            type = tokens[tokens.length - 1];
        }
        dField.setType(type);
        if (element.hasAttribute("Weight")) {
            try {
                dField.setWeight(new Integer(element.getAttribute("Weight")));
            }
            catch (NumberFormatException numberFormatException) {
                throw new DSearchException("Unable to parse Weight value: '" + element.getAttribute("Weight") + "' is out of range or not a valid number");
            }
        }
        if (element.hasAttribute("ParameterDescriptor")) {
            dField.setParameterDescriptor(element.getAttribute("ParameterDescriptor"));
        }
        if (element.hasAttribute("FieldTemplate")) {
            dField.setFieldTemplate(element.getAttribute("FieldTemplate"));
        }
        if (element.hasAttribute("Constraint")) {
            dField.setConstraint(element.getAttribute("Constraint"));
        }
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if ("NodeTransformer".equals(nl.item(i).getLocalName())) {
                dField.setNodeTransformer(DNodeTransformerCodec.decode((Element)nl.item(i)));
            }
            ++i;
        }
    }

    public static Element encode(DField dField, Element element) throws DSearchException {
        if (dField instanceof DTextField) {
            return DTextFieldCodec.encode((DTextField)dField, element);
        }
        if (dField instanceof DNumberField) {
            return DNumberFieldCodec.encode((DNumberField)dField, element);
        }
        return DDateFieldCodec.encode((DDateField)dField, element);
    }

    public static void encodeStandardValues(DField dField, Element element) throws DSearchException {
        element.setAttribute("FieldNo", String.valueOf(dField.getFieldNo()));
        if (dField.getWeight() != null) {
            element.setAttribute("Weight", "" + dField.getWeight());
        }
        if (dField.getParameterDescriptor() != null) {
            element.setAttribute("ParameterDescriptor", dField.getParameterDescriptor());
        }
        if (dField.getFieldTemplate() != null) {
            element.setAttribute("FieldTemplate", dField.getFieldTemplate());
        }
        if (dField.getConstraint() != null) {
            element.setAttribute("Constraint", dField.getConstraint());
        }
        if (dField.getNodeTransformer() != null) {
            DNodeTransformerCodec.encode(dField.getNodeTransformer(), element);
        }
    }

    public static IParameter getParameter(Element element) throws DSearchException {
        String codecClass;
        if (!element.getNamespaceURI().equals(NS) && element.getLocalName().equals("Parameter") && (codecClass = element.getAttribute("CodecClass")) != null && !codecClass.trim().equals("")) {
            Class decoder = null;
            try {
                SearchAccess searchAccess = SearchAccess.getInstance();
                decoder = searchAccess.getCodecClass(codecClass);
            }
            catch (ClassNotFoundException e) {
                throw new DSearchException("unable to locate decoder class", e);
            }
            Method m = null;
            try {
                m = decoder.getMethod("decode", Element.class);
            }
            catch (NoSuchMethodException e) {
                throw new DSearchException("unable to locate decoder method", e);
            }
            try {
                return (IParameter)m.invoke(null, element);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() != null) {
                    throw new DSearchException("unable to invoke decoder method", e.getCause());
                }
                throw new DSearchException("unable to invoke decoder method", e);
            }
            catch (IllegalAccessException e) {
                throw new DSearchException("unable to invoke decoder method", e);
            }
        }
        return null;
    }
}

