/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.utils.search;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.smila.search.utils.search.DField;
import org.eclipse.smila.search.utils.search.DQueryCodec;
import org.eclipse.smila.utils.xml.XMLUtils;
import org.w3c.dom.Element;

public class DQuery
implements Cloneable {
    private Vector _fields = new Vector();
    private int _maxHits;
    private int _minSimilarity;
    private String _indexName;
    private boolean _showHitDistribution = true;
    private String _templateSelectorName;
    private Integer _startHits;
    private Collection<Integer> _resultFields;
    private Collection<Integer> _highlightFields;

    public void addField(DField dField) {
        this._fields.addElement(dField);
    }

    public Object clone() {
        DQuery query = null;
        try {
            query = (DQuery)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("unable to clone query");
        }
        if (this._startHits != null) {
            query._startHits = new Integer(this._startHits);
        }
        query._fields = new Vector();
        Enumeration enm = this.getFields();
        while (enm.hasMoreElements()) {
            DField field = (DField)enm.nextElement();
            query.addField((DField)field.clone());
        }
        query.setHighlightFields(this._highlightFields);
        return query;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }

    public Enumeration getFields() {
        return this._fields.elements();
    }

    public int getFieldsCount() {
        return this._fields.size();
    }

    public String getIndexName() {
        return this._indexName;
    }

    public int getMaxHits() {
        return this._maxHits;
    }

    public int getMinSimilarity() {
        return this._minSimilarity;
    }

    public boolean getShowHitDistribution() {
        return this._showHitDistribution;
    }

    public Integer getStartHits() {
        return this._startHits;
    }

    public String getTemplateSelectorName() {
        return this._templateSelectorName;
    }

    public void removeField(DField dField) {
        this._fields.removeElement(dField);
    }

    public void setIndexName(String value) {
        this._indexName = value;
    }

    public void setMaxHits(int value) {
        this._maxHits = value;
    }

    public void setMinSimilarity(int minSimilarity) {
        this._minSimilarity = minSimilarity;
    }

    public void setShowHitDistribution(boolean showHitDistribution) {
        this._showHitDistribution = showHitDistribution;
    }

    public void setStartHits(Integer value) {
        this._startHits = value;
    }

    public void setTemplateSelectorName(String templateSelectorName) {
        this._templateSelectorName = templateSelectorName;
    }

    public void setResultFields(Collection<Integer> resultFields) {
        this._resultFields = resultFields;
    }

    public Collection<Integer> getResultFields() {
        return this._resultFields;
    }

    public void setHighlightFields(Collection<Integer> highlightFields) {
        this._highlightFields = highlightFields;
    }

    public Collection<Integer> getHighlightFields() {
        return this._highlightFields;
    }

    public String toString() {
        try {
            Element el = DQueryCodec.encode(this, XMLUtils.getDocument().createElement("Dummy"));
            el.getOwnerDocument().appendChild(el);
            String s = new String(XMLUtils.stream((Element)el, (boolean)false));
            return s;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

