/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.impl.BinaryRequestWriter;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.core.CoreContainer;
import org.eclipse.smila.solr.SolrProperties;
import org.eclipse.smila.solr.admin.SolrAdmin;
import org.eclipse.smila.solr.admin.SolrEmbeddedAdmin;
import org.eclipse.smila.solr.admin.SolrHttpAdmin;
import org.eclipse.smila.solr.util.SolrHelper;
import org.eclipse.smila.solr.util.SolrUtils;

public class SolrServerManager {
    private final SolrProperties _properties;
    private final Log _log;
    private final Map<String, SolrServer> _servers;
    private CoreContainer _container;
    private SolrAdmin _admin;
    private SolrHelper _helper;

    public SolrServerManager() {
        this(new SolrProperties());
    }

    public SolrServerManager(SolrProperties properties) {
        block4: {
            this._properties = new SolrProperties();
            this._log = LogFactory.getLog(SolrServerManager.class);
            this._servers = Collections.synchronizedMap(new HashMap());
            try {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)"Start SolrManager instance...");
                }
                this._helper = new SolrHelper(properties);
                if (this._properties.isEmbedded().booleanValue()) {
                    this.loadCoreContainer();
                    this._admin = new SolrEmbeddedAdmin(this._helper, this._container);
                    return;
                }
                this._admin = new SolrHttpAdmin(this._helper);
            }
            catch (Exception exception) {
                if (!this._log.isErrorEnabled()) break block4;
                this._log.error((Object)"Error while initialize SolrManager", (Throwable)exception);
            }
        }
    }

    private void loadCoreContainer() throws Exception {
        try {
            File solr = this._helper.getSolrXML();
            this._container = new CoreContainer();
            this._container.load(this._helper.getSolrHome().getAbsolutePath(), solr);
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)"Solr CoreContainer for EmbeddedSolrServer loaded successfully.");
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Available solr cores: " + StringUtils.join((Collection)this._container.getCoreNames(), (String)File.pathSeparator)));
            }
        }
        catch (Exception exception) {
            throw new Exception("Error while load CoreContainer", exception);
        }
    }

    public SolrProperties getSolrProperties() {
        return this._properties;
    }

    public SolrAdmin getSolrAdmin() {
        return this._admin;
    }

    public SolrHelper getSolrHelper() {
        return this._helper;
    }

    public CoreContainer getCoreContainer() {
        return this._container;
    }

    public SolrServer getSolrServer(String coreName) throws SolrServerException, IOException {
        if (this._properties.isEmbedded().booleanValue()) {
            return this.getEmbeddedSolrServer(coreName);
        }
        return this.getHttpSolrServer(coreName);
    }

    private SolrServer getEmbeddedSolrServer(String coreName) throws SolrServerException {
        SolrServer server = this._servers.get(coreName);
        if (server == null) {
            if (!this._container.getCoreNames().contains(coreName)) {
                throw new SolrServerException("No configuration found in solr.home '" + this._container.getSolrHome() + "' for core with name: " + coreName);
            }
            server = new EmbeddedSolrServer(this._container, coreName);
            this._servers.put(coreName, server);
        }
        return server;
    }

    private SolrServer getHttpSolrServer(String coreName) throws SolrServerException, IOException {
        SolrServer server = this._servers.get(coreName);
        if (server == null) {
            String url = this._properties.getServerUrl();
            server = this.getHttpSolrServer(url, coreName);
            this._servers.put(coreName, server);
        }
        return server;
    }

    private SolrServer getHttpSolrServer(String url, String coreName) throws SolrServerException, IOException {
        if (coreName != null) {
            url = String.valueOf(url) + "/" + coreName;
        }
        CommonsHttpSolrServer server = new CommonsHttpSolrServer(url);
        server.setRequestWriter((RequestWriter)new BinaryRequestWriter());
        SolrPingResponse ping = server.ping();
        if (SolrUtils.responseStatusIsError((SolrResponseBase)ping)) {
            String msg = MessageFormat.format("Cannot ping given server for URL: {0}. Response is: {1} {2}", ping.getRequestUrl(), ping.getStatus(), ping.toString());
            throw new SolrServerException(msg);
        }
        return server;
    }
}

