/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.httphandler;

import java.util.List;
import org.eclipse.smila.connectivity.framework.AgentController;
import org.eclipse.smila.connectivity.framework.AgentState;
import org.eclipse.smila.connectivity.framework.httphandler.BaseConnectivityHandler;
import org.eclipse.smila.connectivity.framework.httphandler.ImportNotFoundException;
import org.eclipse.smila.connectivity.framework.performancecounters.AgentPerformanceCounterHelper;
import org.eclipse.smila.connectivity.framework.performancecounters.ConnectivityPerformanceAgent;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;

public class AgentHandler
extends BaseConnectivityHandler {
    public static final String KEY_JOB_NAME = "jobName";
    public static final String KEY_IMPORT_RUN_ID = "importRunId";
    public static final String KEY_DATA_SOURCE_ID = "dataSourceId";
    private AgentController _agentController;

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        if ("GET".equals(method)) {
            String dataSourceId = this.getDataSourceId(requestUri);
            AgentPerformanceCounterHelper<? extends ConnectivityPerformanceAgent> counterHelper = this._agentController.getPerformanceCounterHelper(dataSourceId);
            if (counterHelper == null) {
                throw new ImportNotFoundException("No statistics found for data source id '" + dataSourceId + "'");
            }
            Object instanceAgent = counterHelper.getInstanceAgent();
            AnyMap result = this.createStatistic((ConnectivityPerformanceAgent)instanceAgent, dataSourceId);
            return result;
        }
        if ("POST".equals(method)) {
            if (inputRecord == null) {
                throw new IllegalArgumentException("No attribute 'jobName' provided.");
            }
            String jobName = inputRecord.getMetadata().getStringValue(KEY_JOB_NAME);
            List uriParts = this.getDynamicUriParts(requestUri);
            String dataSourceId = (String)uriParts.get(0);
            int runId = this._agentController.startAgent(dataSourceId, jobName);
            AnyMap result = DataFactory.DEFAULT.createAnyMap();
            result.put(KEY_IMPORT_RUN_ID, (Number)runId);
            return result;
        }
        return null;
    }

    @Override
    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof IllegalArgumentException) {
            return 400;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method) || "POST".equals(method);
    }

    private String getDataSourceId(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            return (String)uriParts.get(0);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'.");
    }

    private AnyMap createStatistic(ConnectivityPerformanceAgent crawlerCounters, String dataSourceId) {
        AnyMap result = null;
        result = crawlerCounters != null ? crawlerCounters.toAny() : DataFactory.DEFAULT.createAnyMap();
        result.put(KEY_DATA_SOURCE_ID, dataSourceId);
        AgentState state = this._agentController.getAgentTasksState().get(dataSourceId);
        String stateString = state != null ? state.getState().name() : "Undefined";
        result.put("state", stateString);
        return result;
    }

    protected void setAgentController(AgentController agentController) {
        this._agentController = agentController;
    }

    protected void unsetAgentController(AgentController agentController) {
        if (this._agentController == agentController) {
            this._agentController = null;
        }
    }
}

