/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ipc.bon;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.eclipse.smila.ipc.IpcStreamWriter;
import org.eclipse.smila.ipc.bon.BinaryToken;
import org.eclipse.smila.ipc.bon.ValueTrafo;

public class BinaryStreamWriter
implements IpcStreamWriter {
    private final OutputStream _stream;

    BinaryStreamWriter(OutputStream stream) {
        this._stream = stream;
    }

    @Override
    public void close() throws IOException {
        if (this._stream != null) {
            this._stream.close();
        }
    }

    @Override
    public void closeWithoutStream() throws IOException {
    }

    @Override
    public void writeObjectEnd() throws IOException {
        this._stream.write(BinaryToken.OBJECT_END.byteValue());
    }

    @Override
    public void writeObjectStart() throws IOException {
        this._stream.write(BinaryToken.OBJECT_START.byteValue());
    }

    @Override
    public void writeMappingEnd() throws IOException {
        this._stream.write(BinaryToken.MAPPING_END.byteValue());
    }

    @Override
    public void writeMappingStart() throws IOException {
        this._stream.write(BinaryToken.MAPPING_START.byteValue());
    }

    @Override
    public void writeScalarBoolean(boolean b) throws IOException {
        if (b) {
            this._stream.write(BinaryToken.SCALAR_BOOL_TRUE.byteValue());
        } else {
            this._stream.write(BinaryToken.SCALAR_BOOL_FALSE.byteValue());
        }
    }

    @Override
    public void writeScalarDouble(double d) throws IOException {
        this._stream.write(BinaryToken.SCALAR_DOUBLE.byteValue());
        this._stream.write(ValueTrafo.double2byte(d));
    }

    @Override
    public void writeScalarInt(int i) throws IOException {
        this.writeScalarLong(i);
    }

    @Override
    public void writeScalarLong(long i) throws IOException {
        boolean neg = false;
        if (i < 0L) {
            neg = true;
            i = -i;
        }
        int byteLength = ValueTrafo.getBytesLength(i);
        byte[] b = ValueTrafo.long2byte(i, byteLength);
        switch (byteLength) {
            case 1: {
                this._stream.write(neg ? BinaryToken.SCALAR_INT_1_N.byteValue() : BinaryToken.SCALAR_INT_1.byteValue());
                break;
            }
            case 2: {
                this._stream.write(neg ? BinaryToken.SCALAR_INT_2_N.byteValue() : BinaryToken.SCALAR_INT_2.byteValue());
                break;
            }
            case 3: {
                this._stream.write(neg ? BinaryToken.SCALAR_INT_3_N.byteValue() : BinaryToken.SCALAR_INT_3.byteValue());
                break;
            }
            case 4: {
                this._stream.write(neg ? BinaryToken.SCALAR_INT_4_N.byteValue() : BinaryToken.SCALAR_INT_4.byteValue());
                break;
            }
            case 5: {
                this._stream.write(neg ? BinaryToken.SCALAR_INT_5_N.byteValue() : BinaryToken.SCALAR_INT_5.byteValue());
                break;
            }
            case 6: {
                this._stream.write(neg ? BinaryToken.SCALAR_INT_6_N.byteValue() : BinaryToken.SCALAR_INT_6.byteValue());
                break;
            }
            case 7: {
                this._stream.write(neg ? BinaryToken.SCALAR_INT_7_N.byteValue() : BinaryToken.SCALAR_INT_7.byteValue());
                break;
            }
            case 8: {
                this._stream.write(neg ? BinaryToken.SCALAR_INT_8_N.byteValue() : BinaryToken.SCALAR_INT_8.byteValue());
                break;
            }
            default: {
                throw new IllegalStateException("invalid byte size");
            }
        }
        this._stream.write(b);
    }

    @Override
    public void writeScalarString(String s) throws IOException {
        byte[] b = ValueTrafo.string2byte(s);
        byte[] bLength = ValueTrafo.long2byte(b.length);
        ByteBuffer bb = ByteBuffer.allocate(1 + bLength.length + b.length);
        if (bLength.length > 4) {
            throw new IllegalArgumentException("string too long, byte length: " + bLength.length);
        }
        if (bLength.length == 1) {
            bb.put(BinaryToken.SCALAR_STRING_1.byteValue());
        } else if (bLength.length == 2) {
            bb.put(BinaryToken.SCALAR_STRING_2.byteValue());
        } else if (bLength.length == 3) {
            bb.put(BinaryToken.SCALAR_STRING_3.byteValue());
        } else if (bLength.length == 4) {
            bb.put(BinaryToken.SCALAR_STRING_4.byteValue());
        }
        bb.put(bLength);
        bb.put(b);
        this._stream.write(bb.array());
    }

    @Override
    public void writeSequenceEnd() throws IOException {
        this._stream.write(BinaryToken.SEQUENCE_END.byteValue());
    }

    @Override
    public void writeSequenceStart() throws IOException {
        this._stream.write(BinaryToken.SEQUENCE_START.byteValue());
    }

    @Override
    public void writeMappingKey(String s) throws IOException {
        this.writeScalarString(s);
    }
}

