/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.common.mimetype.impl;

import java.io.IOException;
import org.eclipse.smila.common.mimetype.MimeTypeIdentifier;
import org.eclipse.smila.common.mimetype.MimeTypeParseException;
import org.eclipse.smila.common.mimetype.impl.MimeTypeMapper;

public class SimpleMimeTypeIdentifier
implements MimeTypeIdentifier {
    private MimeTypeMapper _mimeTypeMapper;

    public String identify(byte[] data) throws MimeTypeParseException {
        return this.identify(data, null);
    }

    public String identify(String extension) throws MimeTypeParseException {
        return this.identify(null, extension);
    }

    public String identify(byte[] data, String extension) throws MimeTypeParseException {
        if (this._mimeTypeMapper == null) {
            try {
                this._mimeTypeMapper = new MimeTypeMapper();
            }
            catch (IOException exception) {
                throw new MimeTypeParseException("unable to load mime type mappings", (Throwable)exception);
            }
        }
        try {
            if (extension == null) {
                throw new MimeTypeParseException("Could not detect mimetype because no extension is specified");
            }
            String mimetype = this._mimeTypeMapper.getContentType(extension);
            if (mimetype == null) {
                throw new MimeTypeParseException("Could not detect mimetype");
            }
            return mimetype;
        }
        catch (MimeTypeParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MimeTypeParseException("Could not detect mimetype", (Throwable)e);
        }
    }
}

