/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.server.json;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.HttpHandler;
import org.eclipse.smila.http.server.json.JsonHttpUtils;
import org.eclipse.smila.http.server.util.UnsupportedMethodException;

public abstract class JsonHttpHandler
implements HttpHandler {
    private final Log _log = LogFactory.getLog(this.getClass());

    public abstract Object process(Record var1) throws Exception;

    @Override
    public void handle(HttpExchange exchange) {
        boolean closeConnection = false;
        Object result = null;
        String method = exchange.getRequestMethod();
        String requestUri = exchange.getRequestURI();
        Record inputRecord = null;
        try {
            if (!this.isValidMethod(method, requestUri)) {
                throw new UnsupportedMethodException("Unsupported http method '" + method + "'");
            }
            inputRecord = JsonHttpUtils.convertRequest(exchange);
            result = this.process(inputRecord);
        }
        catch (Throwable error) {
            this._log.error((Object)("Error processing " + method + " " + exchange.getRequestURI()), error);
            closeConnection = this.writeErrorResult(exchange, error, inputRecord);
            try {
                if (closeConnection) {
                    IOUtils.closeQuietly((OutputStream)exchange.getResponseStream());
                } else {
                    exchange.getResponseStream().flush();
                }
            }
            catch (Exception exception) {}
            return;
        }
        try {
            try {
                closeConnection = this.writeSuccessResult(exchange, result, inputRecord);
            }
            catch (IOException ex) {
                this._log.error((Object)"Error writing the response. Maybe client has closed the connection.", (Throwable)ex);
                closeConnection = true;
                try {
                    if (closeConnection) {
                        IOUtils.closeQuietly((OutputStream)exchange.getResponseStream());
                    }
                    exchange.getResponseStream().flush();
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable throwable) {
            try {
                if (closeConnection) {
                    IOUtils.closeQuietly((OutputStream)exchange.getResponseStream());
                } else {
                    exchange.getResponseStream().flush();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (closeConnection) {
                IOUtils.closeQuietly((OutputStream)exchange.getResponseStream());
            } else {
                exchange.getResponseStream().flush();
            }
        }
        catch (Exception exception) {}
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "POST".equals(method);
    }

    protected boolean writeSuccessResult(HttpExchange exchange, Object resultObject, Record inputRecord) throws IOException {
        int statusCode = this.getSuccessStatus(exchange.getRequestMethod(), exchange.getRequestURI(), inputRecord, resultObject);
        boolean closeConnection = JsonHttpUtils.prepareResponseHeader(exchange, statusCode, resultObject != null);
        this.writeResultObject(exchange.getResponseStream(), resultObject);
        return closeConnection;
    }

    protected int getSuccessStatus(String method, String requestUri) {
        return 200;
    }

    protected int getSuccessStatus(String requestMethod, String requestUri, Record inputRecord, Object resultObject) {
        return this.getSuccessStatus(requestMethod, requestUri);
    }

    protected void writeResultObject(OutputStream responseStream, Object resultObject) throws IOException {
        JsonHttpUtils.writeResultObject(responseStream, resultObject);
    }

    protected boolean writeErrorResult(HttpExchange exchange, Throwable error, Record inputRecord) throws IOException {
        int errorCode = this.getErrorStatus(exchange.getRequestMethod(), exchange.getRequestMethod(), error);
        boolean writeErrorDetails = !"HEAD".equals(exchange.getRequestMethod());
        boolean closeConnection = JsonHttpUtils.prepareResponseHeader(exchange, errorCode, writeErrorDetails);
        if (writeErrorDetails) {
            JsonHttpUtils.writeErrorDetails(exchange, error);
        }
        return closeConnection;
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        return JsonHttpUtils.getErrorStatus(ex);
    }
}

