/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.util.ResultCollector;

public class CommitRecordsPipelet
implements Pipelet {
    private final Log _log = LogFactory.getLog(this.getClass());

    public void configure(AnyMap configuration) throws ProcessingException {
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        ParameterAccessor paramAccessor = new ParameterAccessor(blackboard);
        ResultCollector resultCollector = new ResultCollector(paramAccessor, this._log, false);
        if (recordIds != null) {
            String[] stringArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (id != null) {
                    try {
                        blackboard.commitRecord(id);
                        resultCollector.addResult(id);
                    }
                    catch (BlackboardAccessException ex) {
                        this._log.error((Object)("Error committing record " + id), (Throwable)ex);
                        resultCollector.addFailedResult(id, (Exception)((Object)ex));
                    }
                }
                ++n2;
            }
        }
        return resultCollector.getResultIds();
    }
}

