/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.util.ResultCollector;

public class SubAttributeExtractorPipelet
implements Pipelet {
    public static final String PROPPERTY_INPUT_PATH = "inputPath";
    public static final String PROPPERTY_OUTPUT_PATH = "outputPath";
    public static final String PROPPERTY_MODE = "mode";
    public static final String PROPPERTY_SEPARATOR = "separator";
    public static final String DEFAULT_SEPARATOR = " ";
    public static final String DEFAULT_PATH_SEPARATOR = "/";
    private final Log _log = LogFactory.getLog(this.getClass());
    private AnyMap _configuration;

    public void configure(AnyMap configuration) throws ProcessingException {
        this._configuration = configuration;
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        ParameterAccessor paramAccessor = new ParameterAccessor(blackboard, this._configuration);
        ResultCollector resultCollector = new ResultCollector(paramAccessor, this._log, false);
        if (recordIds != null) {
            String[] stringArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                try {
                    paramAccessor.setCurrentRecord(id);
                    String inputPath = paramAccessor.getRequiredParameter(PROPPERTY_INPUT_PATH);
                    String[] inputPathNames = inputPath.split(DEFAULT_PATH_SEPARATOR);
                    String outputPath = paramAccessor.getRequiredParameter(PROPPERTY_OUTPUT_PATH);
                    Mode mode = Mode.valueOf(paramAccessor.getRequiredParameter(PROPPERTY_MODE));
                    String separator = paramAccessor.getParameter(PROPPERTY_SEPARATOR, DEFAULT_SEPARATOR);
                    AnyMap metadata = blackboard.getMetadata(id);
                    Any any = this.getValues(metadata, inputPathNames);
                    if (any != null) {
                        this.setValues(metadata, id, any, mode, outputPath, separator);
                    }
                    resultCollector.addResult(id);
                }
                catch (Exception e) {
                    resultCollector.addFailedResult(id, e);
                }
                ++n2;
            }
        }
        return resultCollector.getResultIds();
    }

    private Any getValues(AnyMap metadata, String[] inputPathNames) {
        AnyMap current = metadata;
        int lastIndex = inputPathNames.length - 1;
        int i = 0;
        while (i < lastIndex) {
            Any element = (Any)current.get((Object)inputPathNames[i]);
            if (element != null && element.isSeq() && !element.isEmpty()) {
                element = (Any)((AnySeq)element).get(0);
            }
            if (element == null || !element.isMap()) {
                return null;
            }
            current = (AnyMap)element;
            ++i;
        }
        return (Any)current.get((Object)inputPathNames[lastIndex]);
    }

    private void setValues(AnyMap metaData, String id, Any any, Mode mode, String outputPath, String separator) throws BlackboardAccessException {
        AnySeq values = metaData.getFactory().createAnySeq();
        for (Any a : any) {
            if (!a.isValue()) continue;
            values.add((Object)a);
        }
        if (values != null && !values.isEmpty()) {
            switch (mode) {
                case FIRST: {
                    metaData.put(outputPath, (Any)values.get(0));
                    break;
                }
                case LAST: {
                    metaData.put(outputPath, (Any)values.get(values.size() - 1));
                    break;
                }
                case ALL_AS_LIST: {
                    metaData.put(outputPath, (Any)values);
                    break;
                }
                case ALL_AS_ONE: {
                    metaData.put(outputPath, (Any)this.concat(values, metaData.getFactory(), separator));
                    break;
                }
                default: {
                    this._log.error((Object)("Error while processing record " + id + ". Invalid mode " + (Object)((Object)mode)));
                }
            }
        }
    }

    private Value concat(AnySeq values, DataFactory factory, String separator) {
        StringBuffer buffer = new StringBuffer();
        for (Any any : values) {
            String stringValue = ((Value)any).asString();
            if (buffer.length() > 0) {
                buffer.append(separator);
            }
            buffer.append(stringValue);
        }
        return factory.createStringValue(buffer.toString());
    }

    private static enum Mode {
        FIRST,
        LAST,
        ALL_AS_LIST,
        ALL_AS_ONE;

    }
}

