/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager.httphandler;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.http.server.util.URLCreator;

/**
 * Implements the handling of HTTP requests for the jobmanager API.<br>
 * 
 * URL pattern: <code>smila/jobmanager/</code> <br>
 * 
 * Methods allowed: <code>GET</code>
 */
public class JobManagerHandler extends JsonRequestHandler {
  /**
   * {@inheritDoc}
   */
  @Override
  public Object process(final String method, final String requestUri, final Record inputRecord) throws Exception {
    final AnyMap result = FACTORY.createAnyMap();
    result.put("buckets", URLCreator.create(getRequestHost(), requestUri, "buckets").toString());
    result.put("workflows", URLCreator.create(getRequestHost(), requestUri, "workflows").toString());
    result.put("jobs", URLCreator.create(getRequestHost(), requestUri, "jobs").toString());
    result.put("dataObjectTypes", URLCreator.create(getRequestHost(), requestUri, "dataobjecttypes").toString());
    result.put("workers", URLCreator.create(getRequestHost(), requestUri, "workers").toString());
    return result;
  }

  /**
   * {@inheritDoc}
   * 
   * GET is currently the only valid method.
   */
  @Override
  protected boolean isValidMethod(final String method, final String requestUri) {
    return "GET".equals(method);
  }
}
