/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.taskmanager.persistence;

import java.util.ArrayList;
import java.util.List;

/**
 * list of tasks to display in state handler.
 */
public class TaskList {
  /**
   * name of task pipe.
   */
  private final String _workerName;

  /**
   * task pipe sub-type: "inprogress" or "todo".
   */
  private final String _section;

  /**
   * number of tasks.
   */
  private int _size;

  /**
   * list of internal task names.
   */
  private final ArrayList<String> _taskNames = new ArrayList<String>();

  /**
   * Conversion Constructor.
   * 
   * @param workerName
   *          the name of the worker
   * @param section
   *          task pipe sub-type: "inprogress" or "todo".
   * @param size
   *          the number of tasks
   */
  public TaskList(final String workerName, final String section, final int size) {
    super();
    _workerName = workerName;
    _section = section;
    _size = size;
  }

  /**
   * @return the name of the worker
   */
  public String getWorkerName() {
    return _workerName;
  }

  /**
   * @return queue section: "inprogress" or "todo".
   */
  public String getSection() {
    return _section;
  }

  /**
   * @return the number of tasks.
   */
  public int getSize() {
    return _size;
  }

  /**
   * @param size
   *          the number of tasks.
   */
  public void setSize(final int size) {
    _size = size;
  }

  /**
   * @return list of task names
   */
  public List<String> getTaskNames() {
    return _taskNames;
  }

  /**
   * add task name to current list.
   * 
   * @param taskName
   *          internal task name.
   */
  public void addTaskName(final String taskName) {
    _taskNames.add(taskName);
  }
}
