/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.connectivity.framework.httphandler;

import java.util.Map;

import org.eclipse.smila.connectivity.framework.AgentController;
import org.eclipse.smila.connectivity.framework.AgentState;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.util.URLCreator;

/**
 * Implements the handling of HTTP requests to request the agents list. <br>
 * 
 * URL pattern: <code>smila/agents/</code> <br>
 * 
 * Methods allowed: <code>GET</code>
 */
public class AgentsHandler extends BaseConnectivityHandler {

  /** key for the agents. */
  public static final String KEY_AGENTS = "agents";

  /** key for the name. */
  public static final String KEY_NAME = "name";

  /** key for the state. */
  public static final String KEY_STATE = "state";

  /** key for the url. */
  public static final String KEY_URL = "url";

  /** Reference to the {@link AgentController}. */
  private AgentController _agentController;

  /**
   * {@inheritDoc}
   */
  @Override
  public Object process(final String method, final String requestUri, final Record inputRecord) throws Exception {
    final AnyMap resultMap = DataFactory.DEFAULT.createAnyMap();
    final AnySeq stateSeq = DataFactory.DEFAULT.createAnySeq();
    if (_agentController != null) {
      final Map<String, AgentState> agentTaskStates = _agentController.getAgentTasksState();
      for (final String availableAgent : _agentController.getAvailableConfigurations()) {
        final AnyMap stateMap = DataFactory.DEFAULT.createAnyMap();
        final AgentState state = agentTaskStates.get(availableAgent);
        String stateString;
        if (state != null) {
          stateString = state.getState().name();
        } else {
          stateString = "Undefined";
        }
        stateMap.put(KEY_NAME, availableAgent);
        stateMap.put(KEY_STATE, stateString);
        stateMap.put(KEY_URL, URLCreator.create(getRequestHost(), requestUri, availableAgent).toURI()
          .toASCIIString());
        stateSeq.add(stateMap);
      }
      resultMap.put(KEY_AGENTS, stateSeq);
    }
    return resultMap;
  }

  /**
   * {@inheritDoc}
   * 
   * only GET is allowed.
   */
  @Override
  protected boolean isValidMethod(final String method, final String requestUri) {
    return "GET".equals(method);
  }

  /**
   * OSGi method to set the {@link AgentController}. Called by DS.
   * 
   * @param agentController
   */
  protected void setAgentController(final AgentController agentController) {
    _agentController = agentController;
  }

  /**
   * OSGi method to unset the {@link AgentController}. Called by DS.
   * 
   * @param agentController
   */
  protected void unsetAgentController(final AgentController agentController) {
    if (_agentController == agentController) {
      _agentController = null;
    }
  }

}
