/**********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.taskworker.input;

import org.eclipse.smila.objectstore.ObjectStoreService;

import org.eclipse.smila.taskmanager.BulkInfo;
import org.eclipse.smila.taskworker.io.IODataObject;

/** Base class for input wrappers. */
public abstract class Input extends IODataObject {

  /**
   * Create instance. Each subclass must implement the same constructor so that it can be instantiated by {@link Inputs}
   */
  public Input(final BulkInfo dataObject, final ObjectStoreService objectStore) {
    super(dataObject, objectStore);
  }

  /** clean up after reading the data. */
  public abstract void close();

}
