/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.datamodel.validation;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;

/**
 * Very basic validator that checks if a record contains a non-empty single string value in attribute
 * {@value Record#RECORD_ID}. If the value is not a string value, it is converted to one.
 */
public class RecordIdValidator implements RecordValidator {
  /**
   * check record.
   * 
   * @throws InvalidRecordException
   *           if the attribute {@value Record#RECORD_ID}, does contains no value or a sequence or map, or if the value
   *           is an empty string.
   */
  @Override
  public void validate(final Record record) throws InvalidRecordException {
    final AnyMap recordData = record.getMetadata();
    final Any idAttribute = recordData.get(Record.RECORD_ID);
    if (idAttribute == null) {
      throw new InvalidRecordException("Record attribute '" + Record.RECORD_ID + "' is missing.");
    }
    if (!idAttribute.isValue()) {
      throw new InvalidRecordException("Record attribute '" + Record.RECORD_ID + "' is no single value.");
    }
    if (!idAttribute.isString()) {
      recordData.put(Record.RECORD_ID, idAttribute.asValue().asString());
    }
    if (recordData.getStringValue(Record.RECORD_ID).isEmpty()) {
      throw new InvalidRecordException("Record attribute '" + Record.RECORD_ID + "' value is empty.");
    }
  }

}
