/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.cli;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ode.utils.cli.CommandlineFragment;
import org.apache.ode.utils.cli.CommandlineSyntaxException;
import org.apache.ode.utils.cli.LastArgument;

public class Fragments {
    private CommandlineFragment[] _cl;
    private CommandlineSyntaxException _reason;

    public Fragments(CommandlineFragment[] commandlineFragmentArray) {
        this._cl = commandlineFragmentArray;
    }

    public void resetFragments() {
        for (int i = 0; i < this._cl.length; ++i) {
            this._cl[i].reset();
        }
    }

    public CommandlineFragment[] getFragments() {
        return this._cl;
    }

    public CommandlineFragment[] getFragmentsInUserOrder() {
        if (this._cl == null || this._cl.length == 0) {
            return this._cl;
        }
        CommandlineFragment[] commandlineFragmentArray = new CommandlineFragment[this._cl.length];
        int n = 0;
        for (int i = 0; i < this._cl.length; ++i) {
            if (this._cl[i] instanceof LastArgument) {
                commandlineFragmentArray[this._cl.length - ++n] = this._cl[i];
                continue;
            }
            commandlineFragmentArray[i - n] = this._cl[i];
        }
        return commandlineFragmentArray;
    }

    public CommandlineSyntaxException getReason() {
        return this._reason;
    }

    public boolean matches(String[] stringArray) {
        this.resetFragments();
        try {
            int n;
            List<String> list = new ArrayList<String>();
            for (n = 0; n < stringArray.length; ++n) {
                list.add(stringArray[n]);
            }
            for (n = 0; n < this._cl.length; ++n) {
                list = this._cl[n].consume(list);
            }
            if (list.size() != 0) {
                StringBuffer stringBuffer = new StringBuffer();
                Iterator<String> iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (stringBuffer.length() != 0) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(iterator.next());
                }
                this._reason = new CommandlineSyntaxException("Not sure what to do with the extra items: " + stringBuffer.toString());
                return false;
            }
            return true;
        }
        catch (CommandlineSyntaxException commandlineSyntaxException) {
            this._reason = commandlineSyntaxException;
            this.resetFragments();
            return false;
        }
    }
}

