/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2.xquery10.runtime;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQConstants;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQResultSequence;
import javax.xml.xquery.XQSequence;
import javax.xml.xquery.XQSequenceType;
import javax.xml.xquery.XQStaticContext;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.xqj.SaxonXQConnection;
import net.sf.saxon.xqj.SaxonXQDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.rtrep.common.ConfigurationException;
import org.apache.ode.bpel.rtrep.v2.EvaluationContext;
import org.apache.ode.bpel.rtrep.v2.ExpressionLanguageRuntime;
import org.apache.ode.bpel.rtrep.v2.OExpression;
import org.apache.ode.bpel.rtrep.v2.xpath20.JaxpFunctionResolver;
import org.apache.ode.bpel.rtrep.v2.xpath20.JaxpVariableResolver;
import org.apache.ode.bpel.rtrep.v2.xquery10.OXQuery10ExpressionBPEL20;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.ISO8601DateParser;
import org.apache.ode.utils.NSContext;
import org.apache.ode.utils.xsd.Duration;
import org.apache.ode.utils.xsl.XslTransformHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XQuery10ExpressionRuntime
implements ExpressionLanguageRuntime {
    static final short NODE_TYPE = 1;
    static final short NODESET_TYPE = 2;
    static final short STRING_TYPE = 3;
    static final short BOOLEAN_TYPE = 4;
    static final short NUMBER_TYPE = 5;
    private static final Log __log = LogFactory.getLog(XQuery10ExpressionRuntime.class);

    public void initialize(Map map) throws ConfigurationException {
        TransformerFactoryImpl transformerFactoryImpl = new TransformerFactoryImpl();
        XslTransformHandler.getInstance().setTransformerFactory((TransformerFactory)transformerFactoryImpl);
    }

    public String evaluateAsString(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        return (String)this.evaluate(oExpression, evaluationContext, XPathConstants.STRING);
    }

    public boolean evaluateAsBoolean(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        return (Boolean)this.evaluate(oExpression, evaluationContext, XPathConstants.BOOLEAN);
    }

    public Number evaluateAsNumber(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        return (Number)this.evaluate(oExpression, evaluationContext, XPathConstants.NUMBER);
    }

    public List evaluate(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        List<Node> list;
        Object object = this.evaluate(oExpression, evaluationContext, XPathConstants.NODESET);
        if (object instanceof List) {
            list = (ArrayList<Node>)object;
            __log.debug((Object)("Returned list of size " + list.size()));
            if (list.size() == 1 && !(list.get(0) instanceof Node)) {
                Object e = list.get(0);
                String string = e instanceof Date ? ISO8601DateParser.format((Date)((Date)e)) : (e instanceof DurationValue ? ((DurationValue)e).getStringValue() : e.toString());
                Document document = DOMUtils.newDocument();
                Element element = document.createElement("wrapper");
                Text text = document.createTextNode(string);
                element.appendChild(text);
                document.appendChild(element);
                list = Collections.singletonList(text);
            }
        } else if (object instanceof NodeList) {
            NodeList nodeList = (NodeList)object;
            __log.debug((Object)("Returned node list of size " + nodeList.getLength()));
            list = new ArrayList<Node>(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 9) {
                    node = ((Document)node).getDocumentElement();
                }
                list.add(node);
            }
        } else {
            list = null;
        }
        return list;
    }

    public Node evaluateNode(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        List list = this.evaluate(oExpression, evaluationContext);
        if (list.size() == 0) {
            throw new FaultException(oExpression.getOwner().constants.qnSelectionFailure, "No results for expression: " + oExpression);
        }
        if (list.size() > 1) {
            throw new FaultException(oExpression.getOwner().constants.qnSelectionFailure, "Multiple results for expression: " + oExpression);
        }
        return (Node)list.get(0);
    }

    public Calendar evaluateAsDate(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        List list = DOMUtils.toList((Object)this.evaluate(oExpression, evaluationContext, XPathConstants.NODESET));
        if (list.size() == 0) {
            throw new FaultException(oExpression.getOwner().constants.qnSelectionFailure, "No results for expression: " + oExpression);
        }
        if (list.size() > 1) {
            throw new FaultException(oExpression.getOwner().constants.qnSelectionFailure, "Multiple results for expression: " + oExpression);
        }
        Object object = list.get(0);
        if (object instanceof Calendar) {
            return (Calendar)object;
        }
        if (object instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            return calendar;
        }
        if (object instanceof Element) {
            object = ((Element)object).getTextContent();
        }
        try {
            return ISO8601DateParser.parseCal((String)object.toString());
        }
        catch (Exception exception) {
            String string = "Invalid date: " + list;
            __log.error((Object)string, (Throwable)exception);
            throw new FaultException(oExpression.getOwner().constants.qnInvalidExpressionValue, string);
        }
    }

    public Duration evaluateAsDuration(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        String string = this.evaluateAsString(oExpression, evaluationContext);
        try {
            return new Duration(string);
        }
        catch (Exception exception) {
            String string2 = "Invalid duration: " + string;
            __log.error((Object)string2, (Throwable)exception);
            throw new FaultException(oExpression.getOwner().constants.qnInvalidExpressionValue, string2);
        }
    }

    private Object evaluate(OExpression oExpression, EvaluationContext evaluationContext, QName qName) throws FaultException {
        try {
            Object object;
            String string2;
            OXQuery10ExpressionBPEL20 oXQuery10ExpressionBPEL20 = (OXQuery10ExpressionBPEL20)oExpression;
            SaxonXQDataSource saxonXQDataSource = new SaxonXQDataSource();
            XQConnection xQConnection = saxonXQDataSource.getConnection();
            Configuration configuration = ((SaxonXQConnection)xQConnection).getConfiguration();
            configuration.setAllNodesUntyped(true);
            configuration.setHostLanguage(51);
            XQStaticContext xQStaticContext = xQConnection.getStaticContext();
            NSContext nSContext = oXQuery10ExpressionBPEL20.namespaceCtx;
            Set set = nSContext.getPrefixes();
            for (String string2 : set) {
                object = nSContext.getNamespaceURI(string2);
                xQStaticContext.declareNamespace(string2, (String)object);
            }
            configuration.setSchemaValidationMode(4);
            xQConnection.setStaticContext(xQStaticContext);
            String string3 = oXQuery10ExpressionBPEL20.xquery.replaceFirst("org.apache.ode.bpel.compiler.v2.xquery10.compiler.XQuery10BpelFunctions", "org.apache.ode.bpel.rtrep.v2.xquery10.runtime.XQuery10BpelFunctions");
            string2 = xQConnection.prepareExpression(string3);
            object = new JaxpFunctionResolver(evaluationContext, oXQuery10ExpressionBPEL20);
            JaxpVariableResolver jaxpVariableResolver = new JaxpVariableResolver(evaluationContext, oXQuery10ExpressionBPEL20, configuration);
            for (QName qName2 : string2.getAllUnboundExternalVariables()) {
                Object object2 = jaxpVariableResolver.resolveVariable(qName2);
                XQSequenceType xQSequenceType = this.getItemType(xQConnection, object2);
                if (!(object2 instanceof Node) && object2 instanceof NodeList) {
                    NodeList nodeList = (NodeList)object2;
                    ArrayList<Node> arrayList = new ArrayList<Node>();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        arrayList.add(nodeList.item(i));
                    }
                    object2 = xQConnection.createSequence(arrayList.iterator());
                }
                if (object2 == null || xQSequenceType == null) continue;
                if (object2 instanceof XQSequence) {
                    string2.bindSequence(qName2, (XQSequence)object2);
                    continue;
                }
                if (!(xQSequenceType instanceof XQItemType)) continue;
                string2.bindObject(qName2, object2, (XQItemType)xQSequenceType);
            }
            Node node = evaluationContext.getRootNode() == null ? DOMUtils.newDocument() : evaluationContext.getRootNode();
            node.setUserData("function-resolver", object, null);
            string2.bindItem(XQConstants.CONTEXT_ITEM, xQConnection.createItemFromNode(node, xQConnection.createNodeType()));
            XQResultSequence xQResultSequence = string2.executeQuery();
            Object object3 = this.getResultValue(qName, xQResultSequence);
            if (object3 != null && __log.isDebugEnabled()) {
                __log.debug((Object)("Expression " + oExpression.toString() + " generated result " + object3 + " - type=" + object3.getClass().getName()));
                if (evaluationContext.getRootNode() != null) {
                    __log.debug((Object)("Was using context node " + DOMUtils.domToString((Node)evaluationContext.getRootNode())));
                }
            }
            return object3;
        }
        catch (XQException xQException) {
            Throwable throwable;
            Throwable throwable2;
            Throwable throwable3 = throwable2 = xQException.getCause() != null ? xQException.getCause() : xQException;
            if (throwable2 instanceof DynamicError && (throwable = ((DynamicError)throwable2).getException()) != null && (throwable2 = throwable).getCause() != null) {
                throwable2 = throwable2.getCause();
            }
            throw new FaultException(oExpression.getOwner().constants.qnSubLanguageExecutionFault, throwable2.getMessage(), throwable2);
        }
        catch (Throwable throwable) {
            __log.debug((Object)"Could not evaluate expression because of ", throwable);
            throw new FaultException(oExpression.getOwner().constants.qnSubLanguageExecutionFault, throwable.getMessage(), throwable);
        }
    }

    private Object getItemValue(XQItem xQItem) throws XQException {
        XQItemType xQItemType = xQItem.getItemType();
        Object object = null;
        switch (xQItemType.getBaseType()) {
            case 10: {
                object = xQItem.getBoolean();
                break;
            }
            case 17: {
                object = xQItem.getDouble();
                break;
            }
            case 31: {
                object = xQItem.getByte();
                break;
            }
            case 20: {
                object = Float.valueOf(xQItem.getFloat());
                break;
            }
            case 12: 
            case 13: {
                object = xQItem.getInt();
                break;
            }
            case 15: {
                object = xQItem.getLong();
                break;
            }
            case 2: {
                object = xQItem.getNode();
                break;
            }
            case 8: {
                object = xQItem.getNodeUri();
                break;
            }
            case 14: {
                object = xQItem.getShort();
                break;
            }
            case 4: 
            case 29: {
                object = xQItem.getAtomicValue();
            }
        }
        return object;
    }

    private XQSequenceType getItemType(XQConnection xQConnection, Object object) throws XQException {
        XQItemType xQItemType = null;
        if (object instanceof Long) {
            xQItemType = xQConnection.createAtomicType(15);
        } else if (object instanceof String) {
            xQItemType = xQConnection.createAtomicType(29);
        } else if (object instanceof Node) {
            xQItemType = xQConnection.createNodeType();
        } else if (object instanceof NodeList || object instanceof XQSequence) {
            XQItemType xQItemType2 = xQConnection.createNodeType();
            xQItemType = xQConnection.createSequenceType(xQItemType2, 3);
        }
        return xQItemType;
    }

    private Object getResultValue(QName qName, XQResultSequence xQResultSequence) throws XQException {
        Document document = DOMUtils.newDocument();
        Object object = null;
        if (XPathConstants.NODESET.equals(qName)) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (xQResultSequence.next()) {
                Object object2 = this.getItemValue(xQResultSequence.getItem());
                if (object2 instanceof Node) {
                    object2 = DOMUtils.cloneNode((Document)document, (Node)((Node)object2));
                }
                if (object2 == null) continue;
                arrayList.add(object2);
            }
            object = arrayList;
        } else if (XPathConstants.NODE.equals(qName)) {
            XQItem xQItem = null;
            if (xQResultSequence.count() > 0) {
                xQResultSequence.first();
                if (xQResultSequence.isOnItem()) {
                    xQItem = xQResultSequence.getItem();
                }
            }
            if (xQItem != null && (object = this.getItemValue(xQItem)) instanceof Node) {
                object = DOMUtils.cloneNode((Document)document, (Node)((Node)object));
            }
        } else if (XPathConstants.STRING.equals(qName)) {
            object = xQResultSequence.getSequenceAsString(new Properties());
        } else if (XPathConstants.NUMBER.equals(qName)) {
            object = xQResultSequence.getSequenceAsString(new Properties());
            object = Integer.parseInt((String)object);
        } else if (XPathConstants.BOOLEAN.equals(qName)) {
            object = xQResultSequence.getSequenceAsString(new Properties());
            object = Boolean.parseBoolean((String)object);
        }
        return object;
    }
}

