/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr;

import org.eclipse.smila.management.LocatedManagementAgent;
import org.eclipse.smila.management.ManagementRegistration;
import org.eclipse.smila.search.api.SearchService;
import org.eclipse.smila.solr.SolrServerManager;
import org.eclipse.smila.solr.SolrServerManagerAgent;
import org.eclipse.smila.solr.admin.SolrAdminAgent;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String BUNDLE_ID = "org.eclipse.smila.solr";
    private static Activator s_instance;
    private SolrServerManager _serverManager;
    private ServiceTracker _searchServiceTracker;

    public void start(BundleContext context) throws Exception {
        s_instance = this;
        this._serverManager = new SolrServerManager();
        ManagementRegistration.INSTANCE.registerAgent((LocatedManagementAgent)new SolrServerManagerAgent(this._serverManager));
        ManagementRegistration.INSTANCE.registerAgent((LocatedManagementAgent)new SolrAdminAgent(this._serverManager.getSolrAdmin()));
        this._searchServiceTracker = new ServiceTracker(context, SearchService.class.getName(), null);
        this._searchServiceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        s_instance = null;
        this._searchServiceTracker.close();
    }

    public static Activator getInstance() {
        return s_instance;
    }

    public SolrServerManager getSolrManager() {
        return this._serverManager;
    }

    public SearchService getSearchService() {
        return (SearchService)this._searchServiceTracker.getService();
    }
}

