/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.admin;

import java.util.Map;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.eclipse.smila.solr.admin.SolrBaseAdmin;
import org.eclipse.smila.solr.util.SolrHelper;

public class SolrEmbeddedAdmin
extends SolrBaseAdmin {
    private final CoreAdminHandler _admin;

    public SolrEmbeddedAdmin(SolrHelper helper, CoreContainer container) {
        super(helper);
        this._admin = new CoreAdminHandler(container);
    }

    @Override
    public String alias(String coreName, String aliasName) throws Exception {
        Map<String, String[]> params = this.buildAdminParams(CoreAdminParams.CoreAdminAction.ALIAS, coreName, aliasName);
        SolrCore core = this._admin.getCoreContainer().getCore(coreName);
        SolrQueryResponse response = this.handleRequest(core, params);
        return this.handleResponse(response);
    }

    @Override
    public String create(String srcCore, String targetCore) throws Exception {
        this._log.info((Object)String.format("creating config by template: %s -> %s", srcCore, targetCore));
        this._helper.copyCoreConfig(srcCore, targetCore);
        String instanceDir = targetCore;
        return this.create(targetCore, instanceDir, "data");
    }

    @Override
    public String create(String coreName, String instanceDir, String dataDir) throws Exception {
        String[] name = new String[]{coreName};
        String[] instanceDirParam = new String[]{instanceDir};
        String[] dataDirParam = new String[]{dataDir};
        Map<String, String[]> params = this.buildAdminParams(CoreAdminParams.CoreAdminAction.CREATE, coreName, null);
        params.put("name", name);
        params.put("instanceDir", instanceDirParam);
        params.put("dataDir", dataDirParam);
        SolrCore core = this._admin.getCoreContainer().getCore(coreName);
        SolrQueryResponse response = this.handleRequest(core, params);
        return this.handleResponse(response);
    }

    @Override
    public String merge(String coreName, String indexDir1, String indexDir2) throws Exception {
        Map<String, String[]> params = this.buildAdminParams(CoreAdminParams.CoreAdminAction.MERGEINDEXES, coreName, null);
        String[] indexDir = new String[]{indexDir1, indexDir2};
        params.put("indexDir", indexDir);
        SolrCore core = this._admin.getCoreContainer().getCore(coreName);
        SolrQueryResponse response = this.handleRequest(core, params);
        return this.handleResponse(response);
    }

    @Override
    public String reload(String coreName) throws Exception {
        Map<String, String[]> params = this.buildAdminParams(CoreAdminParams.CoreAdminAction.RELOAD, coreName, null);
        SolrCore core = this._admin.getCoreContainer().getCore(coreName);
        SolrQueryResponse response = this.handleRequest(core, params);
        return this.handleResponse(response);
    }

    @Override
    public String rename(String coreName, String newName) throws Exception {
        Map<String, String[]> params = this.buildAdminParams(CoreAdminParams.CoreAdminAction.RENAME, coreName, newName);
        SolrCore core = this._admin.getCoreContainer().getCore(coreName);
        SolrQueryResponse response = this.handleRequest(core, params);
        return this.handleResponse(response);
    }

    @Override
    public String status(String coreName) throws Exception {
        Map<String, String[]> params = this.buildAdminParams(CoreAdminParams.CoreAdminAction.STATUS, coreName, null);
        SolrCore core = this._admin.getCoreContainer().getCore(coreName);
        SolrQueryResponse response = this.handleRequest(core, params);
        return this.handleResponse(response);
    }

    @Override
    public String unload(String coreName) throws Exception {
        Map<String, String[]> params = this.buildAdminParams(CoreAdminParams.CoreAdminAction.UNLOAD, coreName, null);
        SolrCore core = this._admin.getCoreContainer().getCore(coreName);
        SolrQueryResponse response = this.handleRequest(core, params);
        return this.handleResponse(response);
    }

    private SolrQueryResponse handleRequest(SolrCore core, Map<String, String[]> params) throws Exception {
        LocalSolrQueryRequest req = null;
        SolrQueryResponse resp = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SolrQueryResponse.class.getClassLoader());
        try {
            try {
                req = new LocalSolrQueryRequest(core, params);
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Execute SolrQueryRequest with params: " + req.getParams()));
                }
                resp = new SolrQueryResponse();
                this._admin.handleRequest((SolrQueryRequest)req, resp);
            }
            catch (Exception exception) {
                throw new Exception("Error while handle SolrQueryRequest", exception);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return resp;
    }

    private String handleResponse(SolrQueryResponse response) throws Exception {
        NamedList values;
        NamedList log;
        Exception exception = response.getException();
        if (exception != null) {
            throw new Exception("Error while execute SolrQueryRequerst.", exception);
        }
        StringBuilder output = new StringBuilder();
        NamedList header = response.getResponseHeader();
        if (header != null && header.size() > 0) {
            output.append("ResponseHeader: ");
            output.append(String.valueOf(header.toString()) + "\n");
        }
        if ((log = response.getToLog()) != null && log.size() > 0) {
            output.append("ToLog: ");
            output.append(String.valueOf(log.toString()) + "\n");
        }
        if ((values = response.getValues()) != null && values.size() > 0) {
            output.append("Values: ");
            output.append(String.valueOf(values.toString()) + "\n");
        }
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("SolrQueryRespoinse: " + output));
        }
        return output.toString();
    }
}

