/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.index;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.xml.XmlSerializationUtils;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.MissingParameterException;
import org.eclipse.smila.solr.Activator;
import org.eclipse.smila.solr.SolrConstants;
import org.eclipse.smila.solr.SolrServerManager;
import org.eclipse.smila.solr.util.SolrUtils;

public class SolrIndexPipelet
implements Pipelet {
    private static final String CONF_ERROR = "Invalid Pipelet configuration -> ";
    private static final String CONF_ERROR_PARAMETER_MISSING = "Invalid Pipelet configuration -> Parameter missing: ";
    private final Log _log = LogFactory.getLog(SolrIndexPipelet.class);
    private AnyMap _configuration;
    private AnySeq _coreFieldsSeq;
    private SolrConstants.ExecutionMode _executionMode;
    private SolrServer _defaultTargetCore;
    private String _defaultCoreName;

    public void configure(AnyMap configuration) throws ProcessingException {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Configure SolrIndexPipelet");
        }
        this._configuration = configuration;
        try {
            if (StringUtils.isBlank((String)configuration.getStringValue("ExecutionMode"))) {
                throw new MissingParameterException("Invalid Pipelet configuration -> Parameter missing: ExecutionMode");
            }
            this._executionMode = SolrConstants.ExecutionMode.valueOf(this._configuration.getStringValue("ExecutionMode"));
            switch (this._executionMode) {
                case DELETE: {
                    break;
                }
                case ADD: 
                case UPDATE: {
                    this._coreFieldsSeq = this._configuration.getSeq("CoreFields");
                    for (Any coreFieldMap : this._coreFieldsSeq) {
                        if (coreFieldMap.isMap()) continue;
                        throw new ProcessingException("all items must be of type AnyMap in pipelet config: CoreFields");
                    }
                    break;
                }
                default: {
                    throw new NotImplementedException("_executionMode: " + (Object)((Object)this._executionMode));
                }
            }
            this._defaultCoreName = StringUtils.trimToNull((String)this._configuration.getStringValue("CoreName"));
            if (StringUtils.isBlank((String)this._defaultCoreName)) {
                this._log.warn((Object)"there is no default core configured in the pipelet config! Target core must be set now on each record dynamically via: _coreName");
            }
        }
        catch (Exception exception) {
            throw new ProcessingException("Error while configure SolrIndexPipelet", (Throwable)exception);
        }
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        if (recordIds != null) {
            block8: {
                if (this._defaultCoreName != null) {
                    try {
                        this._defaultTargetCore = this.getSolrManager().getSolrServer(this._defaultCoreName);
                    }
                    catch (Exception e) {
                        if (!this._log.isTraceEnabled()) break block8;
                        this._log.warn((Object)String.format("default core not reachable: %s. Exception: %s", this._defaultCoreName, e.getMessage()));
                    }
                }
            }
            switch (this._executionMode) {
                case ADD: {
                    this.addRecords(blackboard, recordIds);
                    break;
                }
                case DELETE: {
                    this.delete(recordIds, this._defaultTargetCore);
                    break;
                }
                default: {
                    throw new NotImplementedException("executionMode: " + (Object)((Object)this._executionMode));
                }
            }
        }
        return recordIds;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addRecords(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        HashMap coreToDocsMap = new HashMap();
        String[] stringArray = recordIds;
        int n = recordIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.traceRecord(blackboard, id);
            try {
                Double boostFactor;
                SolrServer targetCore;
                SolrInputDocument doc = new SolrInputDocument();
                AnyMap metadata = blackboard.getMetadata(id);
                doc.addField("Id", (Object)id);
                if (metadata.containsKey((Object)"_coreName")) {
                    targetCore = this.getSolrManager().getSolrServer(metadata.getStringValue("_coreName"));
                } else {
                    if (this._defaultTargetCore == null) {
                        throw new ProcessingException("no dynamic core in record given while default core is null. check if the pipelet defines a valid default core or that the record carries the dynamicCore attribute");
                    }
                    targetCore = this._defaultTargetCore;
                }
                ArrayList<SolrInputDocument> solrDocs = (ArrayList<SolrInputDocument>)coreToDocsMap.get(targetCore);
                if (solrDocs == null) {
                    solrDocs = new ArrayList<SolrInputDocument>(recordIds.length);
                    coreToDocsMap.put(targetCore, solrDocs);
                }
                if ((boostFactor = metadata.getDoubleValue("_docBoost")) != null) {
                    doc.setDocumentBoost(boostFactor.floatValue());
                }
                block9: for (Any coreFieldMap : this._coreFieldsSeq) {
                    SolrConstants.AttributeOrAttachment recSourceType;
                    String recSourceTypeString;
                    AnyMap fieldMap = coreFieldMap.asMap();
                    String fieldName = fieldMap.getStringValue("FieldName");
                    if (StringUtils.isBlank((String)fieldName)) {
                        throw new MissingParameterException("Invalid Pipelet configuration -> Parameter missing: FieldName");
                    }
                    String recSourceName = fieldMap.getStringValue("RecSourceName");
                    if (StringUtils.isBlank((String)recSourceName)) {
                        recSourceName = fieldName;
                        if (this._log.isTraceEnabled()) {
                            this._log.trace((Object)String.format("core field mapping %s: no %s config'ed. Defaulting to field name", fieldName, "RecSourceName"));
                        }
                    }
                    if (StringUtils.isBlank((String)(recSourceTypeString = fieldMap.getStringValue("RecSourceType")))) {
                        recSourceType = SolrConstants.AttributeOrAttachment.ATTRIBUTE;
                        if (this._log.isTraceEnabled()) {
                            this._log.trace((Object)String.format("core field mapping %s: no %s config'ed. Defaulting to %s", new Object[]{fieldName, "RecSourceType", recSourceType}));
                        }
                    } else {
                        recSourceType = SolrConstants.AttributeOrAttachment.valueOf(recSourceTypeString.toUpperCase());
                    }
                    switch (recSourceType) {
                        case ATTRIBUTE: {
                            Any any = (Any)metadata.get((Object)recSourceName);
                            if (any != null) {
                                if (any.isValue()) {
                                    doc.addField(fieldName, any.asValue().getObject());
                                } else {
                                    if (!any.isSeq()) throw new ProcessingException("value type for indexing in solr not supported. Must be one of Value, Seq but is: " + any.getValueType());
                                    AnySeq asSeq = any.asSeq();
                                    for (Any seqValues : asSeq) {
                                        doc.addField(fieldName, seqValues.asValue().getObject());
                                    }
                                }
                            } else {
                                if (!this._log.isTraceEnabled()) continue block9;
                                this._log.trace((Object)("Record doesn't contain an attribute named: " + recSourceName));
                                break;
                            }
                        }
                        case ATTACHMENT: {
                            if (blackboard.hasAttachment(id, recSourceName)) {
                                byte[] value = blackboard.getAttachment(id, recSourceName);
                                String string = new String(value, "UTF-8");
                                doc.addField(fieldName, (Object)string);
                                break;
                            }
                            if (!this._log.isTraceEnabled()) continue block9;
                            this._log.trace((Object)("Record doesn't have an attachment named: " + recSourceName));
                            break;
                        }
                        default: {
                            throw new NotImplementedException("recSourceType: " + (Object)((Object)recSourceType));
                        }
                    }
                }
                solrDocs.add(doc);
                if (this._log.isInfoEnabled()) {
                    this._log.info((Object)("record added to document collection: " + id));
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("solr document: " + doc.toString()));
                    }
                }
            }
            catch (Exception e) {
                String msg = "Error while adding record with id: " + id;
                throw new ProcessingException(msg, (Throwable)e);
            }
            ++n2;
        }
        try {
            for (Map.Entry entry : coreToDocsMap.entrySet()) {
                Collection docs;
                SolrServer server = (SolrServer)entry.getKey();
                UpdateResponse solrResponse = server.add(docs = (Collection)entry.getValue());
                if (SolrUtils.responseStatusIsError((SolrResponseBase)solrResponse)) {
                    throw new ProcessingException("Error reported by solr reponse with status: " + solrResponse.getStatus());
                }
                if (!this._log.isDebugEnabled()) continue;
                this._log.info((Object)MessageFormat.format("document collection was added to solr in {1} ms, doc count = {0} ", docs.size(), solrResponse.getElapsedTime()));
            }
            return;
        }
        catch (Exception e) {
            throw new ProcessingException("Error while adding document collection to solr server.", (Throwable)e);
        }
    }

    private void traceRecord(Blackboard blackboard, String id) {
        if (this._log.isTraceEnabled()) {
            try {
                Record record = blackboard.getRecord(id);
                String serialize2string = XmlSerializationUtils.serialize2string((Record)record).replace('\n', ' ');
                this._log.trace((Object)("processing record: " + serialize2string));
            }
            catch (BlackboardAccessException e) {
                this._log.trace((Object)"error on serializing the record for logging: ", (Throwable)e);
            }
        }
    }

    private void delete(String[] recordIds, SolrServer server) throws ProcessingException {
        String[] stringArray = recordIds;
        int n = recordIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            try {
                UpdateResponse deleteResponse = server.deleteById(id);
                if (SolrUtils.responseStatusIsError((SolrResponseBase)deleteResponse)) {
                    throw new ProcessingException("Error reported by solr reponse while delete record with id: " + id);
                }
                if (this._log.isDebugEnabled()) {
                    String msg = MessageFormat.format("Record deleted: Id: {0} Index: {1} time: {2}ms.", id, deleteResponse.getRequestUrl(), deleteResponse.getElapsedTime());
                    this._log.debug((Object)msg);
                }
            }
            catch (Exception e) {
                throw new ProcessingException("Error while delete record with id: " + id, (Throwable)e);
            }
            ++n2;
        }
    }

    public SolrServerManager getSolrManager() {
        return Activator.getInstance().getSolrManager();
    }
}

