/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.util;

import org.apache.commons.lang.StringUtils;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;

public class HighlightingQueryConfigAdapter {
    private final AnyMap _map = DataFactory.DEFAULT.createAnyMap();

    public HighlightingQueryConfigAdapter() {
        this._map.put("attribute", "global.solr.params");
        this._map.put("hl", Boolean.valueOf(true));
    }

    public HighlightingQueryConfigAdapter(String field) {
        this._map.put("attribute", field);
    }

    public AnyMap getAnyMap() {
        return this._map;
    }

    public HighlightingQueryConfigAdapter setHighlightingFields(String ... values) {
        this._map.put("hl.fl", StringUtils.join((Object[])values, (String)" "));
        return this;
    }

    public HighlightingQueryConfigAdapter setHighlightingSnippets(int value) {
        this._map.put("hl.snippets", (Number)value);
        return this;
    }

    public HighlightingQueryConfigAdapter setHighlightingFragsize(int value) {
        this._map.put("hl.fragsize", (Number)value);
        return this;
    }

    public HighlightingQueryConfigAdapter setHighlightingMergeContiguous(Boolean value) {
        this._map.put("hl.mergeContiguous", value);
        return this;
    }

    public HighlightingQueryConfigAdapter setHighlightingRequireFieldMatch(Boolean value) {
        this._map.put("hl.requireFieldMatch", value);
        return this;
    }

    public HighlightingQueryConfigAdapter setHighlightingMaxAnalyzedChars(int value) {
        this._map.put("hl.maxAnalyzedChars", (Number)value);
        return this;
    }

    public HighlightingQueryConfigAdapter setHighlightingAlternateField(String value) {
        this._map.put("hl.alternateField", value);
        return this;
    }

    public HighlightingQueryConfigAdapter setHighlightingAlternateFieldLength(int value) {
        this._map.put("hl.maxAlternateFieldLength", (Number)value);
        return this;
    }

    public HighlightingQueryConfigAdapter setHighlightingSimplePre(String value) {
        this._map.put("hl.simple.pre", value);
        return this;
    }

    public HighlightingQueryConfigAdapter setHighlightingSimplePost(String value) {
        this._map.put("hl.simple.post", value);
        return this;
    }

    public HighlightingQueryConfigAdapter setHighlightingFragmenter(HighlightingFragmenter fragmenter) {
        return this.setHighlightingFragmenter(fragmenter.toString());
    }

    public HighlightingQueryConfigAdapter setHighlightingFragmenter(String fragmenter) {
        this._map.put("hl.fragmenter", fragmenter);
        return this;
    }

    public HighlightingQueryConfigAdapter setHighlightingUsePhraseHighlighter(Boolean value) {
        this._map.put("hl.usePhraseHighlighter", value);
        return this;
    }

    public HighlightingQueryConfigAdapter setHighlightingMultiTerm(Boolean value) {
        this._map.put("hl.highlightMultiTerm", value);
        return this;
    }

    public HighlightingQueryConfigAdapter setHighlightingRegexSlop(Double value) {
        this._map.put("hl.regex.slop", (Number)value);
        return this;
    }

    public HighlightingQueryConfigAdapter setHighlightingRegexPattern(String value) {
        this._map.put("hl.regex.pattern", value);
        return this;
    }

    public HighlightingQueryConfigAdapter setHighlightingRegexMaxAnalysedChars(int value) {
        this._map.put("hl.regex.maxAnalyzedChars", (Number)value);
        return this;
    }

    public static enum HighlightingFragmenter {
        GAP,
        REGEX;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum HighlightingType {
        GLOBAL,
        FIELD;

    }
}

