/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.highlighting.transformer;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.smila.search.highlighting.transformer.ComplexHLResultAggregation;
import org.eclipse.smila.search.highlighting.transformer.HighlightingTransformer;
import org.eclipse.smila.search.highlighting.transformer.HighlightingTransformerException;
import org.eclipse.smila.search.utils.param.ParameterSet;
import org.eclipse.smila.search.utils.searchresult.DHighLighted;

public class Sentence
extends HighlightingTransformer {
    @Override
    public ArrayList<Object> transform(ArrayList<Object> data, ParameterSet parameterSet) throws HighlightingTransformerException {
        int i;
        int maxElements;
        if (data == null) {
            throw new HighlightingTransformerException("no data specified for highlighting transformation");
        }
        Integer maxSucceedingChars = parameterSet.getIntegerParameter("MaxSucceedingCharacters");
        ComplexHLResultAggregation.SortAlgorithm sortAlgorithm = ComplexHLResultAggregation.SortAlgorithm.valueOf(parameterSet.getStringParameter("SortAlgorithm"));
        Integer maxHLElements = parameterSet.getIntegerParameter("MaxHLElements");
        Integer maxLength = parameterSet.getIntegerParameter("MaxLength");
        ComplexHLResultAggregation.TextHandling textHandling = ComplexHLResultAggregation.TextHandling.valueOf(parameterSet.getStringParameter("TextHandling"));
        String succeedingCharacters = parameterSet.getStringParameter("SucceedingCharacters");
        ArrayList<ComplexHLResultAggregation.HlTriple> hlTriples = new ArrayList<ComplexHLResultAggregation.HlTriple>();
        StringBuffer prefix = new StringBuffer();
        StringBuffer suffix = new StringBuffer();
        int i2 = 0;
        while (i2 < data.size()) {
            ComplexHLResultAggregation.HlTriple hlTriple = new ComplexHLResultAggregation.HlTriple();
            while (!(data.get(i2) instanceof DHighLighted)) {
                prefix = prefix.append((String)data.get(i2));
                if (i2 >= data.size() - 1) break;
                ++i2;
            }
            hlTriple.setPrefix(prefix.toString());
            prefix = new StringBuffer();
            if (data.get(i2) instanceof DHighLighted) {
                hlTriple.setHighLighted((DHighLighted)data.get(i2));
                if (i2 < data.size()) {
                    ++i2;
                }
            }
            if (i2 < data.size()) {
                while (!(data.get(i2) instanceof DHighLighted)) {
                    suffix = suffix.append((String)data.get(i2));
                    if (i2 >= data.size() - 1) break;
                    ++i2;
                }
            }
            hlTriple.setSuffix(suffix.toString());
            suffix = new StringBuffer();
            hlTriples.add(hlTriple);
            prefix = prefix.append(hlTriple.getSuffix());
            if (i2 != data.size() - 1) continue;
            ++i2;
        }
        Object[] hlTriplesArray = new ComplexHLResultAggregation.HlTriple[]{};
        hlTriplesArray = hlTriples.toArray(hlTriplesArray);
        if (sortAlgorithm == ComplexHLResultAggregation.SortAlgorithm.Score) {
            Arrays.sort(hlTriplesArray);
        }
        if (maxHLElements != null && hlTriplesArray.length > (maxElements = maxHLElements.intValue())) {
            ComplexHLResultAggregation.HlTriple[] temp = new ComplexHLResultAggregation.HlTriple[maxElements];
            i = 0;
            while (i < maxElements) {
                temp[i] = hlTriplesArray[i];
                ++i;
            }
            hlTriplesArray = temp;
        }
        ArrayList<String> newData = new ArrayList<String>();
        int charCount = 0;
        if (hlTriplesArray.length == 1 && ((ComplexHLResultAggregation.HlTriple)hlTriplesArray[0]).getHighLighted() == null && textHandling == ComplexHLResultAggregation.TextHandling.ReturnFullText) {
            String s = (String)data.get(0);
            int length = s.length() < maxLength ? s.length() : maxLength.intValue();
            String hlExtract = s.substring(0, length);
            if (s.length() > maxLength) {
                hlExtract = String.valueOf(hlExtract) + succeedingCharacters;
            }
            newData.add(hlExtract);
        } else if (hlTriplesArray.length != 1 || ((ComplexHLResultAggregation.HlTriple)hlTriplesArray[0]).getHighLighted() != null || textHandling != ComplexHLResultAggregation.TextHandling.ReturnNoText) {
            i = 0;
            while (i < hlTriplesArray.length) {
                String s;
                if (((ComplexHLResultAggregation.HlTriple)hlTriplesArray[i]).getPrefix() != null) {
                    s = this.getLastSentence(((ComplexHLResultAggregation.HlTriple)hlTriplesArray[i]).getPrefix());
                    charCount += s.length();
                    ((ComplexHLResultAggregation.HlTriple)hlTriplesArray[i]).setPrefix(s);
                    newData.add(s);
                }
                if (((ComplexHLResultAggregation.HlTriple)hlTriplesArray[i]).getHighLighted() != null) {
                    charCount += ((ComplexHLResultAggregation.HlTriple)hlTriplesArray[i]).getHighLighted().getText().length();
                    newData.add((String)((ComplexHLResultAggregation.HlTriple)hlTriplesArray[i]).getHighLighted());
                }
                if (((ComplexHLResultAggregation.HlTriple)hlTriplesArray[i]).getSuffix() != null) {
                    s = this.getFirstSentence(((ComplexHLResultAggregation.HlTriple)hlTriplesArray[i]).getSuffix());
                    boolean appendSuccedingCharacters = s.length() > maxSucceedingChars;
                    int charPosition = 0;
                    if (s.length() > maxSucceedingChars) {
                        int j = maxSucceedingChars;
                        while (j > 0) {
                            if (s.charAt(j) == ' ') {
                                charPosition = j;
                                break;
                            }
                            --j;
                        }
                    }
                    s = s.length() <= maxSucceedingChars ? s : s.substring(0, charPosition);
                    charCount += s.length();
                    if (!"".equals(s) && !" ".equals(s) && appendSuccedingCharacters) {
                        s = String.valueOf(s) + succeedingCharacters;
                    }
                    ((ComplexHLResultAggregation.HlTriple)hlTriplesArray[i]).setSuffix(s);
                    newData.add(s);
                }
                if (maxLength != null && charCount >= maxLength) break;
                ++i;
            }
        }
        ArrayList<Object> newData2 = new ArrayList<Object>();
        int i3 = 0;
        while (i3 < newData.size()) {
            if (newData.get(i3) instanceof String) {
                if (!(newData2.size() > 0 && newData2.get(newData2.size() - 1).equals(newData.get(i3)) || newData.get(i3).equals(""))) {
                    newData2.add(newData.get(i3));
                }
            } else {
                newData2.add(newData.get(i3));
            }
            ++i3;
        }
        return newData2;
    }

    private String getFirstSentence(String text) {
        BreakIterator bi = BreakIterator.getSentenceInstance();
        bi.setText(text);
        if ("".equals(text)) {
            return text;
        }
        int start = bi.first();
        int end = bi.next();
        String sentence = text.substring(start, end);
        return sentence;
    }

    private String getLastSentence(String text) {
        BreakIterator bi = BreakIterator.getSentenceInstance();
        text = String.valueOf(text) + " a";
        bi.setText(text);
        String sentence = text;
        int start = bi.first();
        int end = bi.next();
        while (end != -1) {
            sentence = text.substring(start, end);
            start = end;
            end = bi.next();
        }
        int length = sentence.length();
        if (length >= 2) {
            return sentence.substring(0, length - 2);
        }
        return "";
    }
}

