/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskworker.output;

import java.io.IOException;
import java.util.Map;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.ipc.IpcSerializationUtils;
import org.eclipse.smila.ipc.IpcFactory;
import org.eclipse.smila.ipc.IpcStreamWriter;
import org.eclipse.smila.ipc.bon.BinaryFactory;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.taskmanager.BulkInfo;
import org.eclipse.smila.taskworker.Counters;
import org.eclipse.smila.taskworker.output.Output;
import org.eclipse.smila.taskworker.output.StreamOutput;

public class RecordOutput
extends Output {
    private static final IpcFactory IPCFACTORY = new BinaryFactory();
    private final StreamOutput _streamOutput;
    private final IpcSerializationUtils _serializationUtils = new IpcSerializationUtils();
    private IpcStreamWriter _writer;
    private long _recordCount;

    public RecordOutput(BulkInfo dataObject, ObjectStoreService objectStore) {
        super(dataObject, objectStore);
        this._streamOutput = new StreamOutput(dataObject, objectStore);
    }

    public void writeRecord(Record record) throws ObjectStoreException, IOException {
        IpcStreamWriter writer = this.getStreamWriter();
        long start = this.startTime();
        this._serializationUtils.record2Stream(writer, record);
        this._streamOutput.getStream().flush();
        this.timePerform(start);
        ++this._recordCount;
    }

    public void writeAny(Any any) throws ObjectStoreException, IOException {
        IpcStreamWriter writer = this.getStreamWriter();
        long start = this.startTime();
        this._serializationUtils.any2Stream(writer, any);
        this._streamOutput.getStream().flush();
        this.timePerform(start);
        ++this._recordCount;
    }

    @Override
    public void commit() throws ObjectStoreException, IOException {
        if (this._writer != null) {
            this._writer.closeWithoutStream();
        }
        this._streamOutput.commit();
    }

    @Override
    public void abort() throws IOException {
        if (this._writer != null) {
            this._writer.closeWithoutStream();
        }
        this._streamOutput.abort();
    }

    public IpcStreamWriter getStreamWriter() throws ObjectStoreException, IOException {
        if (this._writer == null) {
            long start = this.startTime();
            this._writer = IPCFACTORY.newStreamWriter(this._streamOutput.getStream());
            this.timeOpen(start);
        }
        return this._writer;
    }

    public long getRecordCount() {
        return this._recordCount;
    }

    public long getBytesWritten() {
        return this._streamOutput.getBytesWritten();
    }

    @Override
    public Map<String, Number> getCounter() {
        Map<String, Number> counter = this._streamOutput.getCounter();
        Counters.add(counter, "recordCount", this._recordCount);
        return counter;
    }
}

