/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ipc.bon;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.smila.ipc.IpcToken;

enum BinaryToken {
    SCALAR_INT_1(IpcToken.SCALAR_INT, 0, 1, false),
    SCALAR_INT_2(IpcToken.SCALAR_INT, 1, 2, false),
    SCALAR_INT_3(IpcToken.SCALAR_INT, 2, 3, false),
    SCALAR_INT_4(IpcToken.SCALAR_INT, 3, 4, false),
    SCALAR_INT_5(IpcToken.SCALAR_INT, 4, 5, false),
    SCALAR_INT_6(IpcToken.SCALAR_INT, 5, 6, false),
    SCALAR_INT_7(IpcToken.SCALAR_INT, 6, 7, false),
    SCALAR_INT_8(IpcToken.SCALAR_INT, 7, 8, false),
    SCALAR_INT_1_N(IpcToken.SCALAR_INT, 8, 1, true),
    SCALAR_INT_2_N(IpcToken.SCALAR_INT, 9, 2, true),
    SCALAR_INT_3_N(IpcToken.SCALAR_INT, 10, 3, true),
    SCALAR_INT_4_N(IpcToken.SCALAR_INT, 11, 4, true),
    SCALAR_INT_5_N(IpcToken.SCALAR_INT, 12, 5, true),
    SCALAR_INT_6_N(IpcToken.SCALAR_INT, 13, 6, true),
    SCALAR_INT_7_N(IpcToken.SCALAR_INT, 14, 7, true),
    SCALAR_INT_8_N(IpcToken.SCALAR_INT, 15, 8, true),
    SCALAR_BOOL_TRUE(IpcToken.SCALAR_BOOL, 16, 0, false),
    SCALAR_BOOL_FALSE(IpcToken.SCALAR_BOOL, 17, 0, false),
    SCALAR_DOUBLE(IpcToken.SCALAR_DOUBLE, 19, 8, false),
    SCALAR_STRING_1(IpcToken.SCALAR_STRING, 21, 1, false),
    SCALAR_STRING_2(IpcToken.SCALAR_STRING, 22, 2, false),
    SCALAR_STRING_3(IpcToken.SCALAR_STRING, 23, 3, false),
    SCALAR_STRING_4(IpcToken.SCALAR_STRING, 24, 4, false),
    OBJECT_START(IpcToken.OBJECT_START, 25, 0, false),
    OBJECT_END(IpcToken.OBJECT_END, 28, 0, false),
    SEQUENCE_START(IpcToken.SEQUENCE_START, 29, 0, false),
    SEQUENCE_END(IpcToken.SEQUENCE_END, 30, 0, false),
    MAPPING_START(IpcToken.MAPPING_START, 31, 0, false),
    MAPPING_END(IpcToken.MAPPING_END, 32, 0, false);

    private static final Map<Byte, BinaryToken> REVERSE_LOOKUP;
    private final IpcToken _ipcToken;
    private final byte _byteValue;
    private final int _valueLength;
    private final boolean _negativeValue;

    static {
        REVERSE_LOOKUP = new HashMap<Byte, BinaryToken>(35);
        for (BinaryToken t : EnumSet.allOf(BinaryToken.class)) {
            REVERSE_LOOKUP.put(t.byteValue(), t);
        }
    }

    private BinaryToken(IpcToken ipcToken, byte value, int length, boolean negative) {
        this._byteValue = value;
        this._valueLength = length;
        this._ipcToken = ipcToken;
        this._negativeValue = negative;
    }

    public byte byteValue() {
        return this._byteValue;
    }

    public int valueLength() {
        return this._valueLength;
    }

    public IpcToken asIpcToken() {
        return this._ipcToken;
    }

    public static BinaryToken getToken(int byteValue) {
        return REVERSE_LOOKUP.get((byte)byteValue);
    }

    public boolean hasValue() {
        return this._valueLength > 0;
    }

    public boolean hasNegativeValue() {
        return this._negativeValue;
    }
}

